; HD44780 compatible LCD module handling include file for PIC18 devices
;
; LCD module pinout:
;  1 - GND
;  2 - VCC
;  3 - Vo
;  4 - RS
;  5 - R/-W
;  6 - E
;  7 - DB0
;  8 - DB1
;  9 - DB2
; 10 - DB3
; 11 - DB4
; 12 - DB5
; 13 - DB6
; 14 - DB7

; Requires definitions:
;	SYSCLK
;	LCD_E_TRIS
;	LCD_RS_TRIS
;	LCD_DB7_TRIS
;	LCD_DB6_TRIS
;	LCD_DB5_TRIS
;	LCD_DB4_TRIS
;	LCD_E
;	LCD_RS
;	LCD_DB7
;	LCD_DB6
;	LCD_DB5
;	LCD_DB4

; Provides routines:
;	LCD_DELAY
;	LCD_HARD_INIT
;	LCD_INIT_DISPLAY
;	LCD_SEND_CHAR
;	LCD_SEND_CMD
;	LCD_SEND_CHAR_NODLY
;	LCD_SEND_CMD_NODLY

;
; LCD Module commands
;

LCD_DISP_ON			EQU		0x00C			; Display on
LCD_DISP_ON_C		EQU		0x00E			; Display on, Cursor on
LCD_DISP_ON_B		EQU		0x00D			; Display on, Blink on
LCD_DISP_ON_CB		EQU		0x00F			; Display on, Cursor on, Blink cursor
LCD_DISP_OFF		EQU		0x008			; Display off
LCD_CLEAR			EQU		0x001			; Clear the Display
LCD_HOME			EQU		0x002			; Return home
LCD_ENTRY_INC		EQU		0x006			;
LCD_ENTRY_INC_S		EQU		0x007			;
LCD_ENTRY_DEC		EQU		0x004			;
LCD_ENTRY_DEC_S		EQU		0x005			;
LCD_DDRAM			EQU		0x080			; Least Significant 7-bit are for address
LCD_CGRAM			EQU		0x040			; Character generator base address

LCD_DATA	udata_acs

LCD_TEMP		res	1
LCD_CHAR		res	1
LCD_TEMPDLY		res	1

LCD_CODE	code
;
; Initilize the LCD Display Module
;

CYC_EN	macro
		BSF     LCD_E			;toggle E for LCD
		variable	d
d = SYSCLK / D'4000000'
		while	d>0
		nop
d -= 1
		endw
		BCF     LCD_E			;toggle E for LCD
d = SYSCLK / D'4000000'
		while	d>0
		nop
d -= 1
		endw
		endm

LCD_HARD_INIT
			movwf	LCD_TEMP
			bcf		LCD_DB7_TRIS
			bcf		LCD_DB6_TRIS
			bcf		LCD_DB5_TRIS
			bcf		LCD_DB4_TRIS

			bcf		LCD_RS_TRIS
			bcf		LCD_E_TRIS

			bcf		LCD_RS

			movlw	.250
			call	LCD_DELAY		; 25ms

			movlw	0x30
			call	LCD_SETBITS
			CYC_EN
			movlw	.250
			call	LCD_DELAY		; 25ms

			CYC_EN
			movlw	.250
			call	LCD_DELAY		; 25ms

			CYC_EN
			movlw	.250
			call	LCD_DELAY		; 25ms

			movlw	0x20
			call	LCD_SETBITS
			CYC_EN
			movlw	.250
			call	LCD_DELAY		; 25ms

			movf	LCD_TEMP,w
			andlw	B'00001100'
			iorlw	B'00100000'
            CALL    LCD_SEND_CMD
			movlw	.250
			call	LCD_DELAY		; 25ms

;
LCD_INIT_DISPLAY
            MOVLW   LCD_DISP_ON             ; Display On, Cursor Off
            CALL    LCD_SEND_CMD            ; Send This command to the Display Module

            MOVLW   LCD_CLEAR	            ; Clear the Display
            CALL    LCD_SEND_CMD            ; Send This command to the Display Module

            MOVLW   LCD_ENTRY_INC           ; Set Entry Mode Inc., No shift
            CALL    LCD_SEND_CMD            ; Send This command to the Display Module

            MOVLW   LCD_HOME
            CALL    LCD_SEND_CMD

            RETURN
;
;
;*******************************************************************
;* The LCD Module Subroutines                                      *
;*******************************************************************

LCD_SETBITS
			bcf		LCD_DB4
			bcf		LCD_DB5
			bcf		LCD_DB6
			bcf		LCD_DB7
			MOVWF	LCD_CHAR
			BTFSC	LCD_CHAR,7
			BSF		LCD_DB7
			BTFSC	LCD_CHAR,6
			BSF		LCD_DB6
			BTFSC	LCD_CHAR,5
			BSF		LCD_DB5
			BTFSC	LCD_CHAR,4
			BSF		LCD_DB4
			return

LCD_SEND_CMD_NODLY
			CALL	LCD_SETBITS
            BCF     LCD_RS			;Set LCD to command mode
			CYC_EN
            SWAPF   LCD_CHAR, w
			CALL	LCD_SETBITS
			CYC_EN
			return

LCD_SEND_CMD
			call	LCD_SEND_CMD_NODLY
			MOVLW	.30		; 3ms

LCD_DELAY   MOVWF   LCD_TEMPDLY
LCD_DLY_LOOP2
            CALL	LCD_DELAY_100
			DECFSZ  LCD_TEMPDLY,F
            GOTO    LCD_DLY_LOOP2
			RETURN

LCD_SEND_CHAR_NODLY
			CALL	LCD_SETBITS
            BSF     LCD_RS			;Set LCD to data mode
			CYC_EN
            SWAPF   LCD_CHAR, w
			CALL	LCD_SETBITS
			CYC_EN
			return

LCD_SEND_CHAR
			call	LCD_SEND_CHAR_NODLY

LCD_DELAY_100
; delay 100us at almost every system clock
	variable	d
d = (SYSCLK / D'40000' - D'4') / D'3'
	if d > 0 
			MOVLW	d
            MOVWF   LCD_CHAR
LCD_DLY_LOOP
            DECFSZ  LCD_CHAR,F
            GOTO    LCD_DLY_LOOP
	else
d = SYSCLK / D'40000' - D'1'
	while	d>0
			nop
d -= 1
	endw
	endif
			RETURN

