;==========================================================================
;
;   IMPORTANT: For the PIC18 devices, the __CONFIG directive has been
;              superseded by the CONFIG directive.  The following settings
;              are available for this device.
;
;   Oscillator Selection bits:
;     OSC = LP             LP Oscillator
;     OSC = XT             XT Oscillator
;     OSC = HS             HS Oscillator
;     OSC = RC             External RC oscillator, CLKO function on RA6
;     OSC = EC             EC oscillator, CLKO function on RA6
;     OSC = ECIO           EC oscillator, port function on RA6
;     OSC = HSPLL          HS oscillator, PLL enabled (Clock Frequency = 4 x FOSC1)
;     OSC = RCIO           External RC oscillator, port function on RA6
;     OSC = INTIO2         Internal oscillator block, port function on RA6 and RA7
	config	OSC = INTIO2
;     OSC = INTIO1         Internal oscillator block, CLKO function on RA6, port function on RA7
;
;   Fail-Safe Clock Monitor Enable bit:
;     FCMEN = OFF          Fail-Safe Clock Monitor disabled
;     FCMEN = ON           Fail-Safe Clock Monitor enabled
	config	FCMEN = ON
;
;   Internal/External Oscillator Switchover bit:
;     IESO = OFF           Oscillator Switchover mode disabled
	config	IESO = OFF
;     IESO = ON            Oscillator Switchover mode enabled
;
;   Power-up Timer Enable bit:
;     PWRT = ON            PWRT enabled
;     PWRT = OFF           PWRT disabled
	config	PWRT = OFF
;
;   Brown-out Reset Enable bits:
;     BOR = OFF            Brown-out Reset disabled in hardware and software
	config	BOR = OFF
;     BOR = SOFT           Brown-out Reset enabled and controlled by software (SBOREN is enabled)
;     BOR = NOSLP          Brown-out Reset enabled in hardware only and disabled in Sleep mode (SBOREN is disabled)
;     BOR = ON             Brown-out Reset enabled in hardware only (SBOREN is disabled)
;
;   Brown-out Reset Voltage bits:
;     BORV = 0             Maximum Setting
	config	BORV = 0
;     BORV = 1             
;     BORV = 2             
;     BORV = 3             Minimum Setting
;
;   Watchdog Timer Enable bit:
;     WDT = OFF            WDT disabled (control is placed on the SWDTEN bit)
	config	WDT = OFF
;     WDT = ON             WDT enabled
;
;   Watchdog Timer Postscale Select bits:
;     WDTPS = 1            1:1
;     WDTPS = 2            1:2
;     WDTPS = 4            1:4
;     WDTPS = 8            1:8
;     WDTPS = 16           1:16
;     WDTPS = 32           1:32
;     WDTPS = 64           1:64
;     WDTPS = 128          1:128
;     WDTPS = 256          1:256
;     WDTPS = 512          1:512
;     WDTPS = 1024         1:1024
;     WDTPS = 2048         1:2048
;     WDTPS = 4096         1:4096
;     WDTPS = 8192         1:8192
;     WDTPS = 16384        1:16384
;     WDTPS = 32768        1:32768
	config	WDTPS = 32768
;
;   MCLR Pin Enable bit:
;     MCLRE = OFF          RE3 input pin enabled; MCLR disabled
	config	MCLRE = OFF
;     MCLRE = ON           MCLR pin enabled; RE3 input pin disabled
;
;   Low-Power Timer1 Oscillator Enable bit:
;     LPT1OSC = OFF        Timer1 configured for higher power operation
	config	LPT1OSC = OFF
;     LPT1OSC = ON         Timer1 configured for low-power operation
;
;   PORTB A/D Enable bit:
;     PBADEN = DIG         PORTB<4:0> pins are configured as digital I/O on Reset
	config	PBADEN = DIG
;     PBADEN = ANA         PORTB<4:0> pins are configured as analog input channels on Reset
;
;   CCP2 MUX bit:
;     CCP2MX = RB3         CCP2 input/output is multiplexed with RB3
;     CCP2MX = RC1         CCP2 input/output is multiplexed with RC1
	config	CCP2MX = RC1
;
;   Stack Full/Underflow Reset Enable bit:
;     STVREN = OFF         Stack full/underflow will not cause Reset
	config	STVREN = OFF
;     STVREN = ON          Stack full/underflow will cause Reset
;
;   Single-Supply ICSP Enable bit:
;     LVP = OFF            Single-Supply ICSP disabled
	config	LVP = OFF
;     LVP = ON             Single-Supply ICSP enabled
;
;   Boot Block Size Select bits:
;     BBSIZ = BB256         256 Word
	config	BBSIZ = BB256
;     BBSIZ = BB512         512 Word
;     BBSIZ = BB1K         1024 Word
;
;   Extended Instruction Set Enable bit:
;     XINST = OFF          Instruction set extension and Indexed Addressing mode disabled (Legacy mode)
	config	XINST = OFF
;     XINST = ON           Instruction set extension and Indexed Addressing mode enabled
;
;   Background Debugger Enable bit:
;     DEBUG = ON           Background debugger enabled, RB6 and RB7 are dedicated to In-Circuit Debug
;     DEBUG = OFF          Background debugger disabled, RB6 and RB7 configured as general purpose I/O pins
	config	DEBUG = OFF
;
;   Code Protection bit Block 0:
;     CP0 = ON             Block 0 code-protected
;     CP0 = OFF            Block 0 not code-protected
	config	CP0 = OFF
;
;   Code Protection bit Block 1:
;     CP1 = ON             Block 1 code-protected
;     CP1 = OFF            Block 1 not code-protected
	config	CP1 = OFF
;
;   Boot Block Code Protection bit:
;     CPB = ON             Boot block code-protected
;     CPB = OFF            Boot block not code-protected
	config	CPB = OFF
;
;   Data EEPROM Code Protection bit:
;     CPD = ON             Data EEPROM code-protected
;     CPD = OFF            Data EEPROM not code-protected
	config	CPD = OFF
;
;   Write Protection bit Block 0:
;     WRT0 = ON            Block 0 write-protected
	config	WRT0 = ON
;     WRT0 = OFF           Block 0 not write-protected
;
;   Write Protection bit Block 1:
;     WRT1 = ON            Block 1 write-protected
	config	WRT1 = ON
;     WRT1 = OFF           Block 1 not write-protected
;
;   Configuration Register Write Protection bit:
;     WRTC = ON            Configuration registers (300000-3000FFh) write-protected
	config	WRTC = ON
;     WRTC = OFF           Configuration registers (300000-3000FFh) not write-protected
;
;   Boot Block Write Protection bit:
;     WRTB = ON            Boot block write-protected
	config	WRTB = ON
;     WRTB = OFF           Boot block not write-protected
;
;   Data EEPROM Write Protection bit:
;     WRTD = ON            Data EEPROM write-protected
;     WRTD = OFF           Data EEPROM not write-protected
	config	WRTD = OFF
;
;   Table Read Protection bit Block 0:
;     EBTR0 = ON           Block 0 protected from table reads executed in other blocks
;     EBTR0 = OFF          Block 0 not protected from table reads executed in other blocks
	config	EBTR0 = OFF
;
;   Table Read Protection bit Block 1:
;     EBTR1 = ON           Block 1 protected from table reads executed in other blocks
;     EBTR1 = OFF          Block 1 not protected from table reads executed in other blocks
	config	EBTR1 = OFF
;
;   Boot Block Table Read Protection bit:
;     EBTRB = ON           Boot block protected from table reads executed in other blocks
;     EBTRB = OFF          Boot block not protected from table reads executed in other blocks
	config	EBTRB = OFF
