#include "p18f2321.inc"
#include "PIC_config.inc"

#include "32bit_math_18.h"

SYSCLK		equ	D'8000000'	; in Hertzes
TMR0RATE	equ	D'10000'	; in Hertzes
BAUDRATE	equ	D'19200'	; in bits per second

TXBUFLEN	equ	D'80'		; in bytes

; calculating SPBRG for BRG16=0 and BRGH=1
SPBRG_value = (SYSCLK/BAUDRATE/D'16') - 1

; timer0 reload value for desired rate
tmr0r	equ	D'256' - (SYSCLK/TMR0RATE/D'4') + 1 
t100r	equ	(TMR0RATE/.100)
t10r	equ	.10


; LCD module wiring definitions
#define		LCD_E_TRIS		TRISC,5
#define		LCD_RS_TRIS		TRISC,4
#define		LCD_DB7_TRIS	TRISB,0
#define		LCD_DB6_TRIS	TRISB,1
#define		LCD_DB5_TRIS	TRISB,2
#define		LCD_DB4_TRIS	TRISB,3

#define		LCD_E			PORTC,5
#define		LCD_RS			PORTC,4
#define		LCD_DB7			PORTB,0
#define		LCD_DB6			PORTB,1
#define		LCD_DB5			PORTB,2
#define		LCD_DB4			PORTB,3

; HD44780 LCD routines
#include "HD_LCD_18.INC"


#define	LCD_ROWS	D'2'
#define	LCD_COLS	D'8'

	udata_acs
; bitwide variables
flags	res	1

; interrupt context save area
FSR0L_TEMP	res	1
FSR0H_TEMP	res	1
BSR_TEMP	res	1
W_TEMP		res	1
STATUS_TEMP	res	1

t10cnt	res	1
t100cnt	res	1
cnt1	res	1
cnt2	res	1
lcd_dly	res	1
lcd_ptr	res	1
tmp		res	1
ttmp	res	1
htmp	res	1
tcnt	res	1
tcnt1	res	1
txptri	res	1
txptro	res	1

res_lo			res	1	; A/D result low
res_hi			res	1	; A/D result high
resf_lo			res	1	; filtered A/D result low
resf_hi			res	1	; filtered A/D result high

; xv0,xv1 are 32-bit regs
xv00			res	1
xv01			res	1
xv02			res	1
xv03			res	1
xv10			res	1
xv11			res	1
xv12			res	1
xv13			res	1
; yv1, yv2 are 32-bit regs
yv10			res	1
yv11			res	1
yv12			res	1
yv13			res	1
yv20			res	1
yv21			res	1
yv22			res	1
yv23			res	1
; sss is a 32-bit temporary reg
sss0			res	1
sss1			res	1
sss2			res	1
sss3			res	1


; banked data: puffers
	udata
lcd_buf	res	LCD_ROWS*LCD_COLS
tx_buf	res	TXBUFLEN



; bit variable definitions
#define	lcd_phase	flags,0
#define	tick		flags,1


; macros
unpack32	MACRO	Var,Address ;Var = 32 bit literal to be unpacked
	movlw	Var & H'FF'
	movwf	Address+0
	movlw	Var >>D'08' & H'FF'
	movwf	Address+1
	movlw	Var >>D'16' & H'FF'
	movwf	Address+2
	movlw	Var >>D'24' & H'FF'
	movwf	Address+3
	ENDM




resvec	code	0x0
	goto	main_start

intvec	code	0x8
	goto	int_handle


	code

int_handle
	MOVWF	W_TEMP ; W_TEMP is in virtual bank
	MOVFF	STATUS, STATUS_TEMP ; STATUS_TEMP located anywhere
	MOVFF	BSR, BSR_TEMP ; BSR_TMEP located anywhere
	movff	FSR0H,FSR0H_TEMP
	movff	FSR0L,FSR0L_TEMP

	btfss	INTCON,T0IF
	goto	no_int_tmr0

; timer0 interrupt
	bcf		INTCON,T0IF

	movlw	tmr0r+2
	addwf	TMR0L,f

	movf	lcd_dly,f
	bz		do_lcd
	decf	lcd_dly,f
	goto	tmr0_end

do_lcd
	movlw	low(lcd_buf)
	addlw	LCD_ROWS*LCD_COLS
	xorwf	lcd_ptr,w
	bnz		no_lcd_end

	movlw	LCD_HOME
	call	LCD_SEND_CMD_NODLY
	movlw	D'30'
	movwf	lcd_dly
	movlw	low(lcd_buf)
	movwf	lcd_ptr
	bcf		lcd_phase
	goto	tmr0_end

no_lcd_end
	movlw	low(lcd_buf)
	addlw	LCD_COLS
	xorwf	lcd_ptr,w
	bnz		do_lcd_chrout

	btfsc	lcd_phase
	goto	do_lcd_chrout

	bsf		lcd_phase
	movlw	LCD_DDRAM+0x40
	call	LCD_SEND_CMD_NODLY
	goto	tmr0_end

do_lcd_chrout
	movf	lcd_ptr,w
	movwf	FSR0L
	movlw	high(lcd_buf)
	movwf	FSR0H
	movf	INDF0,w
	call	LCD_SEND_CHAR_NODLY
	incf	lcd_ptr,f

tmr0_end
	decfsz	t100cnt
	goto	no_int_tmr0
	movlw	t100r
	movwf	t100cnt

	decfsz	t10cnt
	goto	no_int_tmr0
	movlw	t10r
	movwf	t10cnt
	bsf		tick

no_int_tmr0

	btfss	PIR1,TXIF
	goto	no_int_tx

; TX interrupt
	movf	txptro,w
	xorwf	txptri,w
	bnz		tx_ok	; -> buffer is not empty
	; no more chars to xmit
	bcf		PIE1,TXIE
	goto	tx_int_end

tx_ok
	movf	txptro,w
	addlw	LOW tx_buf
	movwf	FSR0L

	clrf	FSR0H
	movlw	HIGH tx_buf
	addwfc	FSR0H,f

	movf	INDF0,w
	movwf	TXREG

	incf	txptro,w
	xorlw	TXBUFLEN
	btfss	STATUS,Z
	xorlw	TXBUFLEN
	movwf	txptro	

tx_int_end

no_int_tx

	movff	FSR0L_TEMP,FSR0L
	movff	FSR0H_TEMP,FSR0H
	MOVFF	BSR_TEMP, BSR ; Restore BSR
	MOVF	W_TEMP, W ; Restore WREG
	MOVFF	STATUS_TEMP, STATUS ; Restore STATUS
	retfie


; RS232 transmit routine
rs232_tx
	movwf	tmp

	incf	txptri,w
	xorlw	TXBUFLEN
	btfss	STATUS,Z
	xorlw	TXBUFLEN

	xorwf	txptro,w
	bnz		tx_start	; buffer is not full -> begin transmit
	; buffer full
	bsf		STATUS,C
	return
	
tx_start
	movf	txptri,w
	addlw	LOW tx_buf
	movwf	FSR2L

	clrf	FSR2H
	movlw	HIGH tx_buf
	addwfc	FSR2H,f

	movf	tmp,w
	movwf	INDF2

	incf	txptri,w
	xorlw	TXBUFLEN
	btfss	STATUS,Z
	xorlw	TXBUFLEN
	movwf	txptri

	bsf		PIE1,TXIE	; enable tx int
	bcf		STATUS,C
	return



; main program entry point
main_start

	movlw	lcd_buf
	movwf	lcd_ptr
	bcf		lcd_phase
	bcf		tick

	movlw	.1
	movwf	t100cnt
	movwf	t10cnt

; 8MHz internal clock
	movlw	B'01110000'
	movwf	OSCCON

; PORTC as digital output
	CLRF	PORTC
	MOVLW	0x80
	MOVWF	TRISC

	bsf		PORTC,.3	; Yellow LED

; PORTB as digital input/output
	CLRF	PORTB
	MOVLW	07h
	MOVWF	ADCON1
	MOVLW	B'11110000'
	MOVWF	TRISB

; turn on pull-ups on PORTB
	bcf		INTCON2,RBPU

; PWM1 setup

;1. Set the PWM period by writing to the PR2
;register.
	movlw	0xfF
	movwf	PR2,A
;2. Set the PWM duty cycle by writing to the
;CCPRxL register and CCPxCON<5:4> bits.
	movlw	0xE
	movwf	CCPR1L,A
;3. Make the CCPx pin an output by clearing the
;appropriate TRIS bit.
	bcf		TRISC,CCP1,A
;4. Set the TMR2 prescale value, then enable
;Timer2 by writing to T2CON.
	movlw	B'00000011'
	movwf	T2CON,A
	bsf		T2CON,TMR2ON,A
;5. Configure the CCPx module for PWM operation.
	movlw	B'00001100'
	movwf	CCP1CON,A

; PWM2 setup

;2. Set the PWM duty cycle by writing to the
;CCPRxL register and CCPxCON<5:4> bits.
	movlw	0x80
	movwf	CCPR2L,A
;3. Make the CCPx pin an output by clearing the
;appropriate TRIS bit.
	bcf		TRISC,CCP2_PORTC,A
;5. Configure the CCPx module for PWM operation.
	movlw	B'00001100'
	movwf	CCP2CON,A


; set up A/D-s

	movlw	B'00001100'		; AN0-AN2 are analog inputs
	movwf	ADCON1
	movlw	B'00000001'		; A/D on, CH0 selected
	movwf	ADCON0

; LCD init
	movlw	.200
	call	LCD_DELAY	;	20ms
	movlw	0x28
	CALL	LCD_HARD_INIT

	MOVLW   LCD_HOME
	CALL    LCD_SEND_CMD



; set up TMR0
	movlw	tmr0r+2
	movwf	TMR0L
	bcf		T0CON,T0CS

; set up TMR0 interrupt
	bcf		INTCON,T0IF
	bsf		INTCON,T0IE
	bsf		INTCON,GIE


; set up serial port
	clrf	txptro
	clrf	txptri

	bsf		TRISC,7
	bsf		TRISC,6

	movlw	SPBRG_value
	movwf	SPBRG

	movlw	B'00000000'		; normal polarities, BRG16=0
	movwf	BAUDCON

	movlw	B'00100100'		; Transmit enable, BRGH=1
	movwf	TXSTA

	movlw	B'10010000'		; USART enable, receiver enable
	movwf	RCSTA

	bsf		INTCON,PEIE		; prepare TX int.


; say hello on display
	call	disp_clr

	movlw	'H'
	call	disp_out
	movlw	'e'
	call	disp_out
	movlw	'l'
	call	disp_out
	movlw	'l'
	call	disp_out
	movlw	'o'
	call	disp_out
	movlw	' '
	call	disp_out
	movlw	'W'
	call	disp_out
	movlw	'o'
	call	disp_out
	movlw	'r'
	call	disp_out
	movlw	'l'
	call	disp_out
	movlw	'd'
	call	disp_out
	movlw	'!'
	call	disp_out

; say hello on RS232

	movlw	'O'
	call	rs232_tx
	movlw	'K'
	call	rs232_tx

main_loop
	btfss	tick
	goto	main_loop
	bcf		tick

	call	disp_home

	movlw	0x10
	addwf	CCPR1L,f

	swapf	PORTB,w
	andlw	B'00001111'
	addlw	'A'
	call	disp_out

	btfss	PORTB,.5
	bcf		PORTC,.3

	movlw	'.'
	call	disp_out
	movlw	'.'
	call	disp_out

	call	gettemp

	movf	res_lo,w
	movwf	REGA0
	movf	res_hi,w
	movwf	REGA1
	clrf	REGA2
	clrf	REGA3
	call	bin2dec
	movlw	D'4'
	call	disp_num

	movlw	'.'
	call	disp_out
	movlw	'.'
	call	disp_out

	movf	resf_lo,w
	movwf	REGA0
	movf	resf_hi,w
	movwf	REGA1
	clrf	REGA2
	clrf	REGA3
	call	bin2dec
	movlw	D'4'
	call	disp_num

	movlw	'!'
	call	disp_out

	goto	main_loop


; gettemp
; measuring temperature of soldering iron
gettemp

	movlw	B'10101101'		; Right, 8Tad, 16Tosc
	movwf	ADCON2

	movlw	B'00000001'		; A/D on, CH0 selected
	movwf	ADCON0
	bsf		ADCON0,GO
wad0
	btfsc	ADCON0,DONE
	goto	wad0

	movf	ADRESL,w
	movwf	REGB0
	movf	ADRESH,w
	movwf	REGB1
	clrf	REGB2
	clrf	REGB3

	unpack32	D'4073',REGA0	; 0.1uV
	call	multiply
	unpack32	D'2100',REGB0	; uV/deg -> 10* deg. value
	call	divide
	unpack32	D'780',REGB0
	call	subtract
	call	negatea

	; store ambient temperature in 1/10th Celsius
	call	rega_sss

	movlw	B'00000101'		; A/D on, CH1 selected
	movwf	ADCON0
	bsf		ADCON0,GO
wad1
	btfsc	ADCON0,DONE
	goto	wad1

	movf	ADRESL,w
	movwf	REGB0
	movf	ADRESH,w
	movwf	REGB1
	clrf	REGB2
	clrf	REGB3


	movlw	B'00001001'		; A/D on, CH2 selected
	movwf	ADCON0
	bsf		ADCON0,GO
wad2
	btfsc	ADCON0,DONE
	goto	wad2

	movf	ADRESL,w
	movwf	REGA0
	movf	ADRESH,w
	movwf	REGA1
	clrf	REGA2
	clrf	REGA3

	call	subtract

	unpack32	D'48392',REGB0	; 0.001uV
	call	multiply
	unpack32	D'6800',REGB0	; 0.01uV/deg -> 10* deg. value
	call	divide
	; 1/10th Celsius differential temperature on thermocouple

	; add ambient temperature
	call	sss_regb
	call	add

	movf	REGA0,w
	movwf	res_lo
	movf	REGA1,w
	movwf	res_hi


;#define NZEROS 2
;#define NPOLES 2
;#define GAIN   6.701159077e+02
;
;static float xv[NZEROS+1], yv[NPOLES+1];
;
;static void filterloop()
;  { for (;;)
;      { xv[0] = xv[1]; xv[1] = xv[2]; 
;        xv[2] = next input value / GAIN;
;        yv[0] = yv[1]; yv[1] = yv[2]; 
;        yv[2] =   (xv[0] + xv[2]) + 2 * xv[1]
;                     + ( -0.8706834551 * yv[0]) + (  1.8647143385 * yv[1]);
;        next output value = yv[2];
;      }
;  }


;digital filtering input value
;xs = xv0+xv1+{next input}			; G x value, 16 bit
;
;	{next input} -> rega
	movf	res_lo,w
	movwf	REGA0
	movf	res_hi,w
	movwf	REGA1
	clrf	WREG
	btfsc	REGA1,7
	decf	WREG
	movwf	REGA2
	movwf	REGA3
	
;	xv0 -> regb
	movf	xv00,w
	movwf	REGB0
	movf	xv01,w
	movwf	REGB1
	movf	xv02,w
	movwf	REGB2
	movf	xv03,w
	movwf	REGB3
;	add
	call	add
;	xv1 -> regb
	movf	xv10,w
	movwf	REGB0
	movf	xv11,w
	movwf	REGB1
	movf	xv12,w
	movwf	REGB2
	movf	xv13,w
	movwf	REGB3
;	add
	call	add
;
;xv0 = xv1/2					; G x value, 16 bit
;
;	shr xv1 -> xv0
	rlcf	xv13,w
	rrcf	xv13,w
	movwf	xv03
	rrcf	xv12,w
	movwf	xv02
	rrcf	xv11,w
	movwf	xv01
	rrcf	xv10,w
	movwf	xv00
;
;xv1 = {next input}*2				; G x value, 16 bit
;
;	shl {next input} -> xv1
	bcf		STATUS,C
	rlcf	res_lo,w
	movwf	xv10
	rlcf	res_hi,w
	movwf	xv11
	clrf	WREG
	btfsc	STATUS,C
	decf	WREG
	movwf	xv12
	movwf	xv13
;
;ys = int(20050*xs -641*yv1 + 1561*yv2)		; 1 000 000 x value, 32 bit
;	/1000					; 1 000 x value, 24 bit
;
;	20050 -> regb
	unpack32	D'150',REGB0
;	mul
	call	multiply
	unpack32	D'1',REGB0
;	mul
	call	divide

;	rega -> sss
	call	rega_sss
;
;	-641 -> rega
	unpack32	-D'8707',REGA0
;	yv1 -> regb
	movf	yv10,w
	movwf	REGB0
	movf	yv11,w
	movwf	REGB1
	movf	yv12,w
	movwf	REGB2
	movf	yv13,w
	movwf	REGB3
;	mul
	call	multiply
;
;	sss -> regb
	call	sss_regb
;	add
	call	add
;	rega -> sss
	call	rega_sss
;
;	1561 -> rega
	unpack32	D'18647',REGA0
;	yv2 -> regb
	movf	yv20,w
	movwf	REGB0
	movf	yv21,w
	movwf	REGB1
	movf	yv22,w
	movwf	REGB2
	movf	yv23,w
	movwf	REGB3
;	mul
	call	multiply
;
;	sss -> regb
	call	sss_regb
;	add
	call	add
;
;	1000 -> regb
	unpack32	D'10000',REGB0
;	div
	call	divide
;
;yv1 = yv2					; 1 000 x value, 24 bit
;yv2 = ys					; 1 000 x value, 24 bit
;
;	yv2 -> yv1
	movf	yv20,w
	movwf	yv10
	movf	yv21,w
	movwf	yv11
	movf	yv22,w
	movwf	yv12
	movf	yv23,w
	movwf	yv13
;	rega -> yv2
	movf	REGA0,w
	movwf	yv20
	movf	REGA1,w
	movwf	yv21
	movf	REGA2,w
	movwf	yv22
	movf	REGA3,w
	movwf	yv23
;
;{next output} = yv[2]/1000
;

	unpack32	D'10',REGB0
;	div
	call	divide

;	rega -> {next output}
	movf	REGA0,w
	movwf	resf_lo
	movf	REGA1,w
	movwf	resf_hi
;;
; xv0,xv1 are 16-bit regs
; sss is a 32-bit reg
; yv1, yv2 are 24-bit regs
;

; filtered A/D result is in (resf_hi,resf_lo)
	return



; utility routines

; copy REGA to sss
rega_sss
	movf	REGA0,w
	movwf	sss0
	movf	REGA1,w
	movwf	sss1
	movf	REGA2,w
	movwf	sss2
	movf	REGA3,w
	movwf	sss3
	return

; copy sss to REGA
sss_rega
	movf	sss0,w
	movwf	REGA0
	movf	sss1,w
	movwf	REGA1
	movf	sss2,w
	movwf	REGA2
	movf	sss3,w
	movwf	REGA3
	return

; copy REGB to sss
regb_sss
	movf	REGB0,w
	movwf	sss0
	movf	REGB1,w
	movwf	sss1
	movf	REGB2,w
	movwf	sss2
	movf	REGB3,w
	movwf	sss3
	return

; copy sss to REGB
sss_regb
	movf	sss0,w
	movwf	REGB0
	movf	sss1,w
	movwf	REGB1
	movf	sss2,w
	movwf	REGB2
	movf	sss3,w
	movwf	REGB3
	return


; display routines
disp_num
	movwf	tmp
	movlw	LOW DIGIT1
	movwf	FSR0L
	movlw	HIGH DIGIT1
	movwf	FSR0H

	movlw	.10
	movwf	tcnt
	movf	tmp,w
	sublw	.10
	movwf	tcnt1
	bz		wr_loop
	
wr_l1
	movf	INDF0,w
	bnz		wr_loop
	incf	FSR0L,f
	decf	tcnt,f
	decfsz	tcnt1,f
	goto	wr_l1

wr_loop
	movf	INDF0,w
	addlw	'0'
	call	disp_out
	incf	FSR0L,f
	decfsz	tcnt,f
	goto	wr_loop

	return

disp_clr
	movlw	high(lcd_buf)
	movwf	FSR1H
	movlw	low(lcd_buf)
	movwf	FSR1L

	movlw	LCD_ROWS*LCD_COLS
	movwf	cnt1
	movlw	'.'
lcd_clr
	movwf	POSTINC1
	decfsz	cnt1,f
	goto	lcd_clr

disp_home
	movlw	high(lcd_buf)
	movwf	FSR1H
	movlw	low(lcd_buf)
	movwf	FSR1L

	return


disp_out
	movwf	tmp
	call	rs232_tx

	movlw	low(lcd_buf)
	addlw	LCD_ROWS*LCD_COLS
	subwf	FSR1L,w

	btfsc	STATUS,Z
	return

	movf	tmp,w
	movwf	POSTINC1

	return

disp_hexout2
	movwf	htmp
	swapf	WREG,w
	call	disp_hexout1
	movf	htmp,w
disp_hexout1
	clrf	TBLPTRH
	clrf	TBLPTRU
	andlw	0x0f
	addlw	LOW hextable
	movwf	TBLPTRL
	movlw	HIGH hextable
	addwfc	TBLPTRH,f
	movlw	UPPER hextable
	addwfc	TBLPTRU,f
	tblrd	*
	movf	TABLAT,w
	goto	disp_out

hextable
	data   "0123456789ABCDEF"


	end
