;******************************************************************************
;***************************** Macro Definintions *****************************

SET_BANK0 MACRO
	bcf FSR, 5
	ENDM

SET_BANK1 MACRO
	bsf FSR, 5
	ENDM

; When HiZ, pullups on board will drive SDA SCL high
SCL2HIZ MACRO
	banksel 	TRISIO
	bsf 		TRISIO, SCL		;Set bit in TRISIO to input (HiZ)
	banksel 	GPIO
	bcf			GPIO, SCL		;set corresponding bit in GPIO to 0 (does not matter 1 or 0)
	endm

SDA2HIZ MACRO
	banksel 	TRISIO
	bsf 		TRISIO, SDA		;Set bit in TRISIO to input (HiZ)
	banksel 	GPIO
	bcf			GPIO, SDA		;set corresponding bit in GPIO to 0 (does not matter 1 or 0)
	endm

; When driven, always drive GPIO to 0 (the high is the HiZ with pullups state)
SCL2DVR MACRO
	banksel 	TRISIO
	bcf 		TRISIO, SCL		;UnSet bit in TRISIO (output)
	banksel 	GPIO
	bcf			GPIO, SCL		;Unset corresponding bit in GPIO to 0
	endm

SDA2DVR MACRO
	banksel 	TRISIO
	bcf 		TRISIO, SDA		;UnSet bit in TRISIO
	banksel 	GPIO
	bcf			GPIO, SDA		;Unset corresponding bit in GPIO to 0
	endm

I2C_ERROR_TEST MACRO
	movwf TEMP				;save ACK info.  (stop has NOT been done yet)

	movlw 0x01
	movwf I2C_FLAG			;set flag

	movf TEMP, W			;recall I2C_WRITE ACK/NACK info to W

	xorlw 0xFA				;is a nack returned?  -if nack then Z=1
	btfsc STATUS, Z			;Test zero bit in status reg., if 0 then skip
	;LED2HIZ

	;xorlw 0xFA				;FA returned from I2C_ERROR -then Z=1
	;btfsc STATUS, Z		;did I2C error routine run? 
	goto LOOP				;yes
	ENDM




