
;**********************************************************************
;                                                                     *
;    Filename:	    ADCcomp.asm                                       *
;    Date:          02/21/2007                                        *
;    File Version:  V2                                                *
;                                                                     *
;    Author:        Hrishikesh Shinde                                 *
;    Company:       Dallas Semiconductor/Maxim                        *
;                                                                     *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Files required: 
;					blinkmacros.inc                                   *
;                   I2Cmacros.inc                                     *
;                   P12F683.inc                                       *
;                                                                     *
;**********************************************************************
;                                                                     *
;    Notes:                                                           *
;                                                                     *
;                                                                     *
;                                                                     *
;                                                                     *
;**********************************************************************

	list      p=12F683        	; list directive to define processor
	#include <p12F683.inc>    	; processor specific variable definitions
	#include <blinkmacros.inc>  ; user created macros
	#include <I2Cmacros.inc>	; macros for I2C

	errorlevel  -302          ; suppress message 302 from list file

	__CONFIG   _FCMEN_ON & _IESO_OFF & _CP_OFF & _CPD_OFF & _BOD_OFF & _MCLRE_OFF & _WDT_OFF & _PWRTE_ON & _INTRC_OSC_NOCLKOUT 

;*************************** Variable Declarations ***********************
udata										; Allocates space for variables in relocatable code
CONTROL_BYTE_W  	EQU		0x50     		; Control byte for I2C writting
CONTROL_BYTE_R  	EQU		0x51     		; Control byte for I2C reading

SCL 				EQU     0x04			;SCL set to GPIO4
SDA					EQU     0x05			;SDA set to GPIO5
LED					EQU     0x00			; BIT/GPIO # used for setting a bit in the form 0<b<7

DELAY_VAL_MS		RES		1	 			; Allocate bank0 RAM for delay sub variable
DELAY_VAL_US		RES		1				; Allocate bank0 RAM for delay sub variable

I2C_WORD			RES     1				; Alocate bank0 RAM for I2C data byte
I2C_BIT_CNTR		RES		1				; Alocate bank0 RAM for I2C bit counter
COMMAND_BYTE  		RES		1				; ALOCATE bank0 RAM for I2C command byte, used to set POT0/1 
I2C_FLAG  			EQU		0x0F			; ALOCATE bank0 RAM for RD Flag,  bit 0 used to trigger an I2C read  
ADC_DATA_BYTE		RES		1				; Data byte from the ADC
TEMP				RES		1
POT_SEL				RES		1
;RES can only be used with relocatable code
									
;**************************************************************************
;	BUFR_LENGTH=0x10 
;	goto 		MAIN

;*************************************************************************
MAIN	CODE 	0x20			; CODE start relocatable code 

; remaining code goes here

	banksel		GPIO 			;GPIO and CMCOM0 are in bank 0
	clrf		GPIO			;Init GPIO
	movlw		07h 
	movwf		CMCON0 			;Set GP<2:0> to digital I/O (register 8.1)
	banksel		ANSEL 			;ANSEL AND TRISIO are in bank 1
 	clrf		ANSEL 			;Set everything to digital I/O
	clrf		TRISIO
	
BLINK
	BLINK_LED_3X				; Declared in blinkmacros.inc
	;goto		BLINK

CONFIG_OSC
	banksel		OSCCON
	movlw		b'00010001'
	movwf		OSCCON 			; internal oscillator, 125 KHz. 

CONFIG_I2C
	call 		I2C_RESET	 	;reset the I2C bus
	movlw		08h 			;set the counter to count 8 times 
	banksel		I2C_BIT_CNTR
	movwf		I2C_BIT_CNTR

POT0_SET
	movlw 0xAF 
	banksel		COMMAND_BYTE
	movwf 		COMMAND_BYTE	; Put AF in command byte for controlling both Pots on the DS1803

	movlw 0x00
	movwf POT_SEL				; set POT_SEL =0 flag

	call		CONFIGADC		; configure the ADC and turn it ON. 

;MAIN LOOP THAT CHECKS THE ADC AND MAKES NECESSARY CHANGES	
LOOP
	call		DELAY_MS
	LED2HIZ
	bsf			ADCON0,GO  		;Initialize new A/D conversion
	btfsc		ADCON0,GO 		;Wait for conversion to complete
	goto		$-1

;MAKE ADC DATA BYTE FOR SENDING USING THE TOP 8 BITS OF 10 BIT ADC
	banksel		STATUS
	bcf 		STATUS,0
	banksel		ADRESH
	rlf			ADRESH,1
	rlf			ADRESH,1
	rlf			ADRESH,1
	rlf			ADRESH,1
	rlf			ADRESH,1
	rlf			ADRESH,0	
	banksel		ADC_DATA_BYTE
	clrf		ADC_DATA_BYTE
	iorwf		ADC_DATA_BYTE,1	
	banksel		STATUS
	bcf 		STATUS,0
	banksel		ADRESL
	rrf			ADRESL,1
	banksel		STATUS
	bcf 		STATUS,0
	banksel		ADRESL
	rrf			ADRESL,0
	;xorlw		0xC0
	banksel		ADC_DATA_BYTE
	iorwf		ADC_DATA_BYTE,1	

I2C_SEQUENCE
	call 		I2C_START		;start
	I2C_ERROR_TEST				;Macro that tests I2C is working or not

	movlw		CONTROL_BYTE_W
	banksel		I2C_WORD
	movwf		I2C_WORD
	call		I2C_WRITE		;CONTROL BYTE
	I2C_ERROR_TEST				;Macro that tests I2C is working or not
	
	banksel		COMMAND_BYTE
	movf		COMMAND_BYTE, W 
	banksel		I2C_WORD
	movwf		I2C_WORD
	call		I2C_WRITE		;COMMAND BYTE
	I2C_ERROR_TEST				;Macro that tests I2C is working or not

	banksel		ADC_DATA_BYTE
	movf		ADC_DATA_BYTE, W
	banksel		I2C_WORD
	movwf		I2C_WORD
	call		I2C_WRITE		;POT DATA
	I2C_ERROR_TEST				;Macro that tests I2C is working or not

	call 		I2C_STOP		;stop

	call		DELAY_MS
	LED2DVR

	goto		LOOP


;********************************************************************************************
;********************************  I2C START SUBROUTINE  ************************************
I2C_START:	
	SDA2HIZ				; hI Z for SDA (SDA=1)
	nop
	nop
	nop
	SCL2HIZ				; hI Z for SCL (SCL=1)
	nop
	SDA2DVR				; SDA now driven low (SDA=0)
	nop					; I2C START is done, now get SCL=0 for clk pulses
	SCL2DVR				; SCL now driven low (SCL=0)
	retlw 		0XB0	; Return with B0.  (SDA=0)& (SCL=0)

;********************************************************************************************
;********************************  I2C STOP SUBROUTINE **************************************
I2C_STOP:
	banksel		TEMP
	movwf 		TEMP	; save retlw value during I2C_WRITE sub. (ACK info from WRITE)
	SCL2DVR				; SCL now driven low (SCL=0)
	nop
	SDA2DVR				; SDA now driven low (SDA=0)
	nop
	nop
	nop
	SCL2HIZ				; hI Z for SCL (SCL=1)
	nop
	nop
	nop
	SDA2HIZ				; hI Z for SDA (SDA=1) *Actuall I2C STOP command
	retlw 		0xB3

;********************************************************************************************
;********************************  I2C READ SUBROUTINE **************************************
I2C_READ:
	banksel		I2C_WORD
	clrf 		I2C_WORD	; 0x00 to read register
	movlw 0x08		
	banksel I2C_BIT_CNTR
	movwf I2C_BIT_CNTR		; Load bit counter
	SDA2HIZ			 		; hI Z for SDA (SDA=1)

NEXT_RD_BIT:
	SCL2HIZ					; hI Z for SCL (SCL=1)
	banksel	GPIO			; GPIO and STATUS in the same bank
	btfsc GPIO, SDA
	bsf STATUS, C			; a 1 has been read
	btfss GPIO, SDA
	bcf STATUS, C			; a 0 has been read
	SCL2DVR					; SCL now driven low (SCL=0)	
	banksel	I2C_WORD	
	rlf I2C_WORD, F			; rotate and save C into read register
	banksel I2C_BIT_CNTR
	decfsz I2C_BIT_CNTR, F
	goto NEXT_RD_BIT

	SDA2DVR					; SDA now driven low (SDA=0)  for ACK

	nop						; delay may not be needed

	SCL2HIZ					; hI Z for SCL (SCL=1)  pulse SCL

	nop
	
	SCL2DVR					; SCL now driven low (SCL=0)	

	retlw	0xB2
	
;********************************************************************************************
;********************************  I2C WRITE SUBROUTINE *************************************
I2C_WRITE:
	movlw 0x08	
	banksel I2C_BIT_CNTR		
	movwf I2C_BIT_CNTR		; Load bit counter

NEXT_WRT_BIT:
	SCL2DVR					; SCL now driven low (SCL=0)

	banksel I2C_WORD
	rlf I2C_WORD, F			; Rotate I2C_WORD data left, thru carry flag
	banksel STATUS
	btfsc STATUS, C			; Test carry bit in status reg. skip on clr
	goto WRITE_1			; If bit is 1, then goto write_1
	
WRITE_0:
	SDA2DVR					; SDA now driven low (SDA=0)
	goto PULSE_SCL			; Go to pulse_SCL

WRITE_1:
	SDA2HIZ					; hI Z for SDA (SDA=1)

PULSE_SCL:
	SCL2HIZ					; hI Z for SCL (SCL=1), SCL has transitioned from 0 --> 1 (SCL=1)
	banksel I2C_BIT_CNTR
	decfsz I2C_BIT_CNTR, F	; Decrement counter, if 0 check for ack
	goto NEXT_WRT_BIT		; still bits to write, loop back 
	
CHECK_ACK:
	SCL2DVR					; SCL now driven low (SCL=0), ready to read ack (SCL=0)
	SDA2HIZ					; hI Z for SDA (SDA=1) *Actuall I2C STOP command
	SCL2HIZ					; hI Z for SCL (SCL=1)
	banksel GPIO
	btfsc GPIO, SDA			; check if SDA is low, return B1 for ack, else FA
	goto NACK
ACK:
	SCL2DVR					; SCL now driven low (SCL=0)
	retlw 0xB1

NACK:
	SCL2DVR					; SCL now driven low (SCL=0)
	retlw 0xFA
	

;********************************************************************************************
;********************************  I2C RESET SUBROUTINE  ************************************
I2C_RESET:
	movlw 0x09
	banksel I2C_BIT_CNTR
	movwf I2C_BIT_CNTR		; set up counter

TOGGLE:
	SCL2DVR					; SCL now driven low (SCL=0)
	SCL2HIZ					; hI Z for SCL (SCL=1)
	banksel I2C_BIT_CNTR
	decfsz	I2C_BIT_CNTR, F
	goto TOGGLE

	retlw 0xB4

;*************************************************************************
;  SUBROUTINE--configAD
;*************************************************************************
CONFIGADC:

	banksel 	ANSEL
	clrf		ANSEL				 
	movlw		b'01110010'  		;clock from internal osc
	movwf		ANSEL   			;<3:0> (0010) GP1 as analog input ,
   
	bsf			TRISIO, 1			;GP1 configured as input
	
	banksel		ADCON0			  	;BANK 0

	movlw	 	b'10000101'  		;left justified
								    ;Vdd is reference
								    ;<5-4>unimplemented
								    ;<3:2> (01) CHS--->select AN1
								    ;<1> is GO/DONE, <0> Turn ADC ON
	movwf		ADCON0   			;configure ADCON0

	return 

;********************************  DELAY SUBROUTINE  **********************
;**** DELAYS FROM ~1ms w/ DELAY_VAL_MS=1.1  to 255ms w/ DELAY_VAL_MS=~290 *
;**************************************************************************
DELAY_MS:

	movlw 		0x05
	banksel		DELAY_VAL_MS
	movwf 		DELAY_VAL_MS		;set up 125 loops for ~1128 us	
	
DELAY_TMP:
	movlw 		0x7D
	banksel		DELAY_VAL_US
	movwf 		DELAY_VAL_US		;set up 125 loops for ~1128 us

DELAY_1000_US:
	nop
	nop
	nop
	nop
	nop
	nop
	banksel		DELAY_VAL_US
	decfsz		DELAY_VAL_US, F
	goto		DELAY_1000_US		; delay us

	banksel		DELAY_VAL_MS
	decfsz		DELAY_VAL_MS, F 			
	goto		DELAY_TMP			; delay ms

	retlw		0x01	

;*************************************************************************
	END                       		; directive 'end of program'

