#include <htc.h>

#include "utils.h"
#include "hardware.h"


void LCD_putbits(unsigned char c) {
	__delay_us(1);
	UTIL_PBIT(R,LCD_DB7) = ((c & 0b10000000) != 0);
	__delay_us(1);
	UTIL_PBIT(R,LCD_DB6) = ((c & 0b01000000) != 0);
	__delay_us(1);
	UTIL_PBIT(R,LCD_DB5) = ((c & 0b00100000) != 0);
	__delay_us(1);
	UTIL_PBIT(R,LCD_DB4) = ((c & 0b00010000) != 0);
}

void LCD_cycen() {
	__delay_us(1);
	UTIL_PBIT_SET(R,LCD_EN);
	__delay_us(1);
	UTIL_PBIT_CLR(R,LCD_EN);
}

void LCD_sendcmd(unsigned char c) {
	__delay_us(1);
	UTIL_PBIT_CLR(R,LCD_RS);
	LCD_putbits(c);
	LCD_cycen();
	LCD_putbits(c << 4);
	LCD_cycen();
	__delay_ms(3);
}

void LCD_sendchar(unsigned char c) {
	__delay_us(1);
	UTIL_PBIT_SET(R,LCD_RS);
	LCD_putbits(c);
	LCD_cycen();
	LCD_putbits(c << 4);
	LCD_cycen();
	__delay_us(100);
}

void LCD_init(unsigned char m) {

	UTIL_PBIT_CLR(TRIS,LCD_RS);
	UTIL_PBIT_CLR(TRIS,LCD_EN);
	UTIL_PBIT_CLR(TRIS,LCD_DB7);
	UTIL_PBIT_CLR(TRIS,LCD_DB6);
	UTIL_PBIT_CLR(TRIS,LCD_DB5);
	UTIL_PBIT_CLR(TRIS,LCD_DB4);

	UTIL_PBIT_CLR(R,LCD_RS);
	UTIL_PBIT_CLR(R,LCD_EN);
	UTIL_PBIT_CLR(R,LCD_DB7);
	UTIL_PBIT_CLR(R,LCD_DB6);
	UTIL_PBIT_CLR(R,LCD_DB5);
	UTIL_PBIT_CLR(R,LCD_DB4);

	__delay_ms(25);

	LCD_putbits(0x30);
	LCD_cycen();
	__delay_ms(10);
	LCD_cycen();
	__delay_us(200);
	LCD_cycen();
	__delay_us(200);
	LCD_putbits(0x20);	// Four bit mode
	LCD_cycen();

	LCD_sendcmd(0x20 | (m & 0b00001111));
	LCD_sendcmd(0x0F); // Display On, Cursor On, Cursor Blink
	LCD_sendcmd(0x01); // Clear screen
	LCD_sendcmd(0x06); // Set entry Mode
}
