#include <htc.h>
#include <stdio.h>

#include "utils.h"
#include "hardware.h"
#include "hdlcd.h"

__CONFIG( INTIO & WDTDIS & MCLRDIS & BORDIS & LVPDIS );


void putch(char c) { LCD_sendchar(c); }


static unsigned char TMR1U=0;


static unsigned long prevtmr = 0;
static unsigned long acttmr = 0;
static unsigned long speed = 0;
static unsigned long count = 0;
static int timeout = 0;


void __delay_10ms(int i) {
	while(i--) __delay_ms(10);
}

void interrupt ISR() {
	if (TMR1IF) {
		TMR1U++;
		if (timeout) timeout--;
		else acttmr=prevtmr;
		TMR1IF = 0;
	}
	if (INTF) {
		prevtmr = acttmr;
		acttmr = ((long)TMR1L) | ((long)TMR1H<<8) | ((long)TMR1U<<16);
		timeout = 5;
		count++;
		INTF = 0;
	}
}

void main() {

	/* 8MHz internal clock */
	IRCF2 = 1;
	IRCF1 = 1;
	IRCF0 = 1;

	/* disable all analog pins */
	ANSEL = 0;
	ANSELH = 0;

	UTIL_PBIT_CLR( TRIS , LED );

	LCD_init(0b1000);
	LCD_sendchar('B');

	printf("haha");

	/* set timer1 to run */
	TMR1CS = 0; /* clock source = Fosc/4 */
	T1CKPS1 = 1; /* 11 = prescaler divides by 8 */
	T1CKPS0 = 1;
	TMR1GE = 0; /* disable gating */
	TMR1ON = 1; /* run timer1 */

	/* enable timer1 interrupt */
	TMR1IF = 0;
	TMR1IE = 1;
	PEIE = 1;

	/* set PB0/INT as weak pulled-up input pin */
	TRISB0 = 1;
	WPUB0 = 1;
	RBPU = 0;

	/* enable INT interrupt */
	INTEDG = 0;
	INTE = 1;

	ei();
	
	while (1) {
		UTIL_PBIT_SET(R,LED);

		speed = (acttmr - prevtmr) & 0xFFFFFF;

		LCD_sendcmd(0x80);
		printf("%8li",speed);

		LCD_sendcmd(0xC0);
		printf("%8li",count);

		__delay_10ms(25);
		UTIL_PBIT_CLR(R,LED);
		__delay_10ms(25);
	}
}
