;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; lcd demo
; jason nunn <jsno@arafura.net.au>, march 2002
;
; a simple LCD tester. nb/ we don't have no read mechanism via 174.. just
; delayzzz.. it's a hack, but it keeps the electronics dead simple.
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
org 8000h
  ajmp  start

LCD_E        bit p3.5
LCD_RS       bit p1.7
LCD_174_DATA bit p1.7
LCD_174_CLK  bit p1.6

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; a * .1 seconds
delay:
  mov  r5,a
delay_l3:
  mov  r7,#0c8h
delay_l2:
  mov  r6,#0f8h
  djnz r6,$
  nop
  djnz r7,delay_l2
  djnz r5,delay_l3
  ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
lcd_load_174:
  mov  r7,#8
lcd_load_174_l1:
  rlc  a
  mov  LCD_174_DATA,c
  setb LCD_174_CLK
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  nop
  clr  LCD_174_CLK
  djnz r7,lcd_load_174_l1
  ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
lcd_write_cmd:
  acall lcd_load_174
  clr   LCD_RS
  setb  LCD_E
  clr   LCD_E
  mov   r7,#0
lcd_write_cmd_l:
  nop
  nop
  nop
  nop
  djnz  r7,lcd_write_cmd_l
  ret

lcd_write_data:
  acall lcd_load_174
  setb  LCD_RS
  setb  LCD_E
  clr   LCD_E
  mov   r7,#0
lcd_write_data_l:
  nop
  nop
  nop
  nop
  djnz  r7,lcd_write_data_l
  ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
lcd_clear:
  mov   a,#00000001b
  acall lcd_write_cmd
  ret

lcd_home1:
  mov   a,#10000000b
  acall lcd_write_cmd
  ret

lcd_home2:
  mov   a,#11000000b
  acall lcd_write_cmd
  ret

lcd_init:
  clr   LCD_RS
  clr   LCD_174_CLK
  clr   LCD_E

  mov   a,#00110000b
  acall lcd_load_174

  setb  LCD_E
  clr   LCD_E
  setb  LCD_E
  clr   LCD_E
  mov   a,#5
  acall delay
  setb  LCD_E
  clr   LCD_E
  setb  LCD_E
  clr   LCD_E
  mov   r7,#0
  djnz  r7,$
  setb  LCD_E
  clr   LCD_E
  setb  LCD_E
  clr   LCD_E

; set for 8 bits & 2 line display
;
  mov   a,#00111000b
  acall lcd_write_cmd

  mov   a,#5
  acall delay

; display on
;
  mov   a,#00001100b
  acall lcd_write_cmd

;  Entry Mode Set- Inc. address + right shift cursor on write
;
  mov   a,#00000110b
  acall lcd_write_cmd

  acall lcd_clear

  ret

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
writeln:
  pop  dph
  pop  dpl
writeln_l0:
  clr  a
  movc a,@a+dptr
  inc  dptr
  jnz  writeln_l1
  jmp  @a+dptr
writeln_l1:
  acall lcd_write_data
  sjmp  writeln_l0

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;
;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
start:
  mov   sp,#79

  acall lcd_init

  acall lcd_home1
  lcall writeln
  db    'Jason Nunn',0

  acall lcd_home2
  lcall writeln
  db    'this is a text.',0

  sjmp  $
end
