#include <p18cxxx.h>
#include <portb.h>
#include <timers.h>
#include "sw_uart.h"

char            rxbuff[RXBUFFLEN];
unsigned char   rxbuffaktsize = 0,
				rxbuffwritepos = 0,
                rxbitmask,
                rxbyte;

//============================================================================
unsigned char SwDataRdyUart()
{
    return rxbuffaktsize;
}

//============================================================================
char SwReadUart()
{
    if(rxbuffaktsize)
        return rxbuff[(rxbuffwritepos - rxbuffaktsize--) & (RXBUFFLEN - 1)];
    else
        return 0;
}

//============================================================================
void SwUartInit()
{
	INTCON3bits.INT1IF = 0;			// INT1 interrupt flag trls
	INTCON2bits.INTEDG1 = 0;		// lefut lre
	INTCON3bits.INT1IE = 1;			// interrupt eng.
}

//============================================================================
void Int1_ISR()
{
	if(!INTCON3bits.INT1IE) return;

    TMR0H = (0x10000 - TimerPeriodStart + 130) >> 8;
    TMR0L = (0x10000 - TimerPeriodStart + 130) & 0x00FF;
	INTCONbits.T0IF = 0;      		// Timer0 overflow flag trlse
	INTCONbits.T0IE = 1;    		// Timer0 overflow interrupt eng
	T0CONbits.TMR0ON = 1;
	T0CON = T0_16BIT & T0_SOURCE_INT & T0_PS_1_1;

    rxbitmask = 0b10000000;
    rxbyte = 0;

	INTCON3bits.INT1IE = 0;			// RB1 intenterrupt tiltsa
    INTCON3bits.INT1IF = 0;
}

//============================================================================
void Timer0_ISR()
{
    TMR0H = (0x10000 - TimerPeriod + 57) >> 8;
    TMR0L = (0x10000 - TimerPeriod + 57) & 0x00FF;
    INTCONbits.TMR0IF = 0;			// Clear Timer0 overflow flag

    if(rxbitmask)                   // 7..0 bit
    {
        if(!RXpin)                  // alacsony szint ?
        {
            rxbyte += rxbitmask;    // 1 bit rkezett
        }
        rxbitmask = rxbitmask >> 1;
    }
    else                            // stopbit
    {
        if(RXpin)                  	// stopbit = 1 ?
            if(rxbuffaktsize < RXBUFFLEN)
            {
                rxbuff[rxbuffwritepos++] = rxbyte;
                rxbuffaktsize++;
                rxbuffwritepos &= RXBUFFLEN - 1;
            }    
		T0CONbits.TMR0ON = 0;  			// Disable Timer1
		INTCONbits.TMR0IE = 0;   		// Disable Timer1 overflow interrupts

		INTCON3bits.INT1IF = 0;			// Clear INT1 interrupt flag
		INTCON2bits.INTEDG1 = 0;		// lefut lre
		INTCON3bits.INT1IE = 1;			// interrupt eng.
    }
}
