#ifndef SW_UART_H
#define SW_UART_H

#define RXpin  PORTBbits.RB1

#define RXBUFFLEN 16

/******************************************************
TimerPeriodStart = ((CpuClock / 4) / BAUDRATE) * 1,5
TimerPeriod = (CpuClock / 4) / BAUDRATE

                 TimerPeriodStart
bit/sec    4MHz    8MHz   12MHz   20MHz   40MHz   48MHz
 1200      1250    2500    3750    6250   12500   15000
 2400       625    1250    1875    3125    6250    7500
 4800       312     625     938    1562    3125    3750
 9600        -      312     469     781    1562    1875
19200        -       -      234     391     781     938
31250        -       -       -      240     480     576

                    TimerPeriod
bit/sec    4MHz    8MHz   12MHz   20MHz   40MHz   48MHz
 1200       833    1667    2500    4167    8333   10000  
 2400       417     833    1250    2083    4167    5000
 4800       208     417     625    1042    2083    2500
 9600        -      208     312     521    1041    1250
19200        -       -      156     260     521     625
31250        -       -       -      160     320     384
******************************************************/

// 20MHz, 9600 bit/sec
// startbit tugrsa s els bit flideje (msfl bit)
#define TimerPeriodStart 781
// egy bitnyi id
#define TimerPeriod 521

#define SwUartIntIsr if(INTCON3bits.INT1IF) Int1_ISR();
#define SwUartTimerIsr if(INTCONbits.TMR0IF) Timer0_ISR();

#define SwUartIsr SwUartTimerIsr; SwUartIntIsr

unsigned char SwDataRdyUart();
char SwReadUart();
void SwUartInit();
void Timer0_ISR();
void Int1_ISR();

#endif  //SW_UART_H
