#include <p18cxxx.h>
#include <usart.h>
#include "sw_uart.h"

void main(void);
void InterruptHandlerHigh(void);
void InterruptHandlerLow(void);

//============================================================================
// High priority interrupt vector
#pragma code InterruptVectorHigh = 0x08
void InterruptVectorHigh(void)
{
  _asm goto InterruptHandlerHigh _endasm //jump to interrupt routine
}

// High priority interrupt routine
#pragma code
#pragma interrupt InterruptHandlerHigh

void InterruptHandlerHigh ()
{
    // ---------------------------- Uart Isr --------------------------------
    SwUartIsr;
}

//----------------------------------------------------------------------------
// Low priority interrupt vector
#pragma code low_vector_section = 0x18
void InterruptVectorLow(void)
{
  _asm GOTO InterruptHandlerLow _endasm  //jump to interrupt routine
}

// Low priority interrupt routine
#pragma code
#pragma interrupt InterruptHandlerLow

void InterruptHandlerLow()
{
}

//============================================================================
void main(void)
{
	char c;
    TRISA = 0b11111111;
    TRISB = 0b11111111;
    TRISC = 0b10111111;   // RC6 = TX

    /* Enable interrupt priority */
    RCONbits.IPEN = 1;
    /* Make receive interrupt high priority */
    IPR1bits.RCIP = 1;
    /* Enable all high priority interrupts */
    INTCONbits.GIEH = 1;

	OpenUSART( 	USART_TX_INT_OFF  &
             	USART_RX_INT_OFF  &
             	USART_ASYNCH_MODE &
             	USART_EIGHT_BIT   &
             	USART_CONT_RX     &
             	USART_BRGH_HIGH, 129); //(20MHz, 19200bit/sec)
	
    SwUartInit();

    while(1)
    {       
		if(SwDataRdyUart())
		{
			c = SwReadUart();
			WriteUSART(c);
		}
    }
}

