;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; oscope include file
;
;

.global newWave
.global oldWave


.extern textStartPos
.extern textPutChar
.extern drawXY
.extern drawLine
.extern clearLine

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; constants
;

.equ Xoffset, 32					;x start location of waveform display

.equ gain125, 0b0100000000000000	;gain = 1
.equ gain25, 0b0100000000000001		;gain = 2
.equ gain5, 0b0100000000000010		;gain = 4
.equ gain1, 0b0100000000000100		;gain = 8
.equ gain2, 0b0100000000000110		;gain = 16
.equ gain4, 0b0100000000000111		;gain = 32

.equ ANPORTS, 		0b1111111100010100	;ports used as analog inputs
.equ ADCON1_POTval, 0b0010000011100100
.equ ADCON2_POTval, 0b0110000000111100
.equ ADCON3_POTval, 0b0000001000001111
.equ ADCHS_vPOTval, 0b0000000000100110
.equ ADCHS_tPOTval, 0b0000000000100111
.equ ADCHS_mPOTval, 0b0000000000100101

.equ ModeButton, RB4		;pushbutton for selecting mode
.equ ModeTrisX, TRISB4
.equ ModeTris, TRISB
.equ ModePort, PORTB

.equ PGA_SSTRIS, TRISB2	;slave select tris for pga
.equ PGA_SS, RB2		;ss pin for pga
.equ PGA_TRIS, TRISB	;tris register for pga
.equ PGA_PORT, PORTB	;port register for pga
.equ SPI1CON_PGA, 0b0000010100100010

.equ DATA_LENGTH, 512 ;length of sample buffer
.equ DISP_WIDTH, 96

.equ ADJUST0, 2
.equ ADJUST1, 2
.equ ADJUST2, 4
.equ ADJUST3, 4
.equ ADJUST4, 16
.equ ADJUST5, 48