;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; the text functions for 128x64 glcd
;
.include "text.inc"
.include "font.inc"
.include "glcd.inc"
.include "p30fxxxx.inc"

.bss

textAddr: .space 2
textPage: .space 2

.text

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; textStartPos
;
; set the starting position for 5x8 text
; select line with w0, select position (0-127)
; with w1
;
textStartPos:
	mov w0, textPage	;save text page
	mov w1, textAddr	;save text address
	mov #LCD_page, w2	;or-in the lcd page setting command
	ior w2, w0, w0		;
	bset w0, #_cs1		;set line on both displays
	bset w0, #_cs2		;

	call gLCDcmd		;set the page
	call checkBusy		;

	mov #64, w2
	cp w1, w2			;check which side to use
	bra geu, textRight	;if greater or equal, right side

textLeft:
	mov #LCD_addr, w2
	ior w2, w1, w0
	bset w0, #_cs1
	bclr w0, #_cs2
	call gLCDcmd
	call checkBusy
	goto textPosDone

textRight:
	sub #64, w1			;adjust starting position to right side addr
	mov #LCD_addr, w2		;
	ior w2, w1, w0		;
	bset w0, #_cs2		;
	bclr w0, #_cs1		;
	call gLCDcmd
	call checkBusy
	;goto textPosDone

textPosDone:
	return				;done setting position





;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; textPutChar
;
; place a character at the previously set location
; adjusts the address variables, and checks to make
; sure the character will fit on the current line,
; otherwise puts the character on the next line
; starting at the beginning of the line.  Also allows
; characters to straddle the middle line of the screen
; character passed as ascii val in w1

textPutChar:
	push w1
	mov #121, w2
	mov textAddr, w0
	cp w0, w2		;check to see if the next char will fit
	bra leu, textGetChar	;
	
textNextLine:
	inc textPage		;move to next line
	mov #7, w0
	and textPage		;roll to top if already on bottom
	mov textPage, w0	;
	mov #0, w1
	mov w1, textAddr
	call textStartPos

textGetChar:
	pop w1
	mov #tblpage(font), w0
	mov w0, TBLPAG
	mov #tbloffset(font), w3	;table offset at
	mul.uu w1, #6, w4		;multiply by 6 to get offset into table (3 words per char)
	add w3, w4, w2		;store offset in w2
	tblrdl [w2], w1		;
	mov w1, w0
	and #0xff, w0		;start with low byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0

	call gLCDdata
	call checkBusy
	inc textAddr

textByte2:
	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0
	
	mov w1, w0
	swap w0
	and #0xFF, w0		;get rid of other byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	call gLCDdata
	call checkBusy
	inc textAddr
	inc2 w2, w2

textByte3:
	tblrdl [w2], w1		;
	mov w1, w0
	and #0xff, w0		;start with low byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0

	call gLCDdata
	call checkBusy
	inc textAddr

textByte4:
	mov w1, w0
	swap w0
	and #0xff, w0		;start with low byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0

	call gLCDdata
	call checkBusy
	inc textAddr
	inc2 w2, w2

textByte5:
	tblrdl [w2], w1		;
	mov w1, w0
	and #0xff, w0		;start with low byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0

	call gLCDdata
	call checkBusy
	inc textAddr

textByte6:
	mov w1, w0
	swap w0
	and #0xff, w0		;start with low byte
	
	mov textAddr, w3
	btss w3, #6			;check for a number equal or over 64
	bset w0, #_cs1		;
	btsc w3, #6			;
	bset w0, #_cs2		;

	push w0
	push w1
	push w2
	mov textPage, w0
	mov textAddr, w1
	call textStartPos	;make sure everythig is ok address wise
	pop w2
	pop w1
	pop w0

	call gLCDdata
	call checkBusy
	inc textAddr

	return
