.include "p30f4011.inc"
.include "glcd.inc"

.text
; put data onto the data pins.  Modify this function
; to change what pins are the data pins.  Currently:
; d0 -> RE0
; d1 -> RE1
; d2 -> RE2
; d3 -> RE3
; d4 -> RE4
; d5 -> RE5
; d6 -> RE8
; d7 -> RF0
; data needed on outputs is passed in w0 low byte
putData:
	bclr d0port, #d0
	nop
	btsc w0, #0			;check the zero bit, if it is clear, ok
	bset d0port, #d0	;if not, then set the bit, and keep going
	nop
	
	bclr d1port, #d1
	nop
	btsc w0, #1
	bset d1port, #d1
	nop

	bclr d2port, #d2
	nop
	btsc w0, #2
	bset d2port, #d2
	nop

	bclr d3port, #d3
	nop
	btsc w0, #3
	bset d3port, #d3
	nop

	bclr d4port, #d4
	nop
	btsc w0, #4
	bset d4port, #d4
	nop

	bclr d5port, #d5
	nop
	btsc w0, #5
	bset d5port, #d5
	nop

	bclr d6port, #d6
	nop
	btsc w0, #6
	bset d6port, #d6
	nop

	bclr d7port, #d7
	nop
	btsc w0, #7
	bset d7port, #d7
	nop
	
	return



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; strobeE : bring E high, then low, to latch
; 			data.  E is currently set to
;			RC13
;
strobeE:
	repeat #50			;do a delay
	nop				;of nothing!
	bset eport, #e	;take E high
	nop
	
	repeat #50
	nop				;delay for a bit
	bclr eport, #e	;bring E low to latch
	nop

	repeat #50
	nop
	return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;controlLines
;set the control lines based on the value in w0
;cs1 is rf4
;cs2 is rf1
;rw is rf6
;di is rc14
;
controlLines:
	bclr cs1port, #cs1	;bring both cs high
	nop
	bclr cs2port, #cs2
	nop

	btsc w0, #_cs1		;cs1
	bset cs1port, #cs1
	nop

	btsc w0, #_cs2		;cs2
	bset cs2port, #cs2
	nop

	bclr rwport, #rw	;rw line
	nop
	btsc w0, #_rw
	bset rwport, #rw
	nop

	bclr diport, #di	;di line
	nop
	btsc w0, #_di
	bset diport, #di
	nop

	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
;setOutput
;set the tris registers for all lcd-related pins
;to output
;
setOutput:
	bclr d0tris, #d0	;data pins start
	nop
	bclr d1tris, #d1
	nop
	bclr d2tris, #d2
	nop
	bclr d3tris, #d3
	nop
	bclr d4tris, #d4
	nop
	bclr d5tris, #d5
	nop
	bclr d6tris, #d6
	nop
	bclr d7tris, #d7
	nop					;data pins end
	
	bclr cs1tris, #cs1	;cs1
	nop
	bclr cs2tris, #cs2	;cs2
	nop
	bclr rsttris, #rst	;reset pin
	nop
	bclr rwtris, #rw	;rw pin
	nop
	bclr ditris, #di	;di pin
	nop
	bclr etris, #e	;e pin
	nop

	return		;done


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; setInput
; make all data pins inputs, others outputs
setInput:
	bset d0tris, #d0	;data pins start
	nop
	bset d1tris, #d1
	nop
	bset d2tris, #d2
	nop
	bset d3tris, #d3
	nop
	bset d4tris, #d4
	nop
	bset d5tris, #d5
	nop
	bset d6tris, #d6
	nop
	bset d7tris, #d7
	nop					;data pins end
	
	bclr cs1tris, #cs1	;cs1
	nop
	bclr cs2tris, #cs2	;cs2
	nop
	bclr rsttris, #rst	;reset pin
	nop
	bclr rwtris, #rw	;rw pin
	nop
	bclr ditris, #di	;di pin
	nop
	bclr etris, #e	;e pin
	nop

	return		;done



;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; user functions
;


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; gLCDcmd
;
; send a command to the lcd
; command byte in low byte of w0
; cs1 and cs2 at positions _cs1 and _cs2
;
gLCDcmd:
	call setOutput		;set all pins to outputs

	bclr w0, #_di	;di should be low (instruction)
	nop
	bclr w0, #_rw	;as should rw (write)
	nop
						;chip selects set by calling function	
	call controlLines 	;set cs1, cs2, rw, di

	call putData		;put the data on the output lines

	call strobeE		;strobe e to latch data

	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; gLCDdata
; 
; send data to the lcd
; data byte in the low byte of w0
; cs1 and cs at positions _cs1 and _cs2
; 
gLCDdata:
	call setOutput		;set all pins to output

	bset w0, #_di	;di high (data)
	nop				;
	bclr w0, #_rw	;rw low (write)
	nop				;
	
	call controlLines	;set the control lines appropriately
	
	call putData		;put the data on the output lines
	
	call strobeE		;strobe e to latch data

	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; checkBusy
;
; check the busy flag and return when the lcd
; is not busy
;
checkBusy:
	call setInput		;set data pins to input 
	
	bset w0, #_rw		;rw high (read)
	nop
	bclr w0, #_di		;di low (instruction)
	nop

	bclr w0, #_cs2		;
	nop					;
	bset w0, #_cs1		;choose chip 1
	nop					;
	call controlLines	;set the control lines

	chip1wait:
		call strobeE
		btst d7port, #d7	;check the busy flag
		bra nz, chip1wait

	bclr w0, #_cs1		;
	nop					;
	bset w0, #_cs2		;choose chip 2
	nop					;
	call controlLines	;set the control lines

	chip2wait:
		call strobeE
		btst d7port, #d7	;check busy flag
		bra nz, chip2wait
	
	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; gLCDread
;
; read data from the lcd, chip selects set by
; calling function.  Return data in w0 low byte.
; pass chip select stuff in w0 in #_cs1 and #_cs2 as usual
;
gLCDread:
	call setInput	;set all data lines to input

	bset w0, #_di	;di high (data)
	nop
	bset w0, #_rw	;rw high (read)
	nop
	push w0

	call controlLines	;	
	call strobeE	;strobe E line

	call checkBusy	;wait for busy to be done

	pop w0
	bset w0, #_di
	nop
	bset w0, #_rw
	nop
	
	call controlLines	;set the control lines for a data read

	call strobeE

	readTheData:
		mov #0, w0
		
		btsc d7port, #d7	;get d7 bit
		bset w0, #7
		nop

		btsc d6port, #d6
		bset w0, #6
		nop

		btsc d5port, #d5
		bset w0, #5
		nop

		btsc d4port, #d4
		bset w0, #4
		nop

		btsc d3port, #d3
		bset w0, #3
		nop

		btsc d2port, #d2
		bset w0, #2
		nop

		btsc d1port, #d1
		bset w0, #1
		nop

		btsc d0port, #d0
		bset w0, #0
		nop

	return

;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; initLCD
;
; turn on your lcd maybe...
; and set the first display line to 0 maybe...
;

initLCD:
	call setOutput

	mov #LCD_on, w0		;put the on command in the w0 slot
	bset w0, #_cs1		;choose cs1
	nop
	bset w0, #_cs2		;and cs2
	nop
	
	bset rstport, #rst
	nop

	repeat #16000
	nop

	call gLCDcmd

	call checkBusy		;busy?
	
	mov #LCD_sline, w0	;set start line to 0
	bset w0, #_cs1
	nop
	bset w0, #_cs2
	nop

	call gLCDcmd
	call checkBusy

	return


;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;;
; clearLCD
;
; turn off all pixels on the display
; use w1, w2 to store the addresses being cleared
clearLCD:
	mov #(LCD_page), w1

	clear1:
		mov #LCD_addr, w2
		mov #(LCD_page + 7), w0
		cp w1, w0				;compare current address and last 
		bra gtu, clearDone		;if greater than last addr, done!
		mov w1, w0				;put page into w0
		bset w0, #_cs1			;
		bset w0, #_cs2			;set both chip selects
		call gLCDcmd			;do the command
		call checkBusy			;wait for busy flag to clear
		add #1, w1				;move to next page
		clear2:
			mov #(LCD_addr + 63), w0	;load last address
			cp w2, w0					;compare current address and last
			bra gtu, clear1				;if done with a line, go to next page
			mov w2, w0
			bset w0, #_cs1
			bset w0, #_cs2
			call gLCDcmd
			call checkBusy
			mov #0, w0
			bset w0, #_cs2
			bset w0, #_cs1
			call gLCDdata				;clear current byte
			call checkBusy
			add #1, w2					;move to next address
			goto clear2					;loop

			
	clearDone:
		return

	
.end
