#include "lcd_zombee.h"
#include <avr/io.h>
#include <util/delay.h> 
#include <avr/pgmspace.h>



/*
const char hun_a1	=	8;
const char hun_e1	=	9;
const char hun_i1	=	10;
const char hun_o1	=	11;
const char hun_o2	=	12;
const char hun_o3	=	13;
const char hun_u1	=	14;
const char hun_u2	=	15;
*/


const byte line [] =  {0x00, 0x40, 0x14, 0x54};

const byte hunchars [] = {
     0x02,0x04,0x0e,0x01,0x0f,0x11,0x0f,0x00,  // 
     0x02,0x04,0x0E,0x11,0x1f,0x10,0x0e,0x00,  // 
     0x02,0x04,0x00,0x0c,0x04,0x04,0x0e,0x00,  // 
     0x02,0x04,0x0e,0x11,0x11,0x11,0x0e,0x00,  // 
     0x0A,0x00,0x0e,0x11,0x11,0x11,0x0e,0x00,  // 
     0x05,0x0A,0x0e,0x11,0x11,0x11,0x0e,0x00,  // 
     0x02,0x04,0x11,0x11,0x11,0x13,0x0d,0x00,  // 
     0x0a,0x00,0x11,0x11,0x11,0x13,0x0d,0x00   // 
}; 
//  ch9 : array[0..7] of byte=($05,$0a,$11,$11,$11,$13,$0d,$00); {     }





//engedlyez impulzus megadott hosszig...
void lcd_toggle_E ()
{
  LCD_PORT |= (1 << LCD_E);		// E=1
  _delay_us (120);				//KS0065: ~25us, DEM16102SYH-PY: ~50us, HD44780: ~550 us
  LCD_PORT &= ~(1 << LCD_E);	// E=0
  _delay_us (40);
} 


//univerzlis kommunikci az ATMEGA s az LCD kztt
//adat s parancs kikldsre egyarnt alkalmas
//a kd ezltal rvidebb s tmrebb lehet
void lcd_dcmd_write(char dcmd, byte d)
{
	LCD_PORT = ((d==1)<<LCD_RS) | ((dcmd & 0xf0) >> (4-LCD_4));		//fels nibble igaztsa a port kimenethez
	lcd_toggle_E();
	LCD_PORT = ((d==1)<<LCD_RS) | ((dcmd & 0x0f) << (LCD_4)  );		//als nibble igaztsa a port kimenethez
	lcd_toggle_E();
}

/*
void lcd_write(char d)
{
//	lcd_dcmd_write(d, 1);
//	egy kis optimalizls...
	LCD_PORT = (1<<LCD_RS) | ((d & 0xf0) >> (4-LCD_4));		//fels nibble igaztsa a port kimenethez
	lcd_toggle_E();
	LCD_PORT = (1<<LCD_RS) | ((d & 0x0f) << (LCD_4)  );		//als nibble igaztsa a port kimenethez
	lcd_toggle_E();
}
*/
void lcd_init (void)
{
  //The display will be busy for approximately 30mS after power ON.

  LCD_DDR = 0xFF;		//DDR as out
  LCD_PORT = 0x0;		//PORT = 0
  _delay_ms (100);		//wait 100ms after power ON

  LCD_PORT = (1 << LCD_5)|(1 << LCD_4);		//set 8-bit operation RESET
  lcd_toggle_E ();
  _delay_ms(10);
  LCD_PORT = (1 << LCD_5)|(1 << LCD_4);		//set 8-bit operation RESET
  lcd_toggle_E ();
  _delay_ms(10);
  LCD_PORT = (1 << LCD_5)|(1 << LCD_4);		//set 8-bit operation RESET
  lcd_toggle_E ();
  _delay_ms(10);


  LCD_PORT = (1 << LCD_5);//set 4-bit operation
  lcd_toggle_E ();
  _delay_ms (10);         //wait more then 4.1ms
  LCD_PORT = (1 << LCD_5);
  lcd_toggle_E ();

  LCD_PORT = (1 << LCD_7);
  lcd_toggle_E ();		//2 line mod, 5x8 fonts 


  LCD_PORT = 0x0;
  lcd_toggle_E ();
  LCD_PORT = (1 << LCD_7);
  lcd_toggle_E ();		//Display ctrl: display off, cursor off, blink off
  _delay_us (50);

  LCD_PORT = 0x0;
  lcd_toggle_E ();
  LCD_PORT = (1 << LCD_4);
  lcd_toggle_E ();		//clr
  _delay_ms (2);		//1.6ms

  LCD_PORT = 0x0;
  lcd_toggle_E ();
  LCD_PORT = (1 << LCD_6) | (1 << LCD_5);
  lcd_toggle_E ();		//increment mode,entire shift off  
} 


/*-----------------'06. aug. 29. 10:09---------------
 *  LCD & Cursor control (Blinking, ON/OFF,...)
 *--------------------------------------------------*/
void lcd_control (byte disp_on, byte curs_on, byte curs_blink)
{
	lcd_dcmd_write(0b00001000 | ((disp_on==1)<<2) | ((curs_on==1)<<1) | (curs_blink==1), 0);
}
 


//kijelz trlse
void
lcd_cls ()
{
	lcd_dcmd_write(1,0);
	_delay_ms (2);
} 


void lcd_set_DDRAM_addr (char addr)
{
	lcd_dcmd_write(0b10000000 | addr, 0);
}


void lcd_set_CGRAM_addr (char addr)
{
	addr &= 0b00111111;
	lcd_dcmd_write(0b01000000 | addr , 0);
} 


void lcd_hun_chars()
{
	byte i;
	lcd_set_CGRAM_addr(0);
	for(i=0; i<64; i++) lcd_dcmd_write(hunchars[i],1);
}


void lcd_writeXY(byte x, byte y, char* data)
{
	lcd_set_DDRAM_addr(line[y]+x);
	char  i=255;
	char* temp=data;
	while(i)
	{
		if(*temp) lcd_dcmd_write(*temp,1); else break;
		temp++;
		i--;
	}
}

