#ifndef _LCD_ZOMBEE_H
#define _LCD_ZOMBEE_H


#include <avr/io.h>
#include <avr/pgmspace.h>


/*
********************************
 portA - 3:0 == D7-D4
 portA - 6   == RS    0:instruction; 1:data
 portA - 7   == EN
********************************
*/

#define LCD_PORT	PORTA
#define LCD_DDR		DDRA

#define LCD_E		7
#define LCD_RS		6

#define LCD_4		0
#define LCD_5		1
#define LCD_6		2
#define LCD_7		3


#define byte		uint8_t
/*
const char hun_a1;
const char hun_e1;
const char hun_i;
const char hun_o1;
const char hun_o2;
const char hun_o3;
const char hun_u1;
const char hun_u2;
*/

#define hun_a1	8
#define hun_e1	9
#define hun_i1	10
#define hun_o1	11
#define hun_o2	12
#define hun_o3	13
#define hun_u1	14
#define hun_u2	15

//a kijelz sorainak kdjai
//4x20 karakteres esetben is ktsoros a kijelznk, de az 1. a 3.-al, a 2. a 4.-el folytaqtdik...
const byte line [4];

//magyar karakterek bittrkpei...
const byte hunchars [64];

void lcd_toggle_E();
void lcd_dcmd_write(char dcmd, byte d);
//void lcd_write(char d);
void lcd_init();
void lcd_control (byte disp_on, byte curs_on, byte curs_blink);
void lcd_cls ();
void lcd_set_DDRAM_addr (char addr);
void lcd_set_CGRAM_addr (char addr);
void lcd_hun_chars();
void lcd_writeXY(byte x, byte y, char* data);


#endif /* LCD_ZOMBEE_H */ 
