﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarion translation: István Cserny, 2009.
 */

// Dokumentáció, ami az ESOS oldalra kerül. Ez az állomány csak
// megjegyzéseket tartalmaz a Doxygen számára, semmilyen programkód nincs benne 
/**
 * \page ESOS ESOS, a beágyazott rendszerek operációs rendszere
 * Az ESOS egy hordozható, kooperatív többfeladatos operációs rendszer, amelyben a  taszkokat
 * többszálú programfuttatással valósítják meg.
 *
 * \section ESOSCoreFiles Rendszerfájlok
 * Azok az állományok, amelyek az ESOS rendszert alkotják:
 * - esos.c - az ESOS ütemezőjét tartalmazó programhurok
 * - esos.h - az elsődleges ESOS definíciós állomány
 * - esos_task.h - header fájl az ESOS taszkok definiálásához
 * - esos_comm.h - az ESOS kommunikációs szolgáltatásait leíró header fájl 
 * - esos_comm.c - az ESOS kommunikációs szolgáltatásainak implementációját tartalmazza
 * - esos_irq.h - az ESOS interrupt szolgáltatásait leíró állomány
 * - esos_irq.c - az ESOS interrupt szolgáltatásainak implementációját tartalmazza
 * - esos_pic24_tick.c - a rendszer óramodulja a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz
 * - esos_pic24_irq.h - interrupt szolgáltatások a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (header fájl)
 * - esos_pic24_irq.c - interrpupt szolgáltatások a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (programkód)
 * - esos_pic24_rs232.h - aszinkron soros kommunikációs modul a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (header fájl)
 * - esos_pic24_rs232.c - aszinkron soros kommunikációs modul a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (programkód)
 * - esos_pic24_i2c.h - kétvezetékes szinkron soros kommunikációs modul a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (header fájl)
 * - esos_pic24_i2c.c - kétvezetékes szinkron soros kommunikációs modul a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (programkód)
 * - esos_pic24_spi.h - háromvezetékes szinkron soros kommunikációs modul a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (header fájl)
 * - esos_pic24_spi.c - háromvezetékes szinkron soros kommunikációs modul  a PIC24 mikrovezérlő családhoz  implementált ESOS-hoz (programkód)
 * \section ESOSExampleFiles Mintaprogramok
 * Mintaprogramok az ESOS használatára:
 * - esos_skel.c - Egy alkalmazási keretprogram ami az ESOS  felhasználásával villogtat
 *   egy "életjelző" LED-et (ami egyúttal azt is jelzi, hogy rendben fut az ESOS ütemezője). A keretprogram jó kiindulási pontot nyújt
 *   az új ESOS alkalmazói programok létrehozásához.
 */
