﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarion translation: István Cserny, 2009.
 */

// Documentation placed on the PIC24 support library page. This file only
// include comments for Doxygen; it does not contain any
// code.
/**
 * \page PIC24_support PIC24 támogatói programkönyvtár
 * A PIC24 támogatói programkönyvtár 
 * \ref external "külső komponensekből", \ref internal "belső komponensekből",
 * és \ref codeTools "segédprogramokból" áll (ez utóbbiak a könyvtár összeállításához kellenek).
 * A külső összetevőket tipikusan a felhasználói programból kell hívni, ha azt akarjuk, hogy
 * a PIC kommunikálni tudjon az UART csatornán, vagy az
 * I<sup>2</sup>C buszon, vagy más eszközön. A belső összetevőkkel a felhasználó közvetlenül nem találkozik,
 * ezek tartalmazzák az implementáció részleteit vagy azt az információt, ami további lehetőségeket aktivizál,  
 * amelyek alapértelmezetten nem, vagy másképp működnek a programkönyvtárban. Az alábbiakban az összetevők 
 * rövid ismertetése valamint a  \ref libraryFunctionSummary "könyvtári függvények összefoglalása"
 * olvasható.
 *
 * Egy egyszerű példaprogram, amely az  UART porton érkező karaktereket visszatükrözi:
\code
#include "pic24_all.h"
int main(void) {
  // Konfigurálja az órajelet, az "életjel" LED-et, az UART portot, és kiírja az üdvözlő szöveget
  configBasic(HELLO_MSG);
  while (1) {
    // Visszatükrözi a vett karaktereket
    outChar(inChar());
  }
  return 0;
}
\endcode
 *
 * \section libraryComponents A programkönyvtár összetevői
 *
 * \subsection external Külső könyvtári összetevők
 * - Fejlesztői támogatás
 *   - Egyetlen header állomány, amely becsatolja a pic24_all.h fájlban felsorolt többi állományt,   
 *   - \ref delayRoutines "Késleltető rutinok"
 *   - Az \ref dataTypes "általános adattípusok" definiálása
 *   - \ref portConfig "Az IO portok beállítása"
 *   - Feltételvizsgálat és hibajelző modul: pic24_unittest.h 
 *   - Egyéb segédletek: a pic24_util.h 
 * - Perifériakezelés támogatása
 *   - Analóg - digital átalakító kezelése: pic24_adc.h 
 *   - Közvetlem memória-hozzáférés (DMA) kezelése: pic24_dma.h
 *   - Továbbfejlesztett Controller Area Network (ECAN)  kezelés: pic24_ecan.h
 *   - FLASH memóría írása/olvasása: pic24_flash.h
 *   - Időzítők beállítása: pic24_timer.h
 *   - Soros kommunikáció támogatása: pic24_serial.h
 *   - I<sup>2</sup>C kezelése: pic24_i2c.h
 *   - SPI kezelése: pic24_spi.h
 *
 * \subsection internal Belső könyvtári összetevők
 * - Felhasználó által konfigurálható programkönyvtár beállítások: pic24_libconfig.h
 * - Órajel konfigurálása: pic24_clockfreq.h és pic24_clockfreq.c
 * - Konfigurációs bitek beállítása: pic24_configbits.c
 * - UART soros port kezelése: pic24_uart.h és pic24_uart.c, amelyek
 *   tipikusan a pic24_serial.h állományban definiált hívható fügvvényekhez kellenek.
 *
 * \subsection codeTools Segédprogramok a programkönyvtár kezeléséhez
 * <a href="http://www.scons.org/">SCons</a> automatikus könyvtárfordításra és tesztelésre használható.
 * Ennek a folyamatnal a részleteit a SConstruct.py állomány dokumentációja ismerteti.
 * Lehetővé teszi:
 * - A tankönyv összes mintapéldájának lefordítását.
 * - Támogatja azon perifériák kezelését, amelyből több példány is van az adott mikrovezérlőben (például UART, ECAN, 
 *   I<sup>2</sup>C, SPI), a kódot automatikusan generálva a sablon állományokból, amelyek a periférakezelő kódnak csak
 *  egy példányát tartalmazzák. Ezeket a sablon fájlokat a templates/
 *   alkönyvtár tartalmazza.
 *
 * A forráskódok konzisztens stílusának biztosításához használhatjuk a runAStyle.bat nevű batch fájlt, ami az
 *  <a href="http://astyle.sourceforge.net/">Artistic Style</a>
 * kódformázó programot futtatja. 
 *
 * \section libraryFunctionSummary A könyvtári függvények összegzése
 * Ebben a szakaszban  felsoroljuk a  programkönyvtár különböző részeiben definiált függvényeket,
 * gyors áttekintést nyújtva a programkönyvtár szolgáltatásairól.
 *
 * \subsection delayRoutines Késleltetések
 * A pic24_delay.h állomány az alábbi függvényeket definiálja:
 * - \ref DEBOUNCE_DLY, DELAY_MS(ms), DELAY_US(us), \ref CYCLES_PER_MS, 
 *   \ref CYCLES_PER_US, \ref delayAndUpdateHeartbeatCount(uint32 u32_cyc)
 *
 * \subsection dataTypes Általános adattípusok
 * A pic24_generic.h állomány az alábbi adattípusokat definiálja:
 * - Előjeles egészek: \ref int8, \ref int16, \ref int32, \ref int64
 * - Előjel nélküli egészek: \ref uint8, \ref uint16, \ref uint32, \ref uint64
 * - Úniók: \ref union16, \ref union32, \ref union64
 *
 * \subsection portConfig Az I/O portok beállítása
 * A pic24_ports.h állomány további fájlokat csatol be, amelyek az alábbi függvényeket definiálják:
 * - Magas szintű port konfigurálás: CONFIG_Rxy_AS_DIG_OUTPUT(),
 *   CONFIG_Rxy_AS_DIG_OD_OUTPUT(), CONFIG_Rxy_AS_DIG_INPUT(),
 *   CONFIG_ANx_AS_ANALOG()
 * - Alacsony szintű port konfigurálás: ENABLE_Rxy_ANALOG(), 
 *   DISABLE_Rxy_ANALOG(), CONFIG_RPy_AS_DIG_PIN(), ENABLE_Rxy_OPENDRAIN(),
 *   DISABLE_Rxy_OPENDRAIN(), ENABLE_Rxy_PULLUP(), DISABLE_Rxy_PULLUP(),
 *   ENABLE_Rxy_CN_INTERRUPT(), DISABLE_Rxy_CN_INTERRUPT()
 * - <a href="#remappableInputs">Átkonfigurálható lábkiosztású periféria bemenetek támogatása</a>
 * - <a href="#remappableOutputs">Átkonfigurálható lábkiosztású periféria kimenetek támogatása</a>
 * 
 */
