﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
  * Hungarion translation: István Cserny, 2009.
 */

// Documentation placed on the textbook examples page. This file only
// include comments for Doxygen; it does not contain any
// code.
/**
 * \page textbookExamples Mintaprogramok a tankönyvhöz
 *
 * Ezen az oldalon a 
 * <a href="http://www.reesemicro.com">"Microcontrollers: 
 * From Assembly to C with the PIC24 Family"</a> című tankönyv (szerzők: R. Reese,
 * B. Jones és J.W. Bruce, kiadó: Cengage Learning) mellékletében található mintaprogramokat mutatjuk be.
 *
 * A következő részben a mintaprogramok használatának módját ismertetjük röviden, a 
 * \ref exampleDirectory "mintaprogramok jegyzékében" pedig felsoroljuk az elérhető
 * példaprogramokat.
 *
 * \section usingExamples A mintaprogramok használata
 *
 * Először \ref gettingStarted "Az első lépések" című útmutatót nézze át, és győződjön meg róla, hogy a szükséges 
 * hardver és szoftver eszközök jól vannak beállítva, és működőképesek. 
 *
 * A programkönyvtárat bárhová telepítheti; a mintaprogramok projektjei csak relatív elérési útvonalakat használnak. 
 * Az MPLAB miatt érdemes azonban rövid elérési útvonalat választani, s ne legyen benne sem szóköz, sem ékezetes betű!
 *
 * A dokumentáció kezdőlapja: \ref index "docs/index.html". Ezek a mintaprogramok csak minimális mértékben
 * támaszkodnak a PIC24 fordítóval telepített gyári könyvtári függvényekre, helyettük a tankönyv szerzői saját
 * fejlesztésű könyvtári modulokat használnak, amelyek talán barátságosabbnak tűnnek azok számára, akik most
 * ismerkednek a PIC24 programozásával. Ez a programkönyvtár egyébként a
 * Mississippi Állami Egyetemen tartott, a mikroprocesszorok világába bevezető ECE3274 kurzushoz készült.
 *
 * A legtöbb program az ECE3274 tanfolyam PIC24HJ32GP202 alapú referencia áramköréhez készült
 * (kivéve a 13. fejezet néhány mintaprogramját, ami PIC24HJ64GP502 mikrovezérlőt igényel, amely
 * lábkompatibilis a  PIC24HJ32GP202 mikrovezérlővel, de több perifériával rendelkezik). 
 * Minden projekt egy módosított linker állományt is tartalmaz, amire a betöltő program (bootloader) miatt van szükség.
 * Ha a programokat PICkit2 programozóval akarjuk beégetni (ahogyan a magyar adaptációban ajánlott kísérleti áramkörnél is tesszük), 
 * akkor ki kell venni ezt a linker állományt a projektből (jobb egérgomb kattintás a projekt listán az állomány nevére és Remove).
 * 
 * A példaprogramok mellett nincs elmenetett munkakörnyezet (workspace) fájl, ezért
 * jobb, ha nem duplakattintással nyitjuk meg a projekteket, hanem előbb elindítjuk az MPLAB programot 
 * (ami betölti a legutóbbi munkakörnyezet-beállítást) és a Project -> Open menüben nyitjuk meg a kívánt projektet.
 * Ha nem így teszünk, és nem jelenik meg valamelyik ablak, akkor "szolgáljuk ki magunkat": 
 * az MPLAB View (Nézet) menüjében keressük meg a  látni kívánt ablakot. 
 *
 * Ha netán a PIC24 család egy másik tagját szeretnénk használni, egyszerűen változtassuk meg
 * a céleszközt az MPLAB Select Device menüjében.
 *
 * Mielőtt lefordítanánk a programot, győződjünk meg róla, hogy Release (kiadás) és nem Debug 
 * (nyomkövetéshez való) változatot fordítunk! A Debug típusú programok hardveres nyomkövető nélkül 
 * nem fognak elindulni a kísérleti áramkörünkön...
 
 * Amikor a programot fordítjuk, egy figyelmeztető üzenet (Warning) jelenik meg, ami arról értesít bennünket,
 * hogy a belső oszcillátor van kiválasztva, PLL frenkvenciatöbszörözővel, s az alapértelmezett konfigurációs
 * beállítás van érvényben.
*
 * Az oszcillátor beállításának megváltoztatásához lásd
 * common/pic24_clockfreq.c és include/pic24_clockfreq.h dokumentációját!
 * A konfigurációs bitek megváltoztatásához lásd common/pic24_configbits.c dokumentációját!
 *
 * Minden példaprogram azt feltételezi, hogy az UART1 port a mintaáramkörrel megegyezően van konfigurálva: 
 * a referencia áramkör az RP10 (RX) és az RP11 (TX) kivezetéséeket használja, az alapértelmezett adatátviteli sebesség pedig 57600 bit/s.
 * Ezeknek a hozzárendeléseknek a megváltoztatásához a configUART1() függvényt kell módosítani
 * a common/pic24_uart.c állományban.  Az alapértelmezett adatátviteli sebességet az include/pic24_libconfig.h
 * állományban módosíthatjuk a megfelelő <code>\#define DEFAULT_BAUDRATE</code> sor választásával
 * (több válastható beállítás van felsorolva, közülük csak egy sor lehet ommenten kívül). De az adatátviteli sebességet
 * az MPLAB-ban is megváltoztathatjuk a Projekt opciói menüben, pl. a  DEFAULT_BAUDRATE=38400 makró definiálásával.
 * (Egyébként az include/pic24_libconfig.h állomány tartalmazza mindazon beállításokat, amelyek a programkönyvtár
 * felhasználó által definiált viselkedésének szabályozásához kellenek).
 *
 * Ha a program kimenetében a sorvége jel (EOL) nem megfelelő a fogadó oldalon
 * (pl. a sor végén nemtér vissza a következő sor elejére) akkor ezt a viselkedést
 * is átszabhatjuk az include/pic24_libconfig.h állományban, a SERIAL_EOL_DEFAULT makró értékének megváltoztatásával.
 * Három választási lehetőség van: <code>SERIAL_EOL_CR_LF</code>, 
 * <code>SERIAL_EOL_CR</code>, vagy <code>SERIAL_EOL_LF</code>. Ezek közül a 
 * <code>SERIAL_EOL_LF</code> (sor végén csak LF karakter) az alapértelmezett.
 *
 * A fordító megjegyzései:
 *  - A sorvége jel is kiválasztható egy, a Projekt opciók között definiált makróval. Például CR-LF (kocsi vissza-soremelés) sorvége
 * definiálásához a  SERIAL_EOL_DEFAULT=SERIAL_EOL_CR_LF makrót kell hozzáadni a projekt opciókhoz.
 *  -  Az e sorok írásakor elérhető kiadásban a CR-LF kiíratásának sorrendje hibás. Ellenőrizzük a common/pic24_serial.c állományban, hogy
 * az outString eljárás elején a sorok sorrendje megegyezik-e az alábbival. Ha nem, akkor javítsuk! 
 \code
 void outString(const char* psz_s) {
         while (*psz_s) {
#if (SERIAL_EOL_DEFAULT==SERIAL_EOL_CR_LF)
        if (*psz_s == '\n') outChar(0x0D);
        outChar(*psz_s);
#endif
\endcode
 *
 * A mintaprogramok azt is feltételezik, hogy az RB15 kimenetre egy LED van kötve - amelyet "életjelként" 
 * folyamatosan villogtatnak a mintaprogramok, amikor bemenetre várnak.
 * Más kimenetre is át lehet konfigurálni ezt a LED-et  (lásd \ref HB_LED) vagy el is lehet hagyni teljesen
 *  (lásd \ref USE_HEARTBEAT)  a pic24_libconfig.h állomány módosításával.
 *
 * Legcélszerűbb talán a chap08/reset.c programmal kezdeni - ami csak a soros port működését feltételezi (tehát nem igényli az alapáramkör kiegészítését).
 * A 8. fejezet példái a prhuzamos portok ki- és bemeneteit kezelik,
 * a 9.fejezet példáiban pedig programmegszakításra is láthatunk néhány példát. 
 * Tekintse meg az alábbi listát, amelyben felsoroltuk az összes példaprogramot .
 *
 * \section exampleDirectory A példaprogramok jegyzéke
 * - 8. fejezet (a kísérleti áramkör felélesztése, párhuzamos port kezelése)
 *   - chap08/asm_echo.s - Minapélda C eljárások assembly programból történő hívására.
 *   - chap08/echo.c - Karaktereket fogad a soros porton ( UART RX1), s az eggyelmegnövelt karakterkódot küldi vissza.
 *   - chap08/lcd4bit.c - Karakteres LCD illesztése (4 bites adatúttal)
 *   - chap08/ledflash.c - LED villogtatása, portdefiniáló makrók használatával.
 *   - chap08/ledflash_nomacros.c - LED villogtatása, I/O makrók használata nélkül.
 *   - chap08/ledsw1.c - Véges állapotgép módszer alkalmazása a LED/nyomógomb/kapcsoló IO feladathoz.
 *   - chap08/ledtoggle.c - Véges állapotgép módszer alkalmazása: LED ki/be kapcsolgatása nyomógombbal.
 *   - chap08/ledtoggle_nofsm.c - LED kapcsolgatása nyomógombbal - véges állapotgép módszer nélkül.
 *   - chap08/reset.c - Bemutató program a reset, tétlen, alvás üzemmódok, és a watchdog időzítő működésének bemutatására.
 *
 * - 9. fejezet (interrupt, időzítők egyszerű használata)
 *   - chap09/trap_test.c - Kód, ami matematikai hiba (nullával való osztás) megszakítást okoz.
 *   - chap09/trap_test_handled.c - Interrupt kiszolgáló, amely kezeli a matematikai kivételt (nullával történő osztás).
 *   - chap09/button_semaphore.c - periodikus órainterrupt ami szemafort használ a gomb lenyomás/felengedés nyilvántartásához.
 *   - chap09/change_bounce.c -  A változásjelző megszakítás használata a nyomógomb pergésének detektálására.
 *   - chap09/change_latency.c - A programmegszakítás kiszolgálásának késését méri a változásfigyelő interrupt segítségével.
 *   - chap09/change_test.c - A változásjelző interrupt használata egy nyomógomb lenyomásainak figyelésére.
 *   - chap09/change_wakeup.c - Alvás üzemmódból történő ébresztés a a változásjelző interrupt segítségével.
 *   - chap09/change_wakeup_noint.c - Kísérlet az alvásból tröténő felébresztésre  0 prioritású változásjelző interrupttal.
 *   - chap09/filt_test.c - Aluláteresztő RC szűrő tesztelése impulzussorozat generálásával és egy másik lábon visszaolvasással.
 *   - chap09/int0_bounce.c - Az INT0 interrupt használata kapcsoló pergésének detektálására.
 *   - chap09/int0_wakeup.c - INT0 használata alvás üzemmódból történő felébresztésre.
 *   - chap09/int1_bounce.c - Az INT1 interrupt használata kapcsoló pergésének detektálására.
 *   - chap09/int1_wakeup.c - INT1 használata alvás üzemmódból történő felébresztésre.
 *   - chap09/keypad.c - Egy 4x3 gombos billentyűzet megvalósítása.
 *   - chap09/ledflash_timer.c - Periodikus órainterrupt használata LED villogtatására.
 *   - chap09/ledsw1_timer.c - Periodikus Timer3 interrupt a LED/kapcsoló IO feladathoz, szemafor használattal.
 *   - chap09/ledsw1_timer2.c - Ugyanaz a feladat.mint a ledsw1_timer.c, csak interrupttal valósítja meg az állpotgépet.
 *   - chap09/ledtoggle_timer.c - LED kapcsolgatása, melyben periodikus interrupt vizsgálja a kapcsoló állapotát.
 *   - chap09/rot_enc.c - Egy 2-bites növekményes Gray kódolású forgó enkóder. 
 *   - chap09/rot_enc_trace.c - Interrupt nyomkövető buffer használata a forgó enkóder állapotainak elcsípésére.
 *   - chap09/softfilt_test.c - Szoftveres szűrőt valósít meg egy megadott hossznál rövidebb impulzusok kiszűrésére.
 *   - chap09/squarewave.c - Négyszöghullám jelalalk-generátor Timer2 és interrupt felhasználásával.
 *
 * - 10.fejezet (UART, SPI, I2C)
 *   - chap10/soft_uart.c - Szoftveres megvalósítású UART TX/RX kommunikáció
 *   - chap10/reverse_string.c - Három különböző projektben is felhasznált eljárás. 
 *   - chap10/mcp41xxx_spi_pot.c - A PIC24 SPI master módban  vezérel egy Microchip MCP41xxx digitális potenciométert.
 *   - chap10/ds1722_spi_tempsense.c - A PIC24 SPI Master módban kommunikál a Maxim DS1722 digitális hőmérővel
 *   - chap10/spi_master_revstring.c, spi_slave_revstring.c - SPI  kommunikációt használ a PIC24 - PIC24 kapcsolathoz, a mester a 
 * szolgát az átküldött szöveg megfordítására használja 
 *   - chap10/ds1621_i2c.c - PIC24 I2C Master módban kommunikál a Maxim DS1621 digitális hőmérővel.
 *   - chap10/mcp24lc515_i2c_eeprom.c - PIC24 I2C Master módban kezeli a Microchip 24LC515 EEPROM memóriát.
 *
 * - 11.fejezet: Adatkonverzió(ADC, DAC)
 *   - chap11/adc2pots1.c - Két csatornás manuális mintavételezés ADC-vel.
 *   - chap11/adc7scan1.c - Hét csatorna szekvenciális lekérdezése (csak DMA-val rendelkező PIC24-hez!).
 *   - chap11/adc7scan2.c - Ugyanaz,mi dout az előző, csak kettős puffereléssel (csak DMA-val rendelkező PIC24-hez!)).
 *   - chap11/adc4simul.c - Négy csatorna szimultán figyelése (csak DMA-val rendelkező PIC24-hez!)).
 *   - chap11/adc_spidac_test.c - A belső ADC használata 12-bites módban és a felső 8 bit kiküldése külső, SPI vezérlésű
 * 8-bites DAC-ra(MAXIM 548A).
 *
 * - 12.fejezet (Időzítők használata - PWM, input capture, output compare, időmérés)
 *    - chap12/incap_freqmeasure.c - Négyszöghullám frekvenciájának mérése Timer2 és az Input Capture mód használatával.  
 *    - chap12/incap_switch_pulse_measure.c - Gomblenyomás idejének mérése  input capture és Timer2 használatával.
 *    - chap12/ir_biphase_decode.c - Infravörös távirányítóból származó kétfázisú bitfolyam dekódolása.
 *              A protokol a Phillips VCR vezérlőé, 13 bit parancs (start bit, toggle bit, 5-bit cím, 6-bit adat).
 *              A Timer2 osztóját úgy kell megválasztani, hogy  egy bit ideje ne haladja meg az időzítési periódust.
 *    - chap12/manual_switch_pulse_measure.c - Gombnyomás impulzusszélességének mérése Timer2-vel,  input capture nélkül.
 *    - chap12/timer32bit_switch_pulse_measure.c - Gombnyomás impulzusszélességének mérése Timer2/3 -mal (32-bites módban) és INT1 használatával éldetektáló módban.
 *    - chap12/outcompare_contpulse.c - Aszimmetrikus négyszögjel generálása output compare (OC1) módban, folytonos pulzálás módban.
 *    - chap12/outcompare_squarewave.c - Nágyszöghullámelőállítása Output Compare (OC1) módban.
 *    - chap12/outputcompare_oneservo.c - Impulzusszélesség moduláció, az Output Compare (OC1) kimenet hobbi szervómotort vezérel.
 *           Az AN0 analóg bemenőjelet használjuk az impulzusszélesség változtatására annak minimális és maximális határértékei között.
 *    - chap12/outputcompare_multiservo.c - Impulzusszélesség moduláció négy digitális kimenettel és az OC1 modullal
 *        négy PWM  kimenőjel előállítására, hobbi szervómotorok vezérlésére. Egy táblázatot használunk a négy szervójel előállításához.
 *    - chap12/ledpwm.c -Impulzusszélesség moduláció bemutatása egy LED fényerejének változtatásával. Az AN0 analóg bemenetet használjuk
 *    a PWM priódus vezérlésére.
 *    - chap12/pwm_dac.c - Egy PWM DAC bemutatása - kapcsoljon egy RC szűrőt az OC1 kimenetre és változtassa a PWM jel kitöltési
 *         tényezőjét, és mérje a kondenzátoron a DC jelet. Az RC időállandó legalább tízszerese legyen a PWM periódusidejének.
 *         A kipróbálásnál R=6.8k, C = 1.0uF, PWM periódusidő= 500 us értékeket használtunk.
 *
 * - 13. fejezet Haladó témák(DMA, ECAN, I2C szolga üzemmódban, flash programozása, komparátor)
 *   - chap13/comparator_example.c - A komparátor modulegyszerű használatának bemutatása.
 *   - chap13/dma_example.c - DMA használata ping-pong módban az UART jelének beolvasására, és egy 24LC515 EEPROM-ba írására.
 *   - chap13/ecan_example_nofifo.c - CAN küldés/fogadás bemutatása. Csak egy puffert használ a vételhez és standard adatkeretet küld
 *   - chap13/ecan_example_fifo.c - CAN küldés/fogadás bemutatása. FIFO tárat használ a vételhez és standard adatkeretet küld.
 *   - chap13/ecan_example_fifo_eid.c - CAN küldés/fogadás bemutatása. FIFO tárat használ a vételhez és kiterjesztett adatkeretet küld.
 *   - chap13/flash_example.c - A flas memória futási időben történő önprogramozását mutatja be.
 *   - chap13/i2c_master_reverse_string.c, chap13/i2c_slave_reverse_string.c - a programpáros azt mutatja be, hogy a PIC24 I2C mester
 *        kommunikál a PIC24 I2C szolga eszközzel.
 *   - chap13/i2c_multmaster_rstring.c - Két PIC24 mikrovezérlő kommunikál egymással I2C vonalon, felváltva mester és szolga üzemmódban.
 *
 * - 14. fejezet ESOS példák (lásd az \ref ESOS szekciót is!).
 *   - chap14/esos_skel.c - Egyszerű ESOS alkalmazás sablonja.
 *   - chap14/app_flashled.c -  LED villogtatása.
 *   - chap14/app_echo1.c - Az echo.c program ESOS változata .
 *   - chap14/app_reverse.c - Egy felhasználói taszk bemutatása ami megfordít egy string-et.
 *   - chap14/app_timerLEDecho.c - LED villogtatása szoftveres időzítéssel.
 *   - chap14/app_semaphore1.c - Szemafor használatának bemutatására szinkronizálás jelzésére.
 *   - chap14/app_semaphore1.c - Randevú szinkronizálása szemaforral. 
 *   - chap14/app_childtask.c - Gyermek taszkok bemutatása.
 *   - chap14/app_irqs.c - Interrupt kiszolgálás ESOS alatt.
 *   - chap14/app_ds1631.c - I2C példa DS1631 használatával.
 *   - chap14/app_ds1722.c - SPI példa DS1722 használatával.
 *
 * - 15. fejezet Prof. D. Capsone példái 
 *   - chap15/audio.c, chap15/audio_adpcm.c - hangvelvétel és visszajátszás soros EEPROM és adpcm adattömörítés használatával.
 *   - chap15/reflow_oven.c, chap15/reflow_debug.c, chap15/reflow_flash.c, chap15/reflow_operate.c - Kenyérsütő mint forrasztókemence,
 *      a váltóáram szabályozását és a magas hőmérséklet mérését illusztrálja.
 *   - chap15/robot.c, chap15/robot_ir_decode.c - program egy kis háromkerekű robot vezérléséhez, IR írányítással és ütközés elkerüléssel.
 *
 * Az Explorer 16 100 lábú demókártyához adaptált mintaprogramok
 * - explorer16_100p 
 *   - explorer16_100p/reset.c  (lásd 8. fejezet) A reset, tétlen, alvás üzemmódok, és a watchdog időzítő működésének bemutatása.
 *   - explorer16_100p/lcd4bit.c  (lásd 8. fejezet) Karakteres LCD kijelző vezérlése.
 *   - explorer16_100p/adc_test.c (lásd 11. fejezet)  Bemutatja az ADC használatát 10-bites módban és a jel feszültséggé konvertálását.
 *   - explorer16_100p/rtcc.c (lásd 12. fejezet) Bemutatja a Real Time óra modulhasználatát.
 *   - explorer16_100p/timer1_sosc.c (lásd 12. fejezet)  A másodlagos, 32768 Hz-es oszcillátor használatát mutatja be.
 *   - explorer16_100p/mcp25lc256_spi_eeprom.c (lásd 10. fejezet)  Bemutatja az Explorer 16 kártya  25lc256 SPI EEPROMmemóriájának használatát. Ez nem 
 *     kapcsolódik egyik tankönyvi példaprogramhoz sem, de  a 10. fejezet mcp24lc515_i2c_eeprom.c példájához hasonló szerkezetű, bár az I2C buszt használ.
 *
 * Egyéb, a tankönyv ábráihoz nem kapcsolódó mintaprogramok:
 *   - chap11/adc_test.c - Bemutatja az ADC használatát 10-bites módban és a jel feszültséggé konvertálását.
 *   - chap11/adc_test_12bit.c - Bemutatja az ADC használatát 12-bites módban és a jel feszültséggé konvertálását.
 *   - chap11/adc7scan1_dma_scatter_gather.c - Hét csatornátmintavételez szekvenciálisan, scatter/gather módban, DMA-val  (csak DMA-val ellátott PIC-hez) - lásd az on-line H függeléket.
 *   - chap11/adc7scan1_dma_conv_order.c - Hét csatornátmintavételez szekvenciálisan, rendezett sorrendben, DMA-val  (csak DMA-val ellátott PIC-hez)- lásd az on-line H függeléket.
 *   - chap11/adc4simul_dma.c - Négy csatorna szimultán mintavételezése (csak DMA-val ellátott PIC-hez)) - lásd az on-line H függeléket..
 *   
 *   
 */
