﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"


/** \file
Ezzel a programmal kipróbálható néhány módszer a  PIC24 újraindítására,
valamint az energiatakarékos üzemmódok is tesztelhetők.
Elsősorban ahhoz a laboratóriumi gyakorlathoz való ez a program, amelynek
során a mikrovezérlő áramfelvételét mérjük az energaitakerékos üzemmódba
kapcsolás előtt és után.
*/
///--- Menüből választás egy karakter beolvasásával ---
uint8 printMenuGetChoice() {
  uint8 u8_c;
  outString("'1' enable watchdog timer\n");  //1 - WDT engedélyezése
  outString("'2' enter sleep mode\n");       //2 - Alvás üzemmódba lép
  outString("'3' enter idle mode\n");        //3 - Tétlen módba lép
  outString("'4' enable watchdog timer and enter sleep mode\n"); //4 - WDT engedélyezés és alvás 
  outString("'5' doze = divide by 2\n");     //5 - doze = frekvencia felezése
  outString("'6' doze = divide by 128\n");   //6 - doze = 128-cal történő leosztás
  outString("'7' execute reset instruction\n"); //7 - RESET utasítás végrehajtása
  outString("Choice: ");
  u8_c = inChar();      //Menüválasztáshoz beolvas egy karaktert
  outChar(u8_c);        //visszatükrözi a vett karaktert
  outString("\n");      //soremelés kiírása
  return(u8_c);
}

//A perzisztens változók tartalma megőrződik a reset során
_PERSISTENT uint8 u8_resetCount;


int main(void) {
  configClock();                //oszcillátor beállítása
  configPinsForLowPower();      //kis áramfelvételű üzemmódba kapcsolja a perifériákat, mivel áramfelvételt mérünk
  configHeartbeat();            //"életjel" LED konfigurálása
  configDefaultUART(DEFAULT_BAUDRATE); //soros port beállítása
  outString(HELLO_MSG);         //Üdvözlő üzenet kiírása

  if (_POR) {
    u8_resetCount = 0;      // bekapcsoláskor törli az újraindítás számlálót
  } else {
    u8_resetCount++;        //számlálja az újraindításokat
  }
  if (_WDTO) {
    _SWDTEN = 0;            //Ha a watc, disable Whdog időzítése letelt, tiltja WDT-t.
  }
  printResetCause();        //kiírja az újraindítás okát
  
  outString("The reset count is "); //kiírja az újraindítások számát
  outUint8(u8_resetCount);
  outString("\n");

  while (1) {
    uint8 u8_c;
    u8_c = printMenuGetChoice();
    DELAY_MS(1);  //időt hagy az UART kiürítésére mielőtt végrehajtja a kiválasztott menüpontot
    switch (u8_c) {
      case '1':         //A wachdog időzítő engedélyezése
        _SWDTEN = 1;    //WDT ENable bit = 1
        break;
      case '2':         //alvás üzemmód indítása
        asm("pwrsav #0");  //sleep
        outString("after sleep\n");   //sohasem hajtódik végre
        break;
      case '3':         //tétlen üzemmód
        asm("pwrsav #1"); //idle
        outString("after idle\n");   //sohasem hajtódik végre
        break;
      case '4':         //Watchdog time engedélyezése és alvás indítása  
        _SWDTEN = 1;      //WDT ENable bit = 1
        asm("pwrsav #0"); //sleep
        outString("after WDT enable, sleep.\n"); //felébredéskor hajtja végre
        break;
      case '5':     //Doze módba lép 2-es leosztással 
        _DOZE = 1;  //leosztás 2-vel
        _DOZEN = 1; //DOZE mód engedélyezése
        break;
      case '6':     //Doze módba lép 128-as leosztással  
        _DOZE = 7;  //leosztás 128-cal
        _DOZEN = 1; //DOZE mód engedélyezése
        break;
      case '7':
        asm("reset"); //reset végrehajtás
        break;

      default:
        break;  //hagyd figyelmen kívül, ha más kód jött
    }

  } // a while(1) ciklus vége
  return 0;
}
