﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 *
 */

// Documentation placed on the getting started page. This file only
// include comments for Doxygen; it does not contain any
// code.
/**
 * \page gettingStarted A kezdeti lépések
 * Ennek a programcsomagnak a használatához elő kell készítenie a kísérleti eszközöket:
 * -# \ref softwareInstall - Telepítse a szükséges szoftvereket egy Windows alapú személyei számítógépre!
 * -# \ref hardwareBringup - Építsen vagy vásároljon PIC24 kísérleti áramkört!
 * -# \ref pic24Test -- Használja a letöltőprogramot, töltse le az "echo" programot a PIC24 mikrovezérlőbe és próbalja ki vele a kísérleti áramkörét! 
* Ezzel ellenőrizheti a telepített szoftver és a hardver működőképességét. Az alábbi szekciókban részletesebb információt talál a fenti lépések elvégzéséhez.  
 *
 *
 * \section softwareInstall Szoftver telepítése
 * -# Töltse le a Microchip honlapjáról és telepítse az  
 *    <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en019469&part=SW007002">MPLAB IDE</a> programcsomagot. A teljes változat 
 *    telepítő csomagját (Full Release Zipped) kell kiválasztani a "Letöltések" szakaszban, közel a lap aljához.
 *     A v8.10-es változat esetében a következő gombokra kell kattintani a telepítés folyamán: 
 *     next, next, I accept/next, next, next, next, next, yes, finish.
 * -# Töltse le a Microchip honlapjáról és telepítse az 
 *    <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en010065"> MPLAB
 *    PIC24 mikrovezérlőkhöz való C fordítóját!</a>. <br />Megjegyzés:
 *    -# Először az MPLAB csomagot kell telepíten, csak utána szabad telepíteni a C30 fordítót.
 *    -# A C fordító telepítése során mindenütt fogadja el a felajánlott opciót. Különösen fontos, 
 *       hogy a "Yes" gombra kattintson a  környezeti változók módosítása ( "Modify Environment?") kérdésnél!
 *     A C fordító telepítésével nem jelenikmeg újabb program a Windows Start menüjében, csupán az MPLAB integrált 
 *   fejlesztői környezetében válik elérhetővé a C30 fordító.
 * -# Ha dsPIC mikrovezérlőhöz is szeretne programokat fejleszteni, akkor töltse le a Microchip honlapjáról és  telepítse az 
 *    <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en535363"> MPLAB
 *    PIC24 mikrovezérlőkhöz való C fordítóját is!</a> 
 * -# Ha nincs a számítógépén telepítve a Microsoft .NET keretrendszer, akkor töltse le és telepítse
 *     a .NET futtatórendszrt a
 *     <a href="http://www.microsoft.com/downloads"> Microsoft Letöltő Központ</a> honlapon a
 *	  '.NET runtime' kifejezésre keresve! A 2.0-t vagy későbbi verziót telepítse! 
 *	  Ha nem biztos abban, hogy telepítve van-e a gépén a .NET keretrendszer, akkor indítsa el a következő lépésben
 * ismertetett letöltőprogramot,  s ha az hibát jelez, akkor telepítse a .NET keretrendszert. 
 * -# Másolja a tankönyv CD-ROM mellékletéről a "code/" alkönyvtárat a számítógépére (nagyon ajánljuk, hogy az elérési útvonal
 *    ne tartalmazzon szóközt vagy ékezetes karaktereket, s legyen rövid  ( legalkalmasabb a C: meghajtó gyökérkönyvtára). 
 * Természetesen az Interneten keresztül is letöltheti ezeket a fájlokat, habár ezek
 *    kismártékben eltérhetnek a tankönyv példáitól. A legfrissebb változat
 *     <a href="http://www.ece.msstate.edu/courses/ece3724/main_pic24/labs/files/pic24_code_examples.zip"> ITT található </a>.
 * -# Próbálja ki a letöltőprogramot, ami egy .NET alkalmazás, a code\bin\winbootldr.exe program elindításával! 
 *    Egy grafikus kezelői felületnek kell megjelennie. Hiba esetén a <a href="manuallyCreated/PIC24_bully_bootloader.pdf"> letöltőprogram dokumentációjában </a>
 *    tájékozódhat a hibaelhárítás módjáról.
 *
 * \section hardwareBringup A hardver felélesztése
 * Többféle lehetőség van a programcsomag futtatásához szükséges PIC24 kísérleti áramkör beszerzésére: 
 * - \ref Wireup "Huzalozza össze egy próbapanelen" a kísérleti áramkört! 
 * - Vásárolhat egy \ref SPARKFUN "SparkFun PIC24 breakout kártyát."
 * - Vásárolhat egy \ref EXPLORER "Microchip Explorer16 demókártyát."
 * - Építhet saját demókártyát a <a href="../dsp80.html">DSP80 fejlesztői kártya</a> letölthető gyártási dokumentumainak felhasználásával.
 *
 * \section Wireup A PIC24 kísérleti áramkör összehuzalozása
 * -# Kezdje a <a href="manuallyCreated/board_walkthru_pic24.pdf"> Prototyping walk-through</a> útmutatóval, a leírtakat követve. 
 * Ez feltételezi, hogy már rendelkezik az említett útmutatóbn ismertetett kapcsolás megépítéséhez szükséges alkatrészekkel, 
 * beleértve a dugaszolós próbapanelt és az \ref FTDICABLE "FTDI USB-UART kábelt" is.
 * -# Egy \ref ICSP "ICSP programozó" felhasználással égesse be a letöltő programot (bootloader) a PIC24 mikrovezérlőbe!
 * -# Telepítse az <a href="http://www.ftdichip.com/Drivers/VCP.htm"> FTDI meghajtó szoftvert</a> 
 *    (a "setup executable" linket válassza!) hogy a PC kommunikálni tudjon  a PIC24 mikrovezérlővel \ref FTDICABLE "FTDI kábelen" keresztül. 
 * A meghajtó telepítése után az FTDI eszköz virtuális soros portként látszik a Windows felől.
 *
 * A Mississippi Állami Egyetem oktatói által ajánlott áramkör 
 * alternatívájaként mi is ajánlunk egyet a <a href="../circuit.html">Kísérleti áramkör</a> c. fejezetben, melyet akkor célszerű 
 * használnia, ha rendelkezik PICkit2 programozó készülékkel. 
 *
 * \section SPARKFUN SparkFun PIC24 breakout kártya
 * -# Vásároljon egy <a href="http://www.sparkfun.com/commerce/product_info.php?products_id=8787">  PIC24 breakout kártyát a SparkFun-tól!</a>
 * -# Legalább a 6 kivezetéses csatlakozóba forrasszon tüskesor érintkezőket az FTDI kábel csatlakoztatásához. Természetesen a többi forrasztási helyre is érdemes 
 * csatlakozó töskéket forrasztani, mert akkor a kártya dugaszolós próbapanelbe is bedugható, s így könnyen csatlakoztat külső áramköri elemeket, 
 * a mikrovezérlő lehetőségeinek kihasználására.  Ehhez az elterjedten használt 0,1 inch osztású tördelhető tüskesorra lesz szüksége.
  * -# Telepítse az <a href="http://www.ftdichip.com/Drivers/VCP.htm"> FTDI meghajtó szoftvert</a> 
 *    (a "setup executable" linket válassza!) hogy a PC kommunikálni tudjon  a PIC24 mikrovezérlővel \ref FTDICABLE "FTDI kábelen" keresztül. 
 * A meghajtó telepítése után az FTDI eszköz virtuális soros portként látszik a Windows felől.
 * -# A SparkFun PIC24 breakout kártya mikrovezérlőjébe már be vanégetve a letöltőprogram, és egy mintaprogram, ami
 *     57600 baud sebességra van konfigurálva, tehát indítsa el a letöltőprogramot, s a grafikus kezelői felületen láthatja a 
 *     mikrovezérlő ürdvözlő üzenetét és a futó mintaprogram üzeneteit. Ezután megpróbálkozhat egy program letöltésével  
 * a  \ref pic24Test "Kipróbálás az echo programmal" c. szekcióban leírtakat követve.
 * -# Haladó felhasználók megvehetik a <a href="http://www.sparkfun.com/commerce/product_info.php?products_id=194"> SparkFun ICSP csatlakózóját</a>
 *    ami lehetővé teszi, hogy egy \ref ICSP "ICSP programozó" felhasználásával a letöltőprogram nélkül is programozni tudjuk a PIC24 mikrovezérlőt.
 *
 * \section EXPLORER Explorer16 board
 * Az Explorer 16 egy fejlesztői kártya a Microchiptől, ami 100 és 44 lábszámú változatban kapható. 
 * A mikrovezérlők dugaszolható PIM modul formájában csatlakoznak a kártyához, s minden kártyához két ilyen modult is kapunk. 
 * A  <a href="../explorer16_100p"> /code/explorer16_100p</a> alkönyvtár néhány mintaprogramot tartalmaz a 100 lábú Ecplorer 16 kártyához igazítva. 
 * zek a projektek a többi könyvtárban levő állományokat is tudják használni, de az EXPLORER16_100P makrónak vagy 
 * az  include/pic24_libconfig.h állományban, vagy a Projekt opcióknál (válassza ki a Project->Build Options-> Project menüpontot, kattintson az MPLAB C30 fülre, 
 * és a Macro Definitions szakasznál kattintson az 'Add' gombra, és gépelje be az EXPLORER16_100P szöveget) . Az EXPLORER16_100P makró hatására 
 * az UART2 lesz az alapértelmezett kimenet, mert az Explorer16/100 pin kártyán ez van kivezetve a csatlakozóra. 
 * A makró hatással van az órabeállításra is: a külső 8 MHz-es oszcillátor lesz beállítva, PLL használatával, ami  
* 16 MHz-es utasításciklust eredményez PIC24F és 40 MHz-et PIC24H mikrovezérlő esetén.
 *
 * \section FTDICABLE FTDI átalakító kábel
 * Egyszerű lehetőséget kínál a PIC24 számítógéphez történő csatlakoztatására  az <a href="http://www.ftdichip.com/"> FTDI </a> 
 * <a href="http://www.ftdichip.com/Products/EvaluationKits/TTL-232R-3V3.htm"> TTL-232R-3V3 </a> típusszámú USB - UART
 * átalakító kábel. A kábel egyik vége a  PC USB portjához csatlakozik, a másik végén pedig TTL kompatibilis logikai jelszintet produkál, így
 * közvetlenül összeköthető a PIC soros I/O kivezetéseivel. Ezen kívül a kábel egyik csatlakozópontjáról +5 V-os tápfeszültség is
* levehető, így akár a kisfogyasztású kísérleti áramkörünk tápellátása is megoldható vele egy 3,3 V-os feszültségtabilizátoron keresztül.
 * További információkat az FTDI adatlapján találhat. <br />Beszerzési helyek:
 *    - <a href="http://search.digikey.com/scripts/DkSearch/dksus.dll?Detail?name=768-1015-ND"> Digi-key </a> 
 *    - <a href="http://www.mouser.com/Search/ProductDetail.aspx?qs=Xb8IjHhkxj627GFcejHp0Q%3d%3d"> Mouser </a>
 *    - SparkFun a saját <a href="http://www.sparkfun.com/commerce/product_info.php?products_id=8772"> FTDI kártyáját </a> forgalmazza, ami ugyanazzal a functionalitással rendelkezik, mint az FTDI kábel.
 *    - <a href="http://hu.farnell.com/jsp/search/productdetail.jsp?sku=1329311&_requestid=881522">Farnell</a>
 *    - <a href="http://www.soselectronic.hu/?str=371&artnum=57997">SOS-Electronic</a>
 *
 *
 * \section ICSP ICSP programozó készülékek
 * Ha olyan PIC24 mikrovezérlőt vásárol, amelyik nincs felprogramozva a betöltőprogrammal, akkor  önnek kell gondoskodnia a betöltőprogram beégetéséről, 
 * s csak utána tudja (a beégetett betöltő program segítségével) letölteni a futtatni kívánt programokat. Ha esetleg a betöltőprogram megsérül, 
 * akkor pedig újra be kell égetni azt a mikrovezérlőbe. Végül, egy haladó felhasználó úgy is dönthet, hogy kitörli a betöltőprogramot, s a PIC24 mikrovezérlőbe egy ICSP
 * programozó készülékkel tölti be a kipróbálni kívánt programot. Az ICSP az angol In Circuit Serial Programming elnevezés rövidítése, ami azt jelenti, 
 * hogy magában a kísérleti áramkörkben történik a mikrovezérlő programozása, méghozzá soros kommunikációval - csak egy adatvonal (PGD)  és 
 * egy szinkron órajel bemenet (PGC) kell hozzá.
 * Számos lehetőség közül választhatunk:
 *   - A Microchip <a href="http://www.microchip.com/pickit2"> PICkit2 </a> programozója 
 *     kedvező áron kapható; csak magára a PICkit2 készülékre van szükségünk, nem pedig a különféle "starter kit"-ekre!
* a készülék a programozáson kívül hardveres nyomkövetésre, logikai analizátorként és soros (UART) kommunikációs eszözként is használható. 
 *    A PIC24 támogatói programkönyvtár szerzői is ezt használják.
 *   - Egy másik, valamivel költségesebb eszköz a Microchip <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en010046&part=DV164005">ICD2</a> 
 * programozó és hardveres nyomkövető eszköze.
 *   - Esetleg más gyártók terméke is használható, de vásárlás előtt győződjünkmeg róla, hogy a készülék kompatibilis az általunk használni kívánt  mikrovezérlővel és az MPLAB fejlesztői környezettel.
 *   - Ugyanezt tanácsoljuk az Interneten keringő kapcsolási rajzok alapján utángyártott ICD2 és PICkit2 klónokkalkapcsolatban is. 
 *
 * A betöltőprogram beégetése PICkit2-vel a PIC mikrovezérlőbe: 
 *   -# Töltse le és telepítse a <a href="http://www.microchip.com/stellent/idcplg?IdcService=SS_GET_PAGE&nodeId=1406&dDocName=en023805"> PICkit 2 szotverét </a> a Microchip honlapjáról!
 *   -# Csatlakoztassa a PICkit2 készüléket a kísérleti áramköréhez (vagy demókártyájához)!
 *      A PICkit2 készüléken a nyíl az 1. lábat jelzi.
 *      - Lehetséges, hogya PICkit2 firmware-t frissítenie kell. Ha a PICkit kezelőprogramja ezt jelzi, akkor 
 *        kattintson a Tools -> Download PICkit 2 Operating System menüpontra.
 *   -# A PICkit2 kezelőprogramjában válassza ki a Device Family menüben a PIC24 családot!
 *      - Ha a PIC24 mikrovezérlőt nem ismeri fel automatikusan a PICkit2 készülék, akkor nyomja le a RESET gombot a kísérleti áramkörében. 
 * Miután felengedte a RESET gombot, kattintson a  Read gombra a kezelőprogramban!
 *      - Ellenőrizze, hogy a mikrovezérlőt felismerte a PICkit2 készülék!
 *      - Kattintson az Erase (törlés) gombra és törölje vele a mikrovezérlő memóriáját!
 *      - A betöltőprogram beégetni való hex állományai a különböző mikrovezérlő típusokhoz a code/hex könyvtárban találhatók.
 *         Töltse be a megfelelő hex állományt a File -> Import Hex menüpont kiválasztásával. Győződjön meg róla, hogy az 
 *         adott mikrovezérlőhöz való állományt választotta! 
 *         Ügyeljen a fájlnévben olvasható járulékos információra is (pl. baudrate)!
 *
 * \section pic24Test Az áramkör kipróbálása az echo programmal
 * A szükséges szoftver és hardver eszközökkel, felszerelkezve próbálja ki rendszerét az egyszerű 'echo' program lefordításával és letöltésével! 
 * Az echo program  egy karaktert vár az UART RX bemeneten, megnöveli a karakterkódot, 
 * és visszaküldi a  számítógépnek. A kipróbáláshoz:
 *  -# Mielőtt a  PIC24 mikrovezérlő programozásához kezdenénk, győződjünk meg róla, hogy minden szükséges szoftver telepítve van,
 * és a  PIC24-be is be van égetve a betöltőprogram (lásd az előző lépéseket). 
 *  -# Indítsa el az MPLAB programot, majd nyissa meg az echo program projektjét az MPLAB Project -> Open menüpontjában! Lehet, hogy 
 * ezt kétszer kell megtennie, amennyiben az állományok nem jelennének meg a projekt ablakban, mivel a letölthető progamkönyvtár nem
 * tartalmaz elmenetett "munkaterület" (workspace) állományokat.
 *  -# A projekt úgy ahogy van, le kell, hogy forduljon; a fordítás a Project -> Make menüpont kiválasztásával (vagy az F10 gomb megnyomásával) 
 * indítható. Ha mégsem fordul le, akkor az alábbiakat ellenőrizze:
 *     -# Kattintson a Configure -> Select Device (Konfigurálás -> Eszköz kiválasztása) menüpontra és győződjön meg róla, hogy a megfelelő 
 * mikrovezérlő típus (esetünkben PIC24HJ128GP502) van kiválasztva!
 *     -# Válassza ki a Project -> Build Options -> Project menüpontot (Projekt -> Fordítási opciók -> Projekt). A Directories (Könyvtárak) fülön a, 
 * "Show directories for:" (munatassa a könyvtárakat)
 *  listán ellenőrizze az Include Search Path (include fáljok elérési útvonala)  beállításait és győződjön meg róla, hogy azok megegyeznek 
 * az ön gépén levő MPLAB és PIC24 programkönyvtár telepítéssél.
 *  -# Sikeres fordítás után indítsa el a  <a href="manuallyCreated/PIC24_bully_bootloader.pdf"> PIC24 letöltőprogramot, </a> vagyis a 
 * PIC24 programkönyvtárral együtt letöltött code/bin/winbootloader.exe alkalmazást (Bully bootloader).
 *  -# Az FTDI USB-UART kábellel kapcsolja össze a számítógépét és a PIC24 mikrovezérlőt.
 *  -# A Bully bootloader programban válassza ki amegfelelő virtuális COM port-ot, állítsa be az adatátviteli sebességet és próbáljon 
 * csatlakozni az "OpenCOM"-ra kattintva!
 *     -# Az adatátviteli sebességet a PIC24 mikrovezérlőbe égetett betöltőprogram szabja meg, alapértelmezetten 57600 baud.
 *     -# Ha nem tudja, hogy melyik COM port-ot kell kiválasztania a Windows-ban, akkor  
 *        indítsa el a Start -> Vezérlőpult (Control Panel) -> Renszer (System)  programot(vagy ezt nyomja meg: Windows gaomb + Pause|Break). 
 *        Válassza ki a Hardver fület és kattintson az Eszközkezelőre. Itt a felugró ablakban  
 *        nyissa meg a "Portok (COM és LPT)" listát és keressen benne "USB Soros Port (COMx)" bejegyzést.
 *  -# Kattintson a  HexFile gombra és navigáljon a megnyíló párbeszédablakban ahhoz az MPLAB projekt könyvtárhoz, amelyikben az echo programot lefordította.
 *  -# Válassza ki a megfelelő .hex állományt, és kattintson az Open (megnyitás) gombra.
 *  -# Nyomja meg az MCLR gombot a PIC24 kísérleti áramkörében és 2 másodpercen belül kattintson a PROGRAM gombra a letöltőprogram ablakában!
 *     Az ablak alsó részében látni fogja a végigördülő sorokat, ahogy a program töltődik. Ha Sparkfun kártyája van 
 *     és az FTDI kábel  RTS# vonalát rákötötte a PIC24 MCLR kivezetésére, akkor csak az 
 *     "MCLR# and Prgm" gombra kell kattintania a programletöltéshez, nem kell az MCLR gombot kézzel megnyomnia.
 *  -# Amint a programletöltés befejeződött, látnia kell az Echo alkalmazás üdvözlő üzenetét.
 *  -# A Bully bootloader ablakának felső részében fehér hátterű szövegbeviteli mezőt talál. Gépeljen be egy 'a ' betűt, és nyomja meg a Send (elküldés) gombot!
 *  -# Ellenőrizze, hogy egy 'b' betű jelenik meg a kimeneti ablakban a szövegbeviteli mező alatt(az Echo program eggyel megnövelt karakterkódot küld vissza 
 *     válaszul). 
 *     A letöltőprogram részletesebb ismertetése a <a href="manuallyCreated/PIC24_bully_bootloader.pdf"> Bully Bootloader GUI documentation</a> című leírásban található.
 *  
 * Ha sikeresen eljutott idáig, akkor minden készen áll ahhoz, hogy az ebben a programcsomagban található példaprogramokat futtassa.
 * Saját alkalmazások vagy kísérleti programok készítéséhez tanulmányozza a tankönyv  \ref textbookExamples "mintaprogramjait"
 * és a \ref PIC24_support
 * "PIC24 támogatói programkönyvtár" dokumentációs oldalait!
 * 
 * Hungarion translation: István Cserny, 2009.
 */
