﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarion translation: István Cserny, 2009.
 */

/**
 * \page Robotics Robotika programkönyvtár
 *
 * \section RoboticsLibrary ESOS Robotika programkönyvtár
 * Ha az ESOS rendszer felhasználásával fejlesztünk robotokat, akkor könnyű a robot funnkcióit különálló taszkokba szervezni, s akkor
 * az ESOS képességeinek köszönhetően, a kód is közvetlenül taszkokra szeparálható. 
 * Ezen kívül, a tipikus robotok számos alapvető funkciója már implementálva van, könnyen konfigurálható ESOS könyvtári modulok formájában. 
 * A további részletek az alábbi kondigurációs állományokban  találhatók.
 * - servoconfig2.h: Szervó könyvtár, amely képes akár 7 független szervó kezelését támogatni, egyetlen időzítő felhasználásával
 * - motorconfig3.h: Motor könyvtár, amely képes akár 8 független motor kezelését támogatni, egyetlen időzítő felhasználásával
 * - comm_config.h: Kommunikációs könyvtár soros kommuninikációhoz, amit a Matlab-bal való használatra szántak 
 *
 * \section RoboticsExamples ESOS Robotika példaprogramok
 * Egyszerű mintapéldák a \ref RoboticsLibrary "robotika programkönyvtár" használatának szemláltetésére
 * - esos_servo_example.c: Példaprogram a Szervó könyvtár használatára: egy szervót kétmásodpercenként  körbeforgat a teljes működési tarományában
 * - esos_motor_example.c: Példaprogram a Motor könyvtár használatára: egy motor lehetséges üzemmódjait (előre, hátra, szabadonfutás, 
 * gyorsfékezés, és lassú fékezés) -  mindegyiket 3 másodpercig 
 * - esos_comm_example.c: Példaprogram a Kommunikációs könyvtár használatára: válaszol a helyes formátumú csomagokra és az értékeket megnövelve küldi vissza
 *
 */