﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"

/** \file
Egyszerű program,ami villogtatja a  tápfeszültséget jelző LED-et,
I/O makrók felhasználásával. RB15 nyitott nyelőelektródás 
kimenetnek van konfigurálva, és a LED-et az anód és a VDD-re felhúzó
ellenállás közös pontjára kapcsolódva vezérli. Amikor RB15 alacsony
szintre vált, akkor a LED-et lesöntöli, tehát az kialszik.
Amikor az RB15 magas szintre vált, akkor a nyitott nyelőelektródás
üzemmódnak köszönhetően lebeg, tehát nem akadályozza a felhúzó
ellenállást abban, hogy áramot hajtson a LED-en keresztül, s az vlágítson.
Mindez lehetővéteszi, hogy a LED jelezze atápfeszültség meglétét, a
villogása pedig jelzi a program futását.
*/

#define CONFIG_LED1()  CONFIG_RB15_AS_DIG_OD_OUTPUT()
#define LED1  _LATB15    //_LATB15 a regiszterbit az RB15  kimenethez

int main(void) {

  configClock();
  /********** GPIO konfigurálás **********/
  CONFIG_LED1();
  LED1 = 0;
  while (1) {
    DELAY_MS(250);  //elegendő hosszúságú késleletés, hogy lássuk a villogást
    LED1 = !LED1;  // Átbillenti a LED állapotát
  } // a while (1) ciklus vége
}
