﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"

/** \file
Egyszerű program,ami villogtatja a  tápfeszültséget jelző LED-et,
de nemhasználja az I/O makrókat. RB15 nyitott nyelőelektródás 
kimenetnek van konfigurálva, és a LED-et az anód és a VDD-re felhúzó
ellenállás közös pontjára kapcsolódva vezérli. Amikor RB15 alacsony
szintre vált, akkor a LED-et lesöntöli, tehát az kialszik.
Amikor az RB15 magas szintre vált, akkor a nyitott nyelőelektródás
üzemmódnak köszönhetően lebeg, tehát nem akadályozza a felhúzó
ellenállást abban, hogy áramot hajtson a LED-en keresztül, s az vlágítson.
Mindez lehetővéteszi, hogy a LED jelezze atápfeszültség meglétét, a
villogása pedig jelzi a program futását. 
*/

///--- Egy naív késleltető eljárás ------
void a_delay(void) {
  uint16 u16_i,u16_k;
// --- Módosítsa az alábbi számokat a késleltetés megváltoztatásához
  for (u16_k=1800; --u16_k;) {
    for (u16_i = 1200 ; --u16_i ;);
  }
}


int main(void) {
  configClock();    //az oszcillátor konfigurálása
  /********** GPIO konfigurálás **********/
#ifdef _ODB15          //PIC24F vezérlőknél így nevezik ODCB15 helyett
  _ODB15 = 1;          //nyitott nyelőelektródás üzemmód beállítása
#else
  _ODCB15 = 1;          //PIC24H esetében így nevezik...
#endif
  _TRISB15 = 0;         //RB15 legyen kimenet
  _LATB15 = 0;          //RB15 kezdetben legyen alacsony
  while (1) {           //végtelen ciklus
    a_delay();          //a késleltető eljárás hívása
    _LATB15 = !_LATB15;  //az RB15 állapotának átbillentése
  } // a while (1) ciklus vége
}
