﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"

/** \file
Egy olyan program, amelyben a véges állapotgép megközelítéssel valósítjuk meg a LED nyomógombbal történő vezérlését. 
   -# LED1 kezdetben legyen kikapcsolva!
   -# Az SW1 nyomógomb megnyomását és elengedését követően LED1-et kapcsoljuk be!
   -# Az SW1 nyomógomb újabb megnyomását és elengedését követően a programot az SW2 állásától függően így folytassuk: 
          - Ha SW2 =0 (a kapcsoló zár), akkor az 1. pontnál folytassuk!
          - Ha SW2 = 1 (a kapcsoló nyitott), akkor a 4. pontnál folytassuk!
   -# Villogtassuk LED1-et (LED1 állapotának átbillentése, majd 100 ms várakozás következzen)
   -# Az SW1 nyomógomb megnyomását követően kapcsoljuk be LED1-et (stabilan világítson)!
   -# Az SW1 nyomógomb felengedését követően folytassuk a programot az 1. pontnál!
   
Hardver:
   - LED1 RB14-re csatlakozik
   - SW1 nyomógomb RB13-ra csatlakozik
   - SW2 kapcsoló RB12-re csatlakozik
   - Az UART port RB11/RB10-re csatlakozik
*/

/// LED1 konfigurálása
#define CONFIG_LED1() CONFIG_RB14_AS_DIG_OUTPUT()
#define LED1  _LATB14            //LED1 az RB14 digitális kimenetre csatlakozik

/// SW1 - nyomógomb konfigurálása
inline void CONFIG_SW1()  {
  CONFIG_RB13_AS_DIG_INPUT();   //RB13 legyen digitális bemenet
  ENABLE_RB13_PULLUP();         //belső felhúzás engedélyezése
}

#define SW1             _RB13   //SW1 nyomógomb RB13-ra csatlakozik
#define SW1_PRESSED()   SW1==0  //lenyomott állapot feltétele
#define SW1_RELEASED()  SW1==1  //felengedett állapot feltétele

/// SW2 kapcsoló konfigurálása
inline void CONFIG_SW2()  {
  CONFIG_RB12_AS_DIG_INPUT();   //RB12 legyen digitális bemenet
  ENABLE_RB12_PULLUP();         //belső felhúzás engedélyezése
}
#define SW2             _RB12   //SW2 kapcsoló RB12-re csatlakozik

//--- A lehetséges állapotok felsorolása 
typedef enum  { 
  STATE_RESET = 0,              //Reset
  STATE_WAIT_FOR_PRESS1,        //Lenyomásra vár 1.
  STATE_WAIT_FOR_RELEASE1,      //felengedésre vár 1.
  STATE_WAIT_FOR_PRESS2,        //lenyomásra vár 2.
  STATE_WAIT_FOR_RELEASE2,      //felengedésre vár 2.
  STATE_BLINK,                  //villogás
  STATE_WAIT_FOR_RELEASE3       //felengedésre vár 3.
} STATE;

STATE e_LastState = STATE_RESET;

//Nyomkövető üzenet kiírása minden állapotváltáskor
void printNewState (STATE e_currentState) {
  if (e_LastState != e_currentState) {
    switch (e_currentState) {
      case STATE_WAIT_FOR_PRESS1:
        outString("STATE_WAIT_FOR_PRESS1 - LED is off\n");
        break;
      case STATE_WAIT_FOR_RELEASE1:
        outString("STATE_WAIT_FOR_RELEASE1\n");
        break;
      case STATE_WAIT_FOR_PRESS2:
        outString("STATE_WAIT_FOR_PRESS2 - LED is on\n");
        break;
      case STATE_WAIT_FOR_RELEASE2:
        outString("STATE_WAIT_FOR_RELEASE2 - SW2 on goes to blink else go to PRESS1\n");
        break;
      case STATE_BLINK:
        outString("STATE_BLINK - LED blinks, waiting for SW1 press\n");
        break;
      case STATE_WAIT_FOR_RELEASE3:
        outString("STATE_WAIT_FOR_RELEASE3 - LED is on\n");
        break;

      default:
        break;
    }
  }
  e_LastState = e_currentState;  //remember last state
}

int main (void) {
  STATE e_mystate;
  configBasic(HELLO_MSG);   // beállítja a villogást, és az UART portot,
                            //kiírja az üdvözlő szöveget és a diagnosztikai üzenetet
  /*** Az általános célú ki/bemenet beállítása ******/
  CONFIG_SW1();             //a nyomógomb konfigurálása
  CONFIG_SW2();             //a váltókapcsoló konfigurálása
  CONFIG_LED1();            //a LED konfigurálása
  DELAY_US(1);              //kell egy kis várakozás a felhúzások beállására
 
 /***** A STÁTUSZGÉP INDÍTÁSA *****/
  e_mystate = STATE_WAIT_FOR_PRESS1; //kezdőállapot megadása
  while (1) {
    printNewState(e_mystate);  //állapotváltáskor nyomkövető üzenet kiírása
    switch (e_mystate) {
      case STATE_WAIT_FOR_PRESS1:
        LED1=0;                //kikapcsolja a LED-et
        if (SW1_PRESSED()) e_mystate = STATE_WAIT_FOR_RELEASE1;
        break;
     case STATE_WAIT_FOR_RELEASE1:
        if (SW1_RELEASED()) e_mystate = STATE_WAIT_FOR_PRESS2;
        break;
      case STATE_WAIT_FOR_PRESS2:
        LED1=1;                //bekapcsolja a LED-et
        if (SW1_PRESSED()) e_mystate = STATE_WAIT_FOR_RELEASE2;
        break;
     case STATE_WAIT_FOR_RELEASE2:
        if (SW1_RELEASED()) {
        //SW2 állapotától függ, hogy merre folytassuk
           if(SW2) e_mystate = STATE_BLINK;        //LED1 villogtatás, ha SW2 nyitva
           else e_mystate = STATE_WAIT_FOR_PRESS1; //LED1 kikapcsolás, ha SW2 zárt
        }
        break;
      case STATE_BLINK:
        LED1=!LED1;            //villogtatja a LED-et
        DELAY_MS(100);         //késleltetés kell, hogy lássuk
        if (SW1_PRESSED()) e_mystate = STATE_WAIT_FOR_RELEASE3;
        break;
     case STATE_WAIT_FOR_RELEASE3:
        LED1 = 1;              //LED1 állapotát befagyasztjuk '1'-re
        if (SW1_RELEASED()) e_mystate = STATE_WAIT_FOR_PRESS1;
        break;
      default:
        e_mystate = STATE_WAIT_FOR_PRESS1;
    }                          //switch(e_mystate)  vége
    DELAY_MS(DEBOUNCE_DLY);    //pergésmentesítő késleltetés
    doHeartbeat();             //életjelzés, hogy fut a program
  }                            //a while (1) ciklustörzs vége
}
