﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
 * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"

/** \file
Egy példaprogram, amely a véges állapotgép megközelítést
használja arra, hogy egy LED állapotát átkapcsolja,
amikor egy nyomógombot megnyomunk, majd elengedünk.
Bumutatja azt is, hogy hogyan kell használni a pergésmentesítő
késleltetést a nyomógombhoz csatlakozó bemenet
pollingos  (szoftveres lekérdezés) kezelésnél.
*/

///--- LED1  konfigurálása (RB14-re csatlakozik) ---
#define CONFIG_LED1() CONFIG_RB14_AS_DIG_OUTPUT()
#define LED1  _LATB14     //led1 állapot

///--- SW1 konfigurálása  (RB13-ra csatlakozik) ---
inline void CONFIG_SW1()  {
  CONFIG_RB13_AS_DIG_INPUT();   //RB13 legyen digitális bemenet
  ENABLE_RB13_PULLUP();         //belső felhúzés engedélyezése
}
#define SW1              _RB13  //SW1 definiálása
#define SW1_PRESSED()   SW1==0  //lenyomott állapot feltétele
#define SW1_RELEASED()  SW1==1  //felengedett állapot feltétele

typedef enum  {
  STATE_RESET = 0,
  STATE_WAIT_FOR_PRESS,
  STATE_WAIT_FOR_RELEASE
} STATE;

STATE e_lastState = STATE_RESET;
//Nyomkövető üzenet kiírása, ha állapotváltás történt
void printNewState (STATE e_currentState) {
  if (e_lastState != e_currentState) {
    switch (e_currentState) {
      case STATE_WAIT_FOR_PRESS:
        outString("STATE_WAIT_FOR_PRESS\n");
        break;
      case STATE_WAIT_FOR_RELEASE:
        outString("STATE_WAIT_FOR_RELEASE\n");
        break;
      default:
        outString("Unexpected state\n");
        break;
    }
  }
  e_lastState = e_currentState;  //megjegyzi a legutóbbi állapotot
}

int main (void) {
  STATE e_mystate;

  configBasic(HELLO_MSG);      // "életjel" és a UART beállítása, induló üzenet kiírása
  /** GPIO konfigurálás ***************************/
  CONFIG_SW1();        // SW1 konfigurálása
  CONFIG_LED1();       //LED1 konfigurálása
  DELAY_US(1);         //a felhúzások beállására vár egy kicsit
  /*****Átbillenti a LED állapotát ha a gombot lenyomtuk,majd felengedtük ****************/
  e_mystate = STATE_WAIT_FOR_PRESS;

  while (1) {
    printNewState(e_mystate);  //nyomkövető üzenet kiírása, ha állapotváltás történt
    switch (e_mystate) {
      case STATE_WAIT_FOR_PRESS:
	  // lenyomásra várunk
        if (SW1_PRESSED()) e_mystate = STATE_WAIT_FOR_RELEASE;
        break;
      case STATE_WAIT_FOR_RELEASE:
	  // felengedésre várunk
        if (SW1_RELEASED()) {
          LED1 = !LED1;   //LED1 átbillentése
          e_mystate = STATE_WAIT_FOR_PRESS;
        }
        break;
      default:
        e_mystate = STATE_WAIT_FOR_PRESS;
    } //a switch(e_mystate) törzs vége
    DELAY_MS(DEBOUNCE_DLY);    //Pergésmentesítés
    doHeartbeat();             //életjel LED villogtatása
  } // a while (1) ciklus vége
}
