﻿/*
 * "Copyright (c) 2008 Robert B. Reese, Bryan A. Jones, J. W. Bruce ("AUTHORS")"
 * All rights reserved.
 * (R. Reese, reese_AT_ece.msstate.edu, Mississippi State University)
 * (B. A. Jones, bjones_AT_ece.msstate.edu, Mississippi State University)
 * (J. W. Bruce, jwbruce_AT_ece.msstate.edu, Mississippi State University)
 *
 * Permission to use, copy, modify, and distribute this software and its
 * documentation for any purpose, without fee, and without written agreement is
 * hereby granted, provided that the above copyright notice, the following
 * two paragraphs and the authors appear in all copies of this software.
 *
 * IN NO EVENT SHALL THE "AUTHORS" BE LIABLE TO ANY PARTY FOR
 * DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT
 * OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF THE "AUTHORS"
 * HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * THE "AUTHORS" SPECIFICALLY DISCLAIMS ANY WARRANTIES,
 * INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY
 * AND FITNESS FOR A PARTICULAR PURPOSE.  THE SOFTWARE PROVIDED HEREUNDER IS
 * ON AN "AS IS" BASIS, AND THE "AUTHORS" HAS NO OBLIGATION TO
 * PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS."
 *
 * Please maintain this header in its entirety when copying/modifying
 * these files.
 *
  * Hungarian translation: István Cserny, 2009
 */

#include "pic24_all.h"

/** \file
Egy program, ami átbillenti LED1 állapotát, amikor az SW1 nyomógombot megnyomjuk
és elengedjük. Nem használja a véges állapotgép megközelítést.
*/

///--- LED1 az RB14 kimenetre csatlakozik ---
#define CONFIG_LED1() CONFIG_RB14_AS_DIG_OUTPUT()
#define LED1  _LATB14           //LED1 állapota

///--- SW1 konfigurálása ---
inline void CONFIG_SW1()  {
  CONFIG_RB13_AS_DIG_INPUT();   //RB13 legyen digitális bemenet
  ENABLE_RB13_PULLUP();         //belső felhúzés engedélyezése
}
#define SW1              _RB13  //SW1 definiálása
#define SW1_PRESSED()   SW1==0  //a lenyomott állapot feltétele
#define SW1_RELEASED()  SW1==1  //a felengedett állapot feltétele

int main (void) {
  configBasic(HELLO_MSG); // "életjel" és a UART beállítása, induló üzenet kiírása
  /*** általános célú ki/bemenetek konfigurálása ***/
  CONFIG_SW1();           // a nyomógomb bemenet konfigurálása
  CONFIG_LED1();          // a LED kimenet konfigurálása
  DELAY_US(1);            // A felhúzások beállásáig vár
  LED1 = 0;               // LED1 kezdetben legyen kikapcsolva
  while (1) {
    // lenyomásra várunk
    while (SW1_RELEASED()) doHeartbeat();
    DELAY_MS(15);         //pergésmentesítés
    // felengedésre várunk
    while (SW1_PRESSED()) doHeartbeat();
    DELAY_MS(15);         // pergésmentesítő késleltetés
    LED1 = !LED1;         // LED1 állpotának átbillentése
  }
}
