procedure TForm1.Form1Create(Sender: TObject);
Var
    Board    : IPCB_Board;
    Net,NewNet  : IPCB_Net;
    Iterator    : IPCB_BoardIterator;
Begin
     form1.caption:='HeatSink Placer';
     form1.left:=(screen.width-form1.width) div 2;
     form1.top:=(screen.height-form1.height) div 2;

    Board := PCBServer.GetCurrentPCBBoard;
    If Board = Nil Then Exit;

    Iterator := Board.BoardIterator_Create;
    Iterator.AddFilter_ObjectSet(MkSet(eNetObject));
    Iterator.AddFilter_LayerSet(AllLayers);
    Iterator.AddFilter_Method(eProcessAll);

    // Search for Net object that has the 'GND' name.
    Net := Iterator.FirstPCBObject;
    While (Net <> Nil) Do
    Begin
        combobox1.items.add(Net.Name);
        Net := Iterator.NextPCBObject;
    End;
    Board.BoardIterator_Destroy(Iterator);
    combobox1.itemindex:=0;
end;

procedure TForm1.Button1Click(Sender: TObject);
Var
    Board    : IPCB_Board;
    Sheet    : IPCB_Sheet;
    Track    : IPCB_Track;
    Arc      : IPCB_Arc;
    Via      : IPCB_Via;
    Fill     : IPCB_Fill;
    Net,NewNet  : IPCB_Net;
    Iterator    : IPCB_BoardIterator;

    PadCache : TPadCache;
    x1,y1,   : TCoord;
    x2,y2    : TCoord;
    xa,ya    : TCoord;
    radi     : TCoord;
    n, nx, cx,cy: integer;
begin

    form1.visible:=false;

    Board := PCBServer.GetCurrentPCBBoard;
    If Board = Nil Then Exit;

    Iterator := Board.BoardIterator_Create;
    Iterator.AddFilter_ObjectSet(MkSet(eNetObject));
    Iterator.AddFilter_LayerSet(AllLayers);
    Iterator.AddFilter_Method(eProcessAll);

    // Search for Net object that has the 'GND' name.
    Net := Iterator.FirstPCBObject;
    While (Net <> Nil) Do
    Begin
        If Net.Name = combobox1.text Then
        Begin
            NewNet := Net;
            Break;
        End;
        Net := Iterator.NextPCBObject;
    End;
    Board.BoardIterator_Destroy(Iterator);

    // Initialize the systems in the PCB Editor.
    PCBServer.PreProcess;
    Sheet := Board.PCBSheet;

    //Get Coordinates
    Board.ChooseLocation(x1,y1, 'Select 1st corner at Letf & Up');
    Board.ChooseLocation(x2,y2, 'Select 2nd corner at Right & Down');

    xa := x1;
    ya := y2;

    cx:=0;
    cy:=0;
    while(xa<x2) do
    begin
       cx:=cx+1;
       xa:=xa+milstocoord(strtoint(edit3.text));
    end;
    while(ya<y1) do
    begin
       cy:=cy+1;
       ya:=ya+milstocoord(strtoint(edit4.text));
    end;

    //showmessage(inttostr(cx));
    //showmessage(inttostr(cy));

    xa := x1;
    ya := y2;

    while (ya<y1) do
    begin

    Via   := PCBServer.PCBObjectFactory(eViaObject, eNoDimension, eCreate_Default);

    Via.Size      := MilsToCoord(strtoint(edit2.text));
    Via.HoleSize  := MilsToCoord(strtoint(edit1.text));
    Via.LowLayer  := eTopLayer;
    Via.HighLayer := eBottomLayer;
    Padcache                           := Via.GetState_Cache;
    Padcache.ReliefAirGap              := MilsToCoord(11);
    Padcache.PowerPlaneReliefExpansion := MilsToCoord(11);
    Padcache.PowerPlaneClearance       := MilsToCoord(11);
    Padcache.ReliefConductorWidth      := MilsToCoord(11);
    Padcache.SolderMaskExpansion       := MilsToCoord(11);
    Padcache.SolderMaskExpansionValid  := eCacheManual;
    Padcache.PasteMaskExpansion        := MilsToCoord(11);
    Padcache.PasteMaskExpansionValid   := eCacheManual;
    Via.SetState_Cache                 := Padcache;

        Via.x := xa;
        Via.y := ya;

        xa:=xa+milstocoord(strtoint(edit3.text));
        if(xa>x2) then
        begin
          xa:=x1;
          ya:=ya+milstocoord(strtoint(edit4.text));
        end;

        Via.Net := NewNet;
        Board.AddPCBObject(Via);
        PCBServer.SendMessageToRobots(Board  .I_ObjectAddress, c_Broadcast, PCBM_BoardRegisteration, Via.I_ObjectAddress);
    end;

    // Finalize the systems in the PCB Editor.
    PCBServer.PostProcess;

    if checkbox1.checked=true then
    begin
         Fill := PCBServer.PCBObjectFactory(eFillObject, eNoDimension, eCreate_Default);

         Fill.X1Location := x1-milstocoord(strtoint(edit3.text) div 2);
         Fill.X2Location := x1+milstocoord(cx*strtoint(edit3.text))-milstocoord(strtoint(edit3.text) div 2);
         Fill.Y1Location := y2-milstocoord(strtoint(edit4.text) div 2);
         Fill.Y2Location := y2+milstocoord(cy*strtoint(edit4.text))-milstocoord(strtoint(edit4.text) div 2);

         Fill.Layer := eTopLayer;
         Fill.Rotation := 0;
         Fill.Net:=NewNet;
         Board.AddPCBObject(Fill);
         PCBServer.SendMessageToRobots(Board  .I_ObjectAddress, c_Broadcast, PCBM_BoardRegisteration, Fill.I_ObjectAddress);

         Fill := PCBServer.PCBObjectFactory(eFillObject, eNoDimension, eCreate_Default);
        Fill.X1Location := x1-milstocoord(strtoint(edit3.text) div 2);
         Fill.X2Location := x1+milstocoord(cx*strtoint(edit3.text))-milstocoord(strtoint(edit3.text) div 2);
         Fill.Y1Location := y2-milstocoord(strtoint(edit4.text) div 2);
         Fill.Y2Location := y2+milstocoord(cy*strtoint(edit4.text))-milstocoord(strtoint(edit4.text) div 2);
         Fill.Layer := eBottomLayer;
         Fill.Rotation := 0;
         Fill.Net:=NewNet;
         Board.AddPCBObject(Fill);
        PCBServer.SendMessageToRobots(Board  .I_ObjectAddress, c_Broadcast, PCBM_BoardRegisteration, Fill.I_ObjectAddress);
    end;

    // Refresh PCB screen
    Client.SendMessage('PCB:Zoom', 'Action=Redraw' , 255, Client.CurrentView);


   Close;
end;

