#include    <p18f4520.h>
#include    <i2c.h>
#include	<myLCD.h>
#include	<timers.h>
#include	<delays.h>
#include	<stdlib.h>
#include	<string.h>
#include    <stdio.h>
#include    "myClock.h"

#pragma config WDT = OFF
#pragma config OSC = HS 
#pragma	config LVP = OFF

char ora[20];
unsigned char TimeBuffer[8] = {0,0,0,0,0,0,0,0};

void Delay5ms( void )
{
	Delay1KTCYx(20); //Delay of 5ms
	return;
}

char toBCD(char bin_val)
{
	char temp;
	char retval;

	temp = bin_val;
	retval = 0;

	while(1)
	{
		if(temp >= 10)
		{
			temp -= 10;
			retval += 0x10; 
		}
		else            
		{
			retval += temp; 
			break;
		}
	}
	return(retval);
}

void InitI2C(void)
{   
    /* Portok belltsa*/
	ADCON1 = 0b00001110; // csak az AN0 bemenet a tobbi kimenet
	LATD   = 0;
	TRISA  = 0; //bemenet
	TRISC  = 0; //bemenet
	TRISD  = 1; //kimenet

	SSPADD = 49; //100000=20000000/(4*(SSPADD+1))
    OpenI2C(MASTER, SLEW_OFF);            //open I2C as master

	PIR1  = 0; // Power On Reset
    PIE1  = 0; // a perifria megszaktsok tiltsa

	SSPSTAT = 0x80; //slew rate vezrls tiltva
    SSPCON1bits.SSPEN = 1; // Soros port engedlyezs
}

void InitRTC(void)
{
	StartI2C();	
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!
		Delay5ms();	
	WriteI2C(0b01100100); // rs
		IdleI2C();
		Delay5ms();	
	WriteI2C(0xF0); // Kezdcm tkldse
		IdleI2C();	
		Delay5ms();	
	WriteI2C(0x20); // Control2 regiszter rs, 24 rs zemmd
		IdleI2C();	
		Delay5ms();	
	StopI2C();
		IdleI2C();
		Delay5ms();	
}

void Clock_Write(void)
{
	char i;

	StartI2C();	
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!
		Delay5ms();	
	WriteI2C(0b01100100); // rs
		IdleI2C();
		Delay5ms();
	WriteI2C(0x00); // rs
		IdleI2C();
		Delay5ms();

	for(i=0;i<7;i++)
	{
		WriteI2C(TimeBuffer[i]); // rs
		IdleI2C();
		Delay5ms();
	}

	StopI2C();
		IdleI2C();
		Delay5ms();
}

void setTime(unsigned int hour, unsigned int min, unsigned int sec)
{	
	char i;

	TimeBuffer[SECONDS_REG]     = sec; // seconds
	TimeBuffer[MINUTES_REG]     = min; // minutes
	TimeBuffer[HOURS_REG]       = hour; // hour
	TimeBuffer[DAY_OF_WEEK_REG] = 0;  // not used
	TimeBuffer[DATE_REG]        = 02; // date   // 2007.03.02.
	TimeBuffer[MONTH_REG]       = 03; // month
	TimeBuffer[YEAR_REG]        = 07; // year

    // toBCD
	for(i=0; i<7; i++)
	{
		TimeBuffer[i] = toBCD(TimeBuffer[i]);
	}

	TimeBuffer[SECONDS_REG] &= 0x7f;
	TimeBuffer[HOURS_REG]   &= 0x3f;
} 

void Clock_Read(void)
{
	int i;
	unsigned char seconds;

	StartI2C();	
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!
		Delay5ms();
	WriteI2C(0b01100100); // rs
		IdleI2C();
		Delay5ms();
	WriteI2C(0x00); // Msodperc cmnek tkldse
		IdleI2C();
		Delay5ms();
	RestartI2C();
		IdleI2C();
		Delay5ms();
	WriteI2C(0b01100101); // Olvass
		IdleI2C();
		Delay5ms();	
	getsI2C(TimeBuffer, 7);
		IdleI2C();	
		Delay5ms();
    sprintf (ora, "%02X : %02X  %02X",TimeBuffer[2], TimeBuffer[1], TimeBuffer[0]); 
	KijelzoIras(ora,1);  
		Delay5ms();
	StopI2C();
		IdleI2C();
}

void main (void)
{   
	Megnyitas(); // komm. csatorna megnyitsa az LCD-nek

	InitI2C (); // I2C inicializlsa
	InitRTC(); // ra inicializlsa
	setTime(13,12,30); // id belltsa
	Clock_Write(); // az ra belltsa a setTime alapjn
   	while(1)
	{
		Clock_Read(); // ra olvassa
		Delay5ms();
	}
}
