; Ricoh RS5C372A ra ic kezelse.
; Az idt msodpercenknt soros porton kikldi.
; RS5C372A - INTB kimeneten 1Hz-s jel. => Pic PortC,3
; 

	list      p=16F876           
	#include <p16F876.inc> 
	#include "main.mac"
	__CONFIG _CP_OFF & _WDT_OFF & _BODEN_OFF & _PWRTE_OFF & _XT_OSC & _LVP_OFF
	

                ERRORLEVEL -302

;#define		gomb		PORTC,5

#define		touch_cntrl	b'10010000'	; TSC2003 slave cim (irs)


temp		equ	20h 
temp1		equ	21h
temp2		equ	22h
timer1		equ	23h

sec		equ	30              ; tmeneti regiszterek
min		equ	31
hour		equ	32
day_of_week	equ	33
day		equ	34
month		equ	35
year		equ	36



reset
		boot
start
		bank1
		clrf	ADCON0
		movlw	b'10000100'
		movwf	ADCON1		; RA analg bemenet !!!
		bank0

		movlw	B'11111111'
		banksel	TRISA
		movwf	TRISA
		banksel	PORTA
		clrf	PORTA 

		movlw	B'10111111'
		banksel	TRISC
		movwf	TRISC
		banksel	PORTC
		clrf	PORTC

serial_config
		BANKSEL	SPBRG
		clrf	SPBRG
		movlw	d'12'
		MOVWF	SPBRG
		clrf	TXSTA
		MOVLW	B'00100110'	
		MOVWF	TXSTA
		BANKSEL	RCSTA
		clrf	RCSTA	
		MOVLW	B'10011000'	
		MOVWF	RCSTA

i2c_config
		bank1
		clrf	PIE1
		clrf	INTCON
		bank1	
		movlw	b'10000000'
		movwf	SSPSTAT	
		movlw	b'00000001'
		BANKSEL	SSPADD
		movwf	SSPADD
		bank0
		movlw	B'00101000'
		BANKSEL	SSPCON
		movwf	SSPCON

		clrf	sec
		clrf	min
		clrf	hour
		clrf	day_of_week
		clrf	day
		clrf	month
		clrf	year

		call	I2C_startcond
		movlw	b'01100100'
		call	I2C_send
		movlw	b'11110000'
		call	I2C_send
		call	I2C_restartcond	
		movlw	b'01100100'
		movwf	temp
		bsf	temp,0
		movfw	temp
		call	I2C_send	
		call	I2C_receive
		movwf	temp
		clrc
		call	I2C_ack
		call	I2C_stopcond	

		btfsc	temp,4
		goto	set_rtc
progz
		btfsc	PORTC,5
		goto	$-1

		call	I2C_startcond
		movlw	b'01100100'		; ra slave cm
		call	I2C_send
		movlw	b'11110000'		; control2 reg cm
		call	I2C_send
		movlw	b'00101011'		; control2 data
		call	I2C_send
		call	I2C_restartcond	
		movlw	b'01100100'
		call	I2C_send
		movlw	b'00000000'
		call	I2C_send
		call	I2C_restartcond	
		movlw	b'01100100'
		movwf	temp
		bsf	temp,0
		movfw	temp
		call	I2C_send	
		call	I2C_receive
		movwf	sec
		call	I2C_ack2
		call	I2C_receive
		movwf	min
		call	I2C_ack2
		call	I2C_receive
		movwf	hour
		call	I2C_ack2
		call	I2C_receive
		movwf	day_of_week
		call	I2C_ack2
		call	I2C_receive
		movwf	day
		call	I2C_ack2
		call	I2C_receive
		movwf	month
		call	I2C_ack2
		call	I2C_receive
		movwf	year
		clrc
		call	I2C_ack
		call	I2C_stopcond

		movfw	sec
		ki_soros_
		movfw	min
		ki_soros_
		movfw	hour
		ki_soros_
		movfw	day_of_week
		ki_soros_
		movfw	day
		ki_soros_
		movfw	month
		ki_soros_
		movfw	year
		ki_soros_
	
		goto	progz

set_rtc
		movlw	a'T'
		ki_soros_
		movlw	a'i'
		ki_soros_
		movlw	a'm'
		ki_soros_
		movlw	a'e'
		ki_soros_
		movlw	a':'
		ki_soros_

		call	I2C_startcond
		movlw	b'01100100'		; ra slave cm
		call	I2C_send
		movlw	b'11100000'		; bels cm dekder cim (0000)
		call	I2C_send
		movlw	b'00100100'		; control1
		call	I2C_send
		movlw	b'00101011'		; control2
		call	I2C_send
		movlw	h'0'			; sec
		call	I2C_send
		movlw	h'20'			; perc
		call	I2C_send
		movlw	h'20'			; ra
		call	I2C_send
		movlw	h'06'			; day of the week
		call	I2C_send
		movlw	h'08'			; nap szmll (dtum)
		call	I2C_send
		movlw	h'12'			; hnap szmll
		call	I2C_send
		movlw	h'06'			; v szmll (2006)
		call	I2C_send
		call	I2C_stopcond	
		call	wait
		call	wait
		goto	progz
; ================================================

wait						; ksleletet rutin.
		movlw	d'255'
		movwf	timer1
		decfsz	timer1,f
		goto	$-1
		return
; ================================================
I2C_startcond
		bank1
		bsf	SSPCON2, SEN
		bank0		
		btfss	PIR1, SSPIF
		goto	$-1			; wr mig vge a START llapotnak
		bcf	PIR1, SSPIF
		return
I2C_restartcond	
		bank1
		bsf	SSPCON2, RSEN
		bank0		
		btfss	PIR1, SSPIF
		goto	$-1			; vr mig vge a RESTART llapotnak
		bcf	PIR1, SSPIF
		return
I2C_stopcond	
		bank1
		bsf	SSPCON2, PEN
		bank0		
		btfss	PIR1, SSPIF
		goto	$-1			; vr mig vge a STOP llapotnak
		bcf	PIR1, SSPIF
		return
I2C_send	
		movwf	SSPBUF
		btfss	PIR1, SSPIF
		goto	$-1			; vr mig vge a kldsnek
		bcf	PIR1, SSPIF
		bank1
		bsf	STATUS,Z		
		btfss	SSPCON2, ACKSTAT	; ACK detektlsa
		bcf	STATUS,Z
		bank0
		return
I2C_receive	
		bank1
		bsf	SSPCON2, RCEN		; vev bekapcsol
		bank0
		btfss	PIR1, SSPIF
		goto	$-1			; vr mig jn adat
		bcf	PIR1, SSPIF
		movf	SSPBUF,w		; vett adat w -ben
		return
I2C_ack		
		bank1
		bsf	SSPCON2, ACKDT
		btfsc	STATUS,C
		bcf	SSPCON2, ACKDT		; set acknowledge bit
		bsf	SSPCON2, ACKEN		; start ack. sequence
		bank0
		btfss	PIR1, SSPIF
		goto	$-1			; wait for end of ack.
		bcf	PIR1, SSPIF
		return

I2C_ack2
		bank1
		bcf	SSPCON2, ACKDT		; set acknowledge bit
		bsf	SSPCON2,ACKEN		; acknowledge bit generls
		bank0
		btfss	PIR1, SSPIF
		goto	$-1			; wait for end of ack.
		bcf	PIR1, SSPIF
		return


		end
