$cpu 80386
$optimize speed
$debug pbdebug off
$error all off
$lib com-,lpt-,cga-,ega-,vga+,herc-,fullfloat-,iprint-
$option cntlbreak off
$float emulate
%MOUSE=1                                 'Maus aus wegen Tools
$INCLUDE "STDIO.H"                       'Tools einbinden
$INCLUDE "WIN_MAN.H"
$INCLUDE "DIAPROF.H"
DEFINT A-Z                               'Alle Variablen als Integer definieren
INI$="minids.ini"
DAT$="minids.dat"
%PCrun=3                                 'Speed-Nr des PC-gesteuerten Mode
Textlaenge=52                            'Lngen der einzelnen Sprachen
Helpbeginn=32                            'Beginn der Hilfetexte
on error goto Fehler
DIM TEXT$(Textlaenge)                    'Array fr Texte
DIM Null(1)                              'Speicher fr Nullinien
DIM Umax!(1)                             'Speicher fr Wert des Vollausschlages
DIM Umax$(1)
DIM HUGE Sample(640,51)                  'Array fr Mewertspeicherung dimensionieren
CALL ReadSetup                           'Einstellungen aus .INI laden

Instruction$=lcase$(command$)
if instr(Instruction$,"/h") then call Info
if instr(Instruction$,"/?") then call Info
if instr(Instruction$,"/setup") then call startsetup

OUT Address,Speed   'Taktfrequenz
OUT Address+2,4     'Reset der Schaltung
OUT Address+2,0
CALL MDEFSTAT(%OFF)                      'Maus aus
CALL Bildschirm                          'Bildschirm vorbereiten

DO
   DO
      LINE (1,Null(Range)) - (640,Null(Range)),0       'Nullinie lschen
      LINE (1,Messhoehe) - (640,Messhoehe),0           'Melinie lschen
      Eingabe$=INKEY$                    'Tastatur abfragen
      Eingabe=LASTKEYX%
      CALL CLEARKEY
      IF Eingabe=%F1 THEN
         CALL Help
         CALL Bildschirm
      ELSEIF Eingabe=%F2 THEN
         CALL ToggleHD
      ELSEIF Eingabe=%F3 THEN
         CALL Setup
         CALL Bildschirm
         OUT Address,Speed   'Taktfrequenz
         OUT Address+2,4     'Reset der Schaltung, wegen des Setup
         OUT Address+2,0
      ELSEIF Eingabe=%F4 THEN
         Null(Range)=Sample              'Neue Nullinie
      ELSEIF Eingabe=%F5 THEN
         CALL Bildschirm
      ELSEIF Eingabe=%F6 THEN
         CALL Togglerefresh
      ELSEIF Eingabe=%F7 THEN
         CALL Togglerange
      ELSEIF Eingabe=%F8 THEN
         CALL ToggleFreeze
      ELSEIF Eingabe=%F10 THEN
         CALL Ende
      ELSEIF Eingabe=%cLEFT AND Anzahl?>10 THEN
         DECR Anzahl?,10
         CALL Bildschirm
      ELSEIF Eingabe=%cRIGHT AND Anzahl?<42 THEN
         INCR Anzahl?,10
         CALL Bildschirm
      ELSEIF Eingabe=%LEFT AND Anzahl?>1 THEN
         DECR Anzahl?
         CALL Bildschirm
      ELSEIF Eingabe=%RIGHT AND Anzahl?<51 THEN
         INCR Anzahl?
         CALL Bildschirm
      ELSEIF Eingabe=%cPGUP AND Messhoehe>56 THEN
         DECR Messhoehe,10
      ELSEIF Eingabe=%cPGDN AND Messhoehe<291 THEN
         INCR Messhoehe,10
      ELSEIF Eingabe=%PGUP AND Messhoehe>45 THEN
         DECR Messhoehe
      ELSEIF Eingabe=%PGDN AND Messhoehe<300 THEN
         INCR Messhoehe
      END IF

      LINE (1,Messhoehe) - (640,Messhoehe) ,5          'Melinie ausgeben
      LINE (1,Null(Range)) - (640,Null(Range)),14      'Nullinie zeichnen
      LOCATE 22,3                                      'Wert der Melinie zur Nullinie ausgeben
      PRINT USING TEXT$(6);(Null(Range)-Messhoehe)/255*Umax!(Range)
      LOCATE 24,3
      PRINT USING TEXT$(11);Anzahl?                    'Anzahl der Samples ausgeben
   LOOP UNTIL Gestoppt=%OFF

   IF NOT Speed=%PCrun THEN
      DO
         Status=INP(Address+1)
         Ready=BIT(Status,7)
      LOOP UNTIL Ready=1
      OUT Address,%PCrun                        'PC-Taktwhlen
   END IF

   OUT Address,%PCrun
      FOR Spalte = 1 to 640
      FOR X? = 1 to Anzahl?                     'Anzahl der Mewerte pro Spalte
         IF Speed=%PCrun THEN
            FOR I??? = 0 TO PCrunWait???
            NEXT
         END IF
         IF Refresh=%ON THEN
            PSET (Spalte, Sample(Spalte,X?)),0  'Altes Sample lschen
         END IF
         OUT Address+2,0+Range                  'Lesen des Lower Nibble
         Lower?=inp(Address+1)                  'Lower Nibble an Port einlesen
         Lower?=Lower? AND &H78                 'Datenmll aussortieren
         SHIFT RIGHT Lower?,3                   'Daten schieben
         OUT Address+2,8+Range                  'Lesen des Upper Nibble
         Upper?=inp(Address+1)                  'Upper Nibble an Port einlesen
         Upper?=Upper? AND &H78                 'Datenmll aussortieren
         SHIFT LEFT Upper?,1                    'Daten schieben
         RealSample?=Upper? OR Lower?           'Daten zusammensetzen
         Sample=300-RealSample?                 'Umrechnen
         OUT Address+2,2+Range                  'Weitertakten
         Sample(Spalte,X?)=Sample               'Mewert speichern im RAM
         PSET (Spalte, Sample),10               'Mewert darstellen
         IF HDRecording=%ON THEN
            PUT #2, HDPosition??? , RealSample? 'Mewert auf HD bannen
            INCR HDPosition???
         END IF
      NEXT X?
   NEXT Spalte
   OUT Address,Speed      'Taktfrequenz
   OUT Address+2,4+Range  'Reset der Schaltung
   OUT Address+2,2+Range  'Ein weiterer Takt damit der Reset des Zhlers ins Latch bernommen wird
   OUT Address+2,0+Range
LOOP

'------------------- Ende des Hauptprogrammes -----------------------------

SUB Bildschirm                           'Bildschirm vorbereiten
   SHARED TEXT$(), Refresh, Range, Speed, Clock???
   SHARED Gestoppt, Umax!(), HDRecording, PCrunWait???
   CALL MDEFSTAT(%OFF)                   'Maus aus
   SCREEN 12                             'Auf VGA 640*480 Pixel farbig einstellen
   CLS
   FOR Spalte = 1 to 640                 'Hilfslinien zeichnen
      PSET (Spalte,43),5
      PSET (Spalte,44),5
      PSET (Spalte,301),5
      PSET (Spalte,302),5
   NEXT
   LOCATE 21,3
   IF Range=1 THEN
      PRINT USING TEXT$(5); Umax!(1)
      ELSE
      PRINT USING TEXT$(5); Umax!(0)
   END IF
   LOCATE 26,3
   IF HDRecording=%ON THEN
      PRINT TEXT$(29)
      ELSE
      PRINT TEXT$(30)
   END IF
   LOCATE 27,3                           'Ausgabe, da sonst nur bei nderung
   IF Refresh=%on THEN                   ' ausgegeben
      PRINT TEXT$(9)
      ELSE
      PRINT TEXT$(10)
   END IF
   IF Gestoppt=%ON THEN
      LOCATE 29,3
      PRINT TEXT$(12)
   ELSE
      IF Speed=%PCrun THEN
         LOCATE 29,3
         PRINT USING TEXT$(31)+" ###,###,###          ";(PCrunWait???)
      ELSE
         LOCATE 29,3
         PRINT USING TEXT$(8)+" ###,###,###";(Clock???/2/EXP10(Speed))
      END IF
   END IF
END SUB

SUB Ende
   SHARED TEXT$()
   SCREEN 0
   CLOSE
   CLS
   CALL savesetup
   PRINT TEXT$(7)
   PRINT
   print "Free for non-commercial use only. ALL RIGHTS RESERVED."
   print "Programmed by: Martin Clausen, Germany"
   print "               email: e.builder@rotgradpsi.de"
   print
   END
END SUB

SUB ToggleRefresh
   SHARED Refresh
   IF Refresh=%ON THEN
      Refresh=%OFF
   ELSE
      Refresh=%ON
   END IF
   CALL Bildschirm
END SUB

SUB ToggleRange
   SHARED TEXT$(), Range, Umax!()
   LOCATE 21,3
   IF Range=0 THEN
      PRINT USING TEXT$(5); Umax!(1)
      Range=1
   ELSE
      Range=0
      PRINT USING TEXT$(5); Umax!(0)
   END IF
   CALL Bildschirm
END SUB

SUB ToggleFreeze
   SHARED TEXT$(), Gestoppt, Clock???, Speed, PCrunWait???
   IF Gestoppt=%ON THEN
      IF Speed=%PCrun THEN
         LOCATE 29,3
         PRINT USING TEXT$(31)+" ###,###,###          ";(PCrunWait???)
      ELSE
         LOCATE 29,3                                      'Taktfrequenz ausgeben
         PRINT USING TEXT$(8)+" ###,###,###";(Clock???/2/EXP10(Speed))
      END IF
      Gestoppt=%OFF
   ELSE
      Gestoppt=%ON
      LOCATE 29,3
      PRINT TEXT$(12)
   END IF
END SUB

SUB ToggleHD
   SHARED HDRecording, Datei$
   IF HDRecording=%ON THEN
      CLOSE #2
      HDRecording=%OFF
   ELSE
      HDRecording=%ON
      OPEN Datei$ FOR BINARY AS #2
   END IF
   CALL Bildschirm
END SUB

SUB Help
   SHARED Helpbeginn, Textlaenge, TEXT$(), Drucker
   SCREEN 0
   IF Drucker=1 then Drucker$="LPT1" else Drucker$="LPT2"
   CLS
   CALL MDEFSTAT(%ON)                    'Maus an
   FOR X = Helpbeginn TO Textlaenge           'Hilfetexte
      PRINT TEXT$(X)                     ' ausgeben
   NEXT
   row=20
   col=6
   CALL diawin ( row,col,6,70,TEXT$(13),%ON )
   CALL diapush (1,3, TEXT$(14)+" "+Drucker$)
   CALL diapush (3,3, TEXT$(15))
   DO
      d=dialog
      l=lastkeyx
      IF l=%ENTER THEN
         IF d=1 THEN
            OPEN Drucker$ FOR OUTPUT AS #1
            FOR X=Helpbeginn TO Textlaenge
               PRINT #1,TEXT$(X)           'Ausdrucken
            NEXT
            CLOSE
         ELSEIF d=2 THEN
            EXIT LOOP
         END IF
      END IF
   LOOP
   CALL diaclose
   CLS
END SUB


SUB SaveSetup SHARED
   OPEN INI$ FOR OUTPUT AS #1            'Einstellungen in SCOPE.INI speichern
   PRINT #1, Address                     'Adresse des Wandlers
   PRINT #1, Drucker                     'Nummer des Druckers
   PRINT #1, Range
   PRINT #1, Messhoehe
   PRINT #1, Umax!(0)
   PRINT #1, Umax!(1)
   PRINT #1, Null(0)
   PRINT #1, Null(1)
   PRINT #1, Anzahl?
   PRINT #1, Refresh
   PRINT #1, Datei$
   PRINT #1, Language                    'Nummern fr die Sprachen
   PRINT #1, Speed
   PRINT #1, Clock???
   PRINT #1, PCrunWait???
   PRINT #1, NoViewAnzahl??
   CLOSE                                 'Datei schliesen
END SUB

SUB ReadSetup SHARED
   OPEN INI$ FOR INPUT AS #1             'Einstellungen aus SCOPE.INI lesen
   INPUT #1, Address
   INPUT #1, Drucker
   INPUT #1, Range
   INPUT #1, Messhoehe
   INPUT #1, Umax!(0)
   INPUT #1, Umax!(1)
   INPUT #1, Null(0)
   INPUT #1, Null(1)
   INPUT #1, Anzahl?
   INPUT #1, Refresh
   INPUT #1, Datei$
   INPUT #1, Language                    'Nummern fr die Sprachen
   INPUT #1, Speed
   INPUT #1, Clock???
   INPUT #1, PCrunWait???
   INPUT #1, NoViewAnzahl??
   CLOSE
   OPEN DAT$ FOR INPUT AS #1             'Texte aus SCOPE.DAT lesen
   Z=(Language-1)*Textlaenge
   DO While 0 < Z                        'Vorige Texte berspringen
      DECR Z
      LINE INPUT #1, X$
   LOOP
   FOR X = 0 to Textlaenge-1             'Der Sprache entsprechende Texte laden
      LINE INPUT #1, TEXT$(X)
   NEXT
   CLOSE                                 'Datei schliesen
END SUB

SUB Setup SHARED
   SCREEN 0                              'Textmodus
   CALL MDEFSTAT(%ON)                    'Maus an
   row=1                                 'Position des Fensters
   col=6
   Address$="&H"+HEX$(Address)           'Umwandeln in Strings
   NeuDatei$=Datei$
   PCrunWait$=STR$(PCrunWait???)
   Memmax$=STR$(Memmax)
   Umax$(0)=STR$(Umax!(0)/2)             'Hlfte wegen +/- des Mebereiches
   Umax$(1)=STR$(Umax!(1)/2)
   Anzahl$=STR$(Anzahl?)
   SpeedSelection$=STR$(Clock???/2,9)+":"+STR$(Clock???/200,9)+":"+STR$(Clock???/20000,9)+": PC"
   INCR Speed
   CALL diawin   (row,col,25,70,TEXT$(16),%ON )
   CALL diainp   ( 2, 3,TEXT$(17), 2,27, 6,Address$)
   CALL diaradio ( 4, 3, TEXT$(8), 4,27, SpeedSelection$,Speed)
   CALL diainp   ( 7,42,TEXT$(31), 7,58, 10,PCrunWait$)
   CALL diainp   ( 9, 3,TEXT$(19), 9,27, 6,Umax$(0))
   CALL diainp   (10, 3,TEXT$(20),10,27, 6,Umax$(1))
   CALL diainp   (12, 3,TEXT$(21),12,27, 3,Anzahl$)
   CALL diaradio (14, 3,TEXT$(22),14,27,TEXT$(23),Language)
   CALL diaradio (17, 3,TEXT$(24),17,27,TEXT$(25),Drucker)
   CALL diainp   (20, 3,TEXT$(26),20,27,11,NeuDatei$)
   CALL diapush  (22, 3,TEXT$(27))       'Mit Speichern verlassen
   CALL diapush  (22,33,TEXT$(28))       'Nur verlassen
   DO
      d=dialog
      l=lastkeyx
      IF l=%ENTER THEN
         Address=VAL(Address$)           'Zurck wandeln, ohne Prfung ...
         Umax!(0)=VAL(Umax$(0))
         Umax!(1)=VAL(Umax$(1))
         IF Umax!(0)>0 THEN Umax!(0)=Umax!(0)*2
         IF Umax!(1)>0 THEN Umax!(1)=Umax!(1)*2
         NeuAnzahl!=VAL(Anzahl$)
         IF NeuAnzahl!>0 and NeuAnzahl!<52 THEN Anzahl?=CINT(NeuAnzahl!)
         PCrunWait???=VAL(PCrunWait$)
         Datei$=NeuDatei$
         HDPosition???=0
         IF d=10 THEN
            DECR Speed
            CALL SaveSetup
            EXIT LOOP
         ELSEIF d=11 THEN
            DECR Speed
            EXIT LOOP
         END IF
      END IF
   LOOP
   CALL diaclose
   CALL ReadSetup
END SUB

sub Info
   print "Free for non-commercial use only. ALL RIGHTS RESERVED."
   print "Programmed by: Martin Clausen, Germany"
   print "               email: e.builder@rotgradpsi.de"
   print "Usage:
   print "minids [/h] [/setup]"
   print "/h       this text"
   print "/setup   force program to enter setup first"
   end
end sub

sub startsetup shared
  DO
   CLS
   row=6
   col=6
   CALL diawin ( row,col,11,70,TEXT$(0),%ON )
   CALL diapush (2,3, TEXT$(1))
   CALL diapush (4,3, TEXT$(2))
   CALL diapush (6,3, TEXT$(3))
   CALL diapush (8,3, TEXT$(4))
   d=dialog
   l=lastkeyx
   IF l=%ENTER THEN
      IF d=1 THEN
         EXIT LOOP
      ELSEIF d=2 THEN
         CALL diaclose
         CALL Help
      ELSEIF d=3 THEN
         CALL diaclose
         CALL Setup
      elseif d=4 THEN
         CALL diaclose
         CALL Ende
      END IF
   END IF
  LOOP
  CALL diaclose
end sub

Fehler:
   if err=53 then
      print "File not found"
   elseif err=58 then
      print "File allready exists"
   elseif err=61 then
      print "Disk full"
   elseif err=64 then
      print "Bad file name"
   elseif err=71 then
      print "Disk not ready"
   elseif err=73 then
      print "Disk media error"
   elseif err=75 then
      print "Path File Access Error"
   elseif err=76 then
      print "Path not found"
   else
      print "Error: ";err
   end if
   end
