{*************************************************
DSOA MK3 Interface Routines
for use with Rev 3.1 hardware
Started       : 17/11/96
Last Edited   : 22/6/97
Copyright (c)1997 David L. Jones TRONNORT Technology
**************************************************}
unit DSOA3_I2;

{*************************************************}
interface
var PortAddr:word;
procedure DSOA_Address(b:boolean);
procedure DSOA_Reset;
procedure DSOA_Trigger;
function DSOA_ReadByteA:byte;
function DSOA_ReadByteB:byte;
function DSOA_EOS:Boolean;
procedure DSOA_TriggerPol(d:Boolean);
procedure DSOA_Clock(n:byte);
procedure DSOA_ChSelect(d:boolean);
procedure DSOA_ChangeVoltageA(Num:Byte);
procedure DSOA_ChangeVoltageB(Num:Byte);

{*************************************************}
implementation
var RegA, RegB : byte;       {latch data}

{*************************************************}
procedure WriteLatchA;
begin
  	port[PortAddr]:=RegA;      {output latch data}
  	port[PortAddr+2]:=3;       {both latch clocks LOW}
  	port[PortAddr+2]:=1;       {Latch Register A}
  	port[PortAddr+2]:=3;       {both latch clocks LOW}
end;

{*************************************************}
procedure WriteLatchB;
begin
  	port[PortAddr]:=RegB;      {output latch data}
  	port[PortAddr+2]:=3;       {both latch clocks LOW}
  	port[PortAddr+2]:=2;       {Latch Register B}
  	port[PortAddr+2]:=3;       {both latch clocks LOW}
end;

{*************************************************}
procedure DSOA_Address(b:boolean);
begin
	if b then RegB:=(RegB OR 2)          {INCA line HIGH}
  	else RegB:=(RegB AND $fd);        {INCA line LOW}
  	WriteLatchB;
end;

{*************************************************}
procedure DSOA_Reset;
begin
  	RegA:=RegA AND $bf;        {RESET line LOW}
  	WriteLatchA;
  	RegA:=RegA OR 64;          {RESET line HIGH}
  	WriteLatchA;
end;

{*************************************************}
procedure DSOA_Trigger;
begin
  	RegA:=RegA AND $7f;        {START line LOW}
  	WriteLatchA;
  	RegA:=RegA OR 128;          {START line HIGH}
  	WriteLatchA;
end;

{*************************************************}
procedure DSOA_TriggerPol(d:Boolean);
begin
  	if d then RegB:=RegB OR 1   {TRIGPOL line HIGH}
		else RegB:=RegB AND $fe; {TRIGPOL line LOW}
	WriteLatchB;
end;

{*************************************************}
procedure DSOA_ChSelect(d:boolean);
begin
	if d then RegB:=(RegB OR 4)   {CHSEL line HIGH}
   	else RegB:=(RegB AND $fb); {CHEL line LOW}
	WriteLatchB;
end;

{*************************************************}
procedure DSOA_DataSelect(d:boolean);
begin
  	if d then RegB:=(RegB OR 8)   {CHSEL line HIGH}
     	else RegB:=(RegB AND $f7); {CHSEL line LOW}
  	WriteLatchB;
end;

{*************************************************}
function DSOA_DecodeByte:byte;
var d,v:byte;
begin
  	v:=0;                            {Final Value}

  	DSOA_DataSelect(TRUE);
	d:=PORT[PortAddr+1];												{GET PORT DATA}
	d:=d XOR $80;														{INVERT BIT 7}
  	IF (d AND 16)<>0  THEN inc(v,64);
  	IF (d AND 32)<>0  THEN inc(v,32);
  	IF (d AND 64)<>0  THEN inc(v,8);
  	IF (d AND 128)<>0 THEN inc(v,1);

  	DSOA_DataSelect(FALSE);
	d:=PORT[PortAddr+1];												{GET PORT DATA}
	d:=d XOR $80;														{INVERT BIT 7}
  	IF (d AND 16)<>0  THEN inc(v,16);
  	IF (d AND 32)<>0  THEN inc(v,128);
  	IF (d AND 64)<>0  THEN inc(v,4);
  	IF (d AND 128)<>0 THEN inc(v,2);

  	DSOA_DecodeByte:=v;
end;

{**************************************************************************}
function DSOA_ReadByteB:byte;
var d:byte;
begin
  DSOA_ChSelect(TRUE);          {Channel 2 select}
  DSOA_ReadByteB:=DSOA_DecodeByte;
end;

{**************************************************************************}
function DSOA_ReadByteA:byte;
begin
  DSOA_ChSelect(FALSE);          {Channel 1 select}
  DSOA_ReadByteA:=DSOA_DecodeByte;
end;

{************************************************}
function DSOA_EOS:Boolean;
var t:boolean;
  d:byte;
begin
  d:=port[PortAddr+1];
  if (d AND 8)>0 then t:=TRUE else t:=FALSE;
  DSOA_EOS:=t;
end;

{************************************************}
procedure DSOA_CS0(d:boolean);
begin
  if d then RegB:=RegB OR 32       {CS0 HIGH}
     else RegB:=RegB AND $df;      {CS0 LOW}
  WriteLatchB;
end;

{************************************************}
procedure DSOA_CS1(d:boolean);
begin
  if d then RegB:=RegB OR 64       {CS1 HIGH}
     else RegB:=RegB AND $bf;      {CS1 LOW}
  WriteLatchB;
end;

{************************************************}
procedure DSOA_CS2(d:boolean);
begin
  if d then RegB:=RegB OR 128      {CS2 HIGH}
     else RegB:=RegB AND $7f;        {CS2 LOW}
  WriteLatchB;
end;

{************************************************}
procedure DSOA_Clock(n:byte);
var d:byte;
  c1,c2,c3:boolean;
begin
  if (n<0) OR (n>7) then exit;
  case n of
     0:begin c3:=false; c2:=false; c1:=false; end;
     1:begin c3:=false; c2:=false; c1:=true; end;
     2:begin c3:=false; c2:=true; c1:=false; end;
     3:begin c3:=false; c2:=true; c1:=true; end;
     4:begin c3:=true; c2:=false; c1:=false; end;
     5:begin c3:=true; c2:=false; c1:=true; end;
     6:begin c3:=true; c2:=true; c1:=false; end;
     7:begin c3:=true; c2:=true; c1:=true; end;
  end;
  DSOA_CS0(c1);
  DSOA_CS1(c2);
  DSOA_CS2(c3);
end;

{**********************************************}
procedure DSOA_ChangeVoltageB(Num:Byte);
var c1,c2,c3:boolean;
begin
  case Num of
     0:begin c1:=FALSE; c2:=FALSE; c3:=TRUE;  end;
     1:begin c1:=FALSE; c2:=FALSE; c3:=FALSE; end;
     2:begin c1:=FALSE; c2:=TRUE;  c3:=FALSE; end;
     3:begin c1:=TRUE;  c2:=FALSE; c3:=TRUE;  end;
     4:begin c1:=TRUE;  c2:=FALSE; c3:=FALSE; end;
     5:begin c1:=TRUE;  c2:=TRUE;  c3:=FALSE; end;
  end;
  if c3 then RegA:=RegA OR 1 else RegA:=RegA AND $fe;
  if c2 then RegA:=RegA OR 2 else RegA:=RegA AND $fd;
  if c1 then RegA:=RegA OR 4 else RegA:=RegA AND $fb;
  WriteLatchA;
end;

{**********************************************}
procedure DSOA_ChangeVoltageA(Num:Byte);
var c1,c2,c3:boolean;
begin
  case Num of
     0:begin c1:=FALSE; c2:=FALSE; c3:=TRUE; end;
     1:begin c1:=FALSE; c2:=FALSE; c3:=FALSE; end;
     2:begin c1:=FALSE; c2:=TRUE; c3:=FALSE; end;
     3:begin c1:=TRUE; c2:=FALSE; c3:=TRUE; end;
     4:begin c1:=TRUE; c2:=FALSE; c3:=FALSE; end;
     5:begin c1:=TRUE; c2:=TRUE; c3:=FALSE; end;
  end;
  if c3 then RegA:=RegA OR 8 else RegA:=RegA AND $f7;
  if c2 then RegA:=RegA OR 16 else RegA:=RegA AND $ef;
  if c1 then RegA:=RegA OR 32 else RegA:=RegA AND $df;
  WriteLatchA;
end;
end.
