{ 	DSOA Mk3 Simple DOS Control Program
	Version 1.0
   Written in Borland Pascal v7
   Started : 27/8/97
   Last Edit : 22/10/97
   For use with Rev3.1 DSOA Mk3 Hardware
   Copyright (c)1997 David L. Jones - TRONNORT Technology
   This source code is to be used for personal use only.
	None of this code	is to distributed to any third party in whole or in
	part by any means.
}
program DSOA_MK3;
uses Crt, Graph, DSOA3_I2, BGIdriv;
const
	MaxRAM=1024;
   TBname:array[1..18] of string[5]=('50ms','20ms','10ms','5ms','2ms','1ms',
		'500us','200us','100us','50us','20us','10us','5us','2us','1us','500ns',
		'200ns','100ns');
	VoltName:array[0..5] of string[5]=('5V','2V','1V','500mV','200mV','100mV');
var
   Data:array [1..2,1..MaxRAM] of byte;
   TimeBase, CH1volt, CH2volt:integer;
   TrigMode:integer;					  				{0=Auto, 1=Normal, 2=Single shot}
   TrigPol, Armed:boolean;

{************************************************************************}
procedure Initialise_Graphics;
var
	grDriver: Integer;
	grMode: Integer;
	ErrCode: Integer;
begin
	{******* Take out this line if BGIdriv unit is unavailable}
	RegisterBGIdriver(@EGAVGADriverProc);
	{****************************************}
	grDriver := Detect;
	InitGraph(grDriver, grMode,' ');
	SetGraphMode(EGAhi);
	ErrCode := GraphResult;
	if ErrCode<>grOk then begin
   	Clrscr;
		Writeln('Graphics error:', GraphErrorMsg(ErrCode));
      halt;
   end;
end;

{*************************************************************************}
procedure DrawMainScreen;
begin
   SetFillStyle(SolidFill,Black);
	SetColor(white);
	rectangle(0,0,601,257);								 {draw screen border}
   SetFillStyle(SolidFill,Green);
   bar(485,260,535,270);
   SetFillStyle(SolidFill,Red);
   bar(545,260,595,270);
   SetColor(White);
   outtextxy(498,261,'CH1');
   outtextxy(558,261,'CH2');
   SetFillStyle(SolidFill,Black);
end;

{*************************************************************************}
procedure DrawWaveform;
var x,xx,y,spd,start,xjump,endloc:real;
	c,xg,yg:word;
begin
   bar(1,1,600,256);										{clear waveform area}
   SetColor(lightgray);
   xg:=60;
   for c:=1 to 9 do line(xg*c, 1, xg*c, 256);	{draw graticule (x)}
   yg:=32;
   for c:=1 to 7 do line(1, yg*c, 600, yg*c);	{draw graticule (y)}

   case TimeBase of							{# of Samples Per Division}
   	18:spd:=2;
      17:spd:=4;
      16:spd:=10;
      3,15:spd:=20;
      2,5,8,11,14:spd:=40;
      1,4,6,7,9,10,12,13:spd:=100;
   end;

   SetColor(lightgreen);
   for c:=1 to 2 do begin                 {draw waveforms}
   	if c=2 then SetColor(lightred);
   	start:=512-((spd*10) / 2);	  			{starting location in buffer}
	   endloc:=512+((spd*10) / 2);			{ending location in buffer}
   	x:=start;                   			{data pointer}
	   xjump:=600 / (spd*10);           	{how many pixels to jump each sample}
   	xx:=1;										{x-axis pixel pointer}
	   MoveTo(1,256-Data[c,round(start)]);	{plot first point}
   	while x<endloc do begin
   		LineTo(round(xx), 256-Data[c,round(x)]);
	      xx:=xx+xjump;							{increment x-axis pixel pointer}
   	   x:=x+1;        					 	{increment data pointer}
	   end;
   end;
end;

{***********************************************************************}
procedure DisplayStatMessage(s:string);
begin
	bar(550,340,640,350);
	setcolor(green);
	outtextxy(550,340, s);
end;

{*************************************************************************}
procedure RetrieveData;
var c:word;
	ch:char;
begin
	if (TrigMode=2) AND (NOT Armed) then exit;
	DSOA_Address(FALSE);
	DSOA_Reset;
   if TrigMode=0 then begin
   	case TimeBase of
			1,2,3:delay(300);
         else delay(50);
   	end;
		DSOA_Trigger;
   end;
	DisplayStatMessage('Armed...');

   repeat
	until DSOA_EOS or keypressed;

   Armed:=FALSE;
   if keypressed then exit;
	DisplayStatMessage('Retrieving...');

	for c:=1 to MaxRAM do begin
        DSOA_Address(TRUE);        				{ouput data}
        Data[1,c]:=DSOA_ReadByteA; 			 	{CH1 data}
        Data[2,c]:=DSOA_ReadByteB; 				{CH2 data}
        DSOA_Address(FALSE);  					{TRI-STATE data}
	end;

	DSOA_Address(FALSE);
	DSOA_Reset;
end;

{***********************************************************************}
procedure UpdateTimebase;
var num:byte;
begin
	case Timebase of						{work out the sample frequency}
		1,2,3:num:=7;
		4,5:num:=0;
		6:num:=3;
		7,8:num:=6;
		9:num:=2;
		10,11:num:=5;
		12:num:=1;
		13,14,15,16,17,18:num:=4;
  	end;
   DSOA_Clock(num);						{select the clock on the DSOA}
end;

{***********************************************************************}
procedure UpdateVoltageRange;
begin
	DSOA_ChangeVoltageA(CH1volt);
	DSOA_ChangeVoltageB(CH2volt);
end;

{***********************************************************************}
procedure DisplayMenu;
begin
	setcolor(blue);
   outtextxy(180,340,'DSOA Mk3 Control Program - Version 1.0');
	setcolor(red);
	outtextxy(10,270, '+/-');
	outtextxy(10,280, '1/2');
	outtextxy(10,290, '3/4');
	outtextxy(10,300, 'T');
	outtextxy(10,310, 'M');
   outtextxy(10,320, 'P');
   outtextxy(10,330, 'SPC');
	outtextxy(10,340, 'ESC');
   setcolor(white);
	outtextxy(50,270, 'Timebase Up/Down');
	outtextxy(50,280, 'CH1 Range Select');
	outtextxy(50,290, 'CH2 Range Select');
	outtextxy(50,300, 'Trigger Polarity');
	outtextxy(50,310, 'Trigger Mode');
	outtextxy(50,320, 'Port');
   outtextxy(50,330, 'Arm trigger');
	outtextxy(50,340, 'Quit');
end;

{***********************************************************************}
procedure DisplayInfo;
var s:string;
begin
	bar(300,270,400,339);
	setcolor(green);
	outtextxy(300,270, TBname[TimeBase]+'/div');
	outtextxy(300,280, VoltName[CH1volt]+'/div');
	outtextxy(300,290, VoltName[CH2volt]+'/div');
   if NOT TrigPol then s:='Positive' else s:='Negative';
	outtextxy(300,300, s);
   case TrigMode of
		0:s:='Auto';
		1:s:='Normal';
      2:s:='Single Shot';
      else s:='Error';
   end;
	outtextxy(300,310, s);
   Case PortAddr of
   	$378:s:='378h';
      $278:s:='278h';
      $3bc:s:='3BCh';
      else s:='Error';
   end;
   outtextxy(300,320,s);
end;

{***********************************************************************}
function CheckKeyPress:boolean;
var ch:char;
	b:boolean;
begin
   b:=False;
	if keypressed then ch:=readkey;
   case ch of
   	#27:b:=True;
      ' ':Armed:=TRUE;
      '+','=': if TimeBase<18 then begin
					inc(TimeBase);
         		UpdateTimebase;
            	DisplayInfo;
      			end;
      '-','_': if TimeBase>1 then begin
					dec(TimeBase);
         		UpdateTimebase;
            	DisplayInfo;
         		end;
		'1': if CH1volt>0 then begin
					dec(CH1volt);
         		UpdateVoltageRange;
            	DisplayInfo;
         		end;
      '2': if CH1volt<5 then begin
					inc(CH1volt);
         		UpdateVoltageRange;
            	DisplayInfo;
	        		end;
		'3': if CH2volt>0 then begin
					dec(CH2volt);
         		UpdateVoltageRange;
         		DisplayInfo;
         		end;
      '4': if CH2volt<5 then begin
					inc(CH2volt);
         		UpdateVoltageRange;
         		DisplayInfo;
      			end;
      't','T':begin
					TrigPol:=NOT TrigPol;
         		DSOA_TriggerPol(TrigPol);
            	DisplayInfo;
      			end;
      'm','M': begin
					if (TrigMode<2) then inc(TrigMode) else TrigMode:=0;
            	DisplayInfo;
            	end;
      'p','P': begin
					case PortAddr of
      			$378:PortAddr:=$278;
            	$278:PortAddr:=$3bc;
            	$3bc:PortAddr:=$378;
            	end;
      			DisplayInfo;
      		end;
   end;
   CheckKeyPress:=b;
end;

{*************************************************************************}
procedure MainLoop;
var quit:boolean;
begin
	DisplayMenu;
   DisplayInfo;
	DrawMainScreen;
	Repeat
		DrawMainScreen;
		DrawWaveform;
		RetrieveData;
      DisplayStatMessage('Stopped.');
		quit:=CheckKeyPress;
   Until quit;
end;

{************************************************************************}
procedure InitialiseVariables;
begin
	PortAddr:=$378;
   TimeBase:=18;
   TrigPol:=FALSE;
   TrigMode:=0;
   CH1volt:=0;
   CH2volt:=0;
   Armed:=False;
   UpdateTimebase;
   UpdateVoltageRange;
   DSOA_TriggerPol(TrigPol);
   SetFillStyle(SolidFill,Black);
	SetTextStyle(DefaultFont, HorizDir, 1);
end;

{************************************************************************}
Procedure Load_Defaults;
var F:file of integer;
	t:integer;
begin
   Assign(F, 'DSOA_MK3.CFG');
   Reset(F);
   if IOresult<>0 then exit;
	Read(F,t);
   case t of
   	$378,$278,$3bc:PortAddr:=t;
	end;
	Close(F);
end;

{************************************************************************}
Procedure Save_Defaults;
var F:file of integer;
	t:integer;
begin
   Assign(F, 'DSOA_MK3.CFG');
   ReWrite(F);
   if IOresult<>0 then exit;
   t:=PortAddr;
	Write(F,t);
	Close(F);
end;

{************************************************************************}
var OriginalMode:integer;
begin
	OriginalMode:=LastMode;							{save current video mode}
	Initialise_Graphics;
   InitialiseVariables;
   Load_Defaults;
	MainLoop;
   Save_Defaults;
	TextMode(OriginalMode);						  	{restore video mode}
   NormVideo;											{restore attributes}
   writeln('DSOA MK3 Control Program - Ver 1.0 22/10/97');
   writeln('Copyright (c) 1997/98 David L. Jones - TRONNORT Technology');
   writeln('12 Copeland Road');
	writeln('Lethbridge Park NSW 2770');
   writeln('EMAIL : dljones@ozemail.com.au');
   writeln('WWW   : http://www.ozemail.com.au/~dljones');
end.