#include    <p18f4520.h>
#include    <i2c.h>
#include	<timers.h>
#include	<delays.h>
#include	<stdlib.h>
#include	<string.h>
#include    <stdio.h>
#include    <myClock.h>

unsigned char TimeBuffer[8] = {0,0,0,0,0,0,0,0};
int nMinute, nHour, nSec;

int Ora(void){ return ( nHour ); }
int Perc(void){	return ( nMinute ); }
int Masodperc(void){ return ( nSec ); }

void cDelay500ms( void )
{
	Delay1KTCYx(2000); //Delay of 0.5s
	return;
}

void cDelay5ms( void )
{
	Delay1KTCYx(20); //Delay of 5ms
	return;
}

char toBCD(char bin_val)
{
	char temp;
	char retval;

	temp = bin_val;
	retval = 0;

	while(1)
	{
		if(temp >= 10)
		{
			temp -= 10;
			retval += 0x10; 
		}
		else            
		{
			retval += temp; 
			break;
		}
	}
	return(retval);
}

void Ora_Inditas(void)
{ 
    /* Portok belltsa*/
	ADCON1 = 0b00001110; // csak az AN0 bemenet a tobbi kimenet
	LATD   = 0;
	TRISA  = 0; //bemenet
	TRISC  = 0; //bemenet
	TRISD  = 1; //kimenet

	SSPADD = 49; //100000=20000000/(4*(SSPADD+1))
    OpenI2C(MASTER, SLEW_OFF);  //open I2C as master

	PIR1  = 0; // Power On Reset
    PIE1  = 0; // a perifria megszaktsok tiltsa

	nMinute = 0;
	nHour   = 0;
	nSec    = 0;

	IdleI2C();
	StartI2C();	
	while (SSPCON2bits.SEN != 1);
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!

	while ( WriteI2C(WRITE_CNTRL) == -1 ); // rs
		IdleI2C();

	while ( WriteI2C(CNTRL2_ADDRESS) == -1); // Kezdcm tkldse
		IdleI2C();	

	while ( WriteI2C(CLOCK_MODE) == -1); // Control2 regiszter rs, 24 rs zemmd
		IdleI2C();	

	StopI2C();
	while (SSPCON2bits.PEN != 1);
		IdleI2C();

}

void Ora_Iras(void)
{
	char i;
		IdleI2C();
	StartI2C();	
	while (SSPCON2bits.SEN != 1);
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!

	while ( WriteI2C(WRITE_CNTRL) == -1 ); // rs
		IdleI2C();

	while ( WriteI2C(SECONDS_REG) == -1 );
		IdleI2C();


	for(i=0;i<7;i++)
	{
		while ( WriteI2C(TimeBuffer[i]) == -1 );
		IdleI2C();
	}

	StopI2C();
	while (SSPCON2bits.PEN != 1);
		IdleI2C();
}

void Ora_Beallitas(unsigned int hour, unsigned int min, unsigned int sec)
{	
	char i;

	TimeBuffer[SECONDS_REG]     = sec;  // seconds
	TimeBuffer[MINUTES_REG]     = min;  // minutes
	TimeBuffer[HOURS_REG]       = hour; // hour
	TimeBuffer[DAY_OF_WEEK_REG] = 0;    // not used
	TimeBuffer[DATE_REG]        = 02;   // date   // 2007.03.02.
	TimeBuffer[MONTH_REG]       = 03;   // month
	TimeBuffer[YEAR_REG]        = 07;   // year

    // toBCD
	for(i=0; i<7; i++)
	{
		TimeBuffer[i] = toBCD(TimeBuffer[i]);
	}

	TimeBuffer[SECONDS_REG] &= 0x7f;
	TimeBuffer[HOURS_REG]   &= 0x3f;

	Ora_Iras(); // az ra belltsa a setTime alapjn
} 

void Ora_Olvasas(void)
{
	char tmp[5];
	int i;
	
	IdleI2C();
	StartI2C();	
	while (SSPCON2bits.SEN != 1);
		IdleI2C(); // Akkor tr vissza, amikor az I2C jra zemksz lesz!
	while ( WriteI2C(WRITE_CNTRL) == -1 ); // rs
		IdleI2C();
	while ( WriteI2C(SECONDS_REG) == -1 ); // Msodperc cmnek tkldse
		IdleI2C();
	RestartI2C();
		IdleI2C();
		cDelay500ms();
	while ( WriteI2C(READ_CNTRL) == -1 ); // Olvass
		IdleI2C();
	while ( getsI2C(TimeBuffer, 7) == -1);
		IdleI2C();	
		cDelay500ms();
	StopI2C();
	while (SSPCON2bits.PEN != 1);
		IdleI2C();	

	cDelay5ms();
		sprintf(tmp, "%02X",TimeBuffer[0]);
		if ((tmp[0] != 'F') && (tmp[1] != 'F') && (tmp[2] != 'F'))
			nSec  = atoi( tmp );
	cDelay5ms();
		sprintf(tmp, "%02X",TimeBuffer[1]);
		if ((tmp[0] != 'F') && (tmp[1] != 'F') && (tmp[2] != 'F'))
			nMinute  = atoi ( tmp );
	cDelay5ms();
		sprintf(tmp, "%02X",TimeBuffer[2]);
		if ((tmp[0] != 'F') && (tmp[1] != 'F') && (tmp[2] != 'F'))
			nHour = atoi ( tmp );
	cDelay5ms();
}
