#ifndef __MYCLOCK_H
#define __MYCLOCK_H

#include <p18f4520.h>
#include <i2c.h>
#include <timers.h>
#include <delays.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>

#define SECONDS_REG 0
#define MINUTES_REG 1
#define HOURS_REG 2
#define DAY_OF_WEEK_REG 3
#define DATE_REG 4
#define MONTH_REG 5
#define YEAR_REG 6
#define CONTROL_REG 7 // Time Trimming Register

#define WRITE_CNTRL 0b01100100
#define READ_CNTRL 0b01100101
#define CNTRL2_ADDRESS 0xF0
#define CLOCK_MODE 0x20 // 24h

void cDelay500ms( void );
void cDelay5ms( void );
char toBCD(char bin_val);

void Ora_Inditas(void);
void Ora_Iras(void);
void Ora_Beallitas(unsigned int hour, unsigned int min, unsigned int sec);
void Ora_Olvasas(void);

int Ora(void);
int Perc(void);
int Masodperc(void);

#endif
