#include<16F877.H>
#device adc=10;					//Set ADC to 10 bit
#fuses HS,NOWDT,NOPROTECT,NOBROWNOUT,NOPUT  //Configuration Fuses
#use delay(clock=20000000)				 	//20Mhz Clock for wait functions
#use rs232(baud=9600,xmit=PIN_c6,rcv=PIN_C7,PARITY=N,BITS=8)//set up RS-232
#org 0x1F00,0x1FFF{}

#define TURRET_PIN pin_c0

int flag = 0;
signed long angle,delay;

#INT_TIMER1                        
void timer1_isr() 
{
	
	if(angle == -45)
	 	delay = 562;	//900us = 562 ticks @ 1.6us / tick
	else if(angle == 45)
		delay = 1312;	//2100us = 1312 ticks @ 1.6us / tick
	else
		delay = 937;	//1500us = 937 ticks @ 1.6us / tick
	
	//flag is used to alternate between high and low
	if(flag == 0){
		output_high(TURRET_PIN);	                 
		set_timer1(65536 - delay); //reset timer for next fallingedge
		flag = 1;
	}
	else{
		output_low(TURRET_PIN);
		//to get 20ms period, go low for 20ms - time pulse was high
		set_timer1(65536 - (12500 - delay)); //12500 * 1.6us = 20ms
		flag = 0;
	}
}


void main(){
	//setup turrent timer (Timer_1)
	set_timer1(0);
	setup_timer_1( T1_INTERNAL | T1_DIV_BY_8);//1.6us / tick
   	enable_interrupts(INT_TIMER1);
   	enable_interrupts(GLOBAL);

	while(true)
	{		
			angle = 0;	
			delay_ms(2000);
			angle = -45;
			delay_ms(2000);
			angle = 45;
			delay_ms(2000);
			
	}
}

