#include<16F877.H>
#device adc=10;					//Set ADC to 10 bit
#fuses HS,NOWDT,NOPROTECT,NOBROWNOUT,NOPUT  //Configuration Fuses
#use delay(clock=20000000)				 	//20Mhz Clock for wait functions
#use rs232(baud=9600,xmit=PIN_c6,rcv=PIN_C7,PARITY=N,BITS=8)//set up RS-232
#org 0x1F00,0x1FFF{}

#define TURRET_PIN pin_c0
#define INTS_PER_SECOND 76     // (20000000/(4*256*256))

int flag;
signed int angle,delay;

#int_rtcc
void clock_isr() 
{

	if(angle == -45)
		delay = 18;
	else if(angle == 45)
		delay = 38;
	else
		delay = 30;

	if(flag == 0)
	{
		output_high(TURRET_PIN);	                 
		flag++;
		set_timer0(256-delay);
	}
	else if(flag == 1)
	{
		output_low(TURRET_PIN);
		flag = 2;
		set_timer0(256 - 195 - delay); 
	}
	else
	{
		output_low(TURRET_PIN);
		flag = 0;
		set_timer0(256 - 195 - delay); 
	}

}


void main(){
	//TurretRotate(0);
	
	set_timer0(0);
	setup_counters( RTCC_INTERNAL, RTCC_DIV_256 | RTCC_8_BIT);
   	enable_interrupts(INT_RTCC);
   	enable_interrupts(GLOBAL);

	while(true)
	{		
			angle = 0;	
			delay_ms(1000);
			angle = -45;
			delay_ms(1000);
			angle = 45;
			delay_ms(1000);

	}
}