  
;************************************* TVIRNYTHAT FNYERSZABLYZS LMPAKAPCSOL ******************************

	LIST P=18F2320, F=INHX32	
	#include <P18F2320.INC>	
	ERRORLEVEL -230

	__CONFIG	_CONFIG1H,	B'00001000'		;BELS OSZCILLTOR KIVLASZTVA,FAIL-SAFE CLOCK MONITOR TILTVA,IESO TILTVA
	__CONFIG	_CONFIG2L,	B'00001110'		;BOR S PWRT ENGEDLYEZVE
 	__CONFIG	_CONFIG2H,	B'00000000'		;WDT TILTVA
 	__CONFIG	_CONFIG3H,	B'00000000'		;CCP2 RB3 LBON,A/D TILTVA,MCLR TILTVA
 	__CONFIG	_CONFIG4L,	B'10000001'		;STVR ENGEDLYEZVE,LVP TILTVA,KLS DEBUGGER TILTVA,                                                                               
 	__CONFIG	_CONFIG5L,	B'00001111'		;CODE PROTECT TILTVA
 	__CONFIG	_CONFIG5H,	B'11000000'		;CPB TILTVA,CPD TILTVA
 	__CONFIG	_CONFIG6L,	B'00001111'		;WRITE PROTECT TILTVA
 	__CONFIG	_CONFIG6H,	B'11100000'		;EEPROM WRITE,BOOT WRITE,CONF REG WRITE PROTECT TILTVA
 	__CONFIG	_CONFIG7L,  B'00001111'		;TABLE READ PROTECTION TILTVA
 	__CONFIG	_CONFIG7H,	B'01000000'		;BOOT READ PROTECT TILTVA
                                         
;***ID Location Define

    __IDLOCS _IDLOC0, 'K'
    __IDLOCS _IDLOC1, 'R'
    __IDLOCS _IDLOC2, 'I'
    __IDLOCS _IDLOC3, 'S'
    __IDLOCS _IDLOC4, 'S'

;............................................ VLTOZ DEKLARLS ...................................................
    	
    CBLOCK	0X0020
	FLAG0						;JELZBITEK
	FLAG1						;JELZBITEK
	DEL3:2						;GOMBOK NYOMVATARTSNAK IDEJE RESETELSHEZ
	DEL0:2						;LPTETS SEBESSGE
	DEL0TEMP					;DEL0 RTKT TROLJA A MVELET UTNI VISSZALLTSHOZ				
	LED:2						;LEDSOR RTKT TROLJA
	OSZT						;LPSEK SZMA EGY GOMBNYOMSNL
	TIME						;TIMER0 KSLELTETS TRIAKGYJTSHOZ
	TIMETEMP					;TIMER0 RTKT TROLJA A MVELET UTNI VISSZALLTSHOZ
	IRG							;NYOMVATARTS IDEJE
	IRGF						;IRG RTKT TROLJA A MVELET UTNI VISSZALLTSHOZ
	DEL1:3						;KSZENLTI JELZFNY KT BEKAPCSOLS KZTT ELTELT ID
	PWMDEL						;PWM SEBESSGE
	KITOLTES					;PWM KITLTSE
	PWMV						;JELZFNY FELVILLANSOK SZMA
    DELTEMP						;JELZFNY SEBESSGE
	DEL2:2						;BETANTSNL VRJA AZ IR JEFEISMERS VGT
	JELTMP						;IR JEL EGY BJTJA
	JELTMP1:4					;IR JEL
	JEL:4						;AZ ELLERZS IDEJIG TROLT IRJEL 32 BITJE
	JELKIBE:4					;IR JEL MENTSE
	JELMAX:4					;IR JEL MENTSE
	JELMIN:4					;IR JEL MENTSE
	SZAML						;8 BITENKNT LETROLJA A JELET
	TMR1ET						;ENGEDLYEZI A TIMER1 KTSZERI LEFUTST
	XXX							;EZ OKOZZA A HIBT
	ENDC

	#DEFINE	IND		PORTA,7		;IR JELFELISMERS DIAGNOSZTIKA
	#DEFINE	IND1	PORTA,5		;IR JELFELISMERS DIAGNOSZTIKA

	#DEFINE	GOMB0	PORTB,0		;KI-,BEKAPCSOLGOMB
	#DEFINE	GOMB1	PORTB,1		;MAX.GOMB
	#DEFINE	GOMB2	PORTB,2		;MIN.GOMB	
	#DEFINE	PWM		PORTB,3		;JELZFNY
	#DEFINE	IRJEL	PORTB,4		;INFRAJEL
	#DEFINE	GYUJTAS	PORTB,5		;TRIAK GYJTIMPULZUS
	#DEFINE	LED0	LED+1,6		;LEDSOR1 6.BITJE
	#DEFINE	LED1	LED+1,7		;LEDSOR1 7.BITJE
	#DEFINE	LEDSOR	PORTC		;LEDSOR
	#DEFINE	LEDSOR1	PORTB		;LESOR 9. S 10.LEDJE

	#DEFINE	TMRSET	FLAG0,0		;TIMER0 RTKADS ENGEDLYEZSE/TILTSA KOMPARTORMEGSZAKTSNL
	#DEFINE	IMPCLR	FLAG0,1		;GYJTIMPULZUS KIKAPCSOLSNAK ENGEDLYEZSE/TILTSA
	#DEFINE	KIBE	FLAG0,2		;KI-,BEK.GOMB KI/BE FUNKCIVLASZTSA 
	#DEFINE	KIBEET	FLAG0,3		;KI-,BEK.GOMB ENGEDLYEZSE/TILTSA
	#DEFINE	NVM		FLAG0,4		;PWM KITLTS CSKKENSE 0-RA/MEGHATROZOTT RTKRE
	#DEFINE	NCS		FLAG0,5		;PWM KITLTSE NL/CSKKEN
	#DEFINE	FENY	FLAG0,6		;JELZFNY ENGEDLYEZSE/TILTSA
	#DEFINE	KFENY	FLAG0,7		;KSZENLTI JELZFNY ENGEDLYEZSE/TILTSA

	#DEFINE	G1G2ET	FLAG1,0		;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI ENGEDLYEZS/TILTS
	#DEFINE	KIBETAN	FLAG1,1		;KI-,BEK.GOMB BETANTS ENGEDLYEZSE/TILTSA
	#DEFINE	MAXTAN	FLAG1,2		;MAX.GOM BETANTS ENGEDLYEZSE/TILTSA
	#DEFINE	MINTAN	FLAG1,3		;MIN.GOMB BETANTS ENGEDLYEZSE/TILTSA
	#DEFINE	GMBSTS	FLAG1,4		;MINDEN GOMB LENYOMVA/FELENGEDVE
	#DEFINE	JELCOM	FLAG1,5		;IR JEL 12.BITJNEK KOMPLEMENTLSA	

	#DEFINE	ELLET	PORTA,6		;IRJEL FELISMERS KSZ/FOLYAMATBAN

	CONSTANT	DEL3TMP=D'10'	;GOMBOK NYOMVATARTSNAK IDEJE RESETELSHEZ
	CONSTANT	FOK0=D'105'		;MINIMUM FNYER
	CONSTANT	FOK1=D'120'		;FNYER ELS FOKOZATA
	CONSTANT	IMP=D'255'		;GYJTIMPULZUS HOSSZA
	CONSTANT	SEB0=D'100'		;LPTETSI SEBESSG
	CONSTANT	SEB1=D'50'		;KI-,BEKAPCSOLSI SEBESSG
	CONSTANT	NYOM=D'20'		;NYOMVATARTSI KSLELTETS
	CONSTANT	OSZTO=D'13'		;LPSEK SZMA EGY GOMBNYOMSNL
	CONSTANT	LEDTEMP=D'1'	;ELS BEKAPCSOLSKOR A LEDSOR ELS LEDJE VILGT
	CONSTANT	LED0BE=D'210'	;9.LED BEKAPCSOLSA
	CONSTANT	LED1BE=D'223'	;10.LED BEKAPCSOLSA
	CONSTANT	LED0KI=D'225'	;9.LED KIKAPCSOLSA
	CONSTANT	LED1KI=D'238'	;10.LED KIKAPCSOLSA
	CONSTANT	PWMVTEMP=D'2'	;JELZFNY FELVILLANSOK SZMA
	CONSTANT	FENYMIN=D'50'	;JELZFNY MINIMUMA KT VILLANS KZTT
	CONSTANT	DTMP=D'4'		;JELZFNY SEBESSGE
	CONSTANT	DTMP1=D'1'		;JELZFNY SEBESSGE BETANTSNL
	CONSTANT	DEL1TEMP=D'2'	;KSZENLTI JELZFNY KT BEKAPCSOLS KZTT ELTELT ID
	CONSTANT	TMR1KLEF=D'1'	;TIMER1 EGYMSUTNI LEFUTSA KEZDRTK
	CONSTANT	TMR1LEF=D'7'	;TIMER1 EGYMSUTNI LEFUTSA
	CONSTANT	IRFS=D'249'		;TIMER1 IDZTSE AZ IR JELFELISMERSHEZ
	CONSTANT	DEL2TMP=D'250'	;BETANTSNL VRJA AZ IR JELFELISMERS VGT

;................................................ RESET PONT .......................................................   
    
	ORG	0X0000
    BRA		INI				;INICIALIZLSOK

    ORG	0X0008   			;HIGH PRIORITS MEGSZAKTS
	BRA		HPM

    ORG	0X0018				;LOW PRIORITS MEGSZAKTS
  	BRA		LPM

;............................................. INICIALIZLSOK .....................................................

INI

	MOVLW	B'11000110'
	MOVWF	T0CON			;TIMER0 BEKAPCSOLVA,8 BITES MD,ELOSZTS 1:128

	MOVLW	B'00000001'
	MOVWF	T1CON			;TIMER1 BEKAPCSOLVA,8 BITES MD,ELOSZTS 1:1

	MOVLW	B'00000101'
	MOVWF	T2CON			;TIMER2 BEKAPCSOLVA,ELOSZTS 1:16

	MOVLW	B'10000000'		;MEGSZAKTS PRIORITSOK ENGEDLYEZSE
	MOVWF	RCON

	MOVLW	B'01111000'
	MOVWF   INTCON			;GIE TILTSA,PEIE,TIMER0,INT0IE,RBIE ENGEDLYEZVE
	
	MOVLW	B'00110100'
	MOVWF   INTCON2			;RBPU ENGEDLYEZSE,TIMER0 HIGH PRIORITS MEGZAKTS KIVLASZTSA,INT1,INT2 FELFUT L 

	MOVLW	B'11011000'
	MOVWF   INTCON3			;INT1,INT2 ENGEDLYEZSE HIGH PRIORITS

	MOVLW	B'00001100'
	MOVWF	CCP2CON			;PWM BEKAPCSOLSA

	MOVLW	B'00000000'
	MOVWF	IPR1			;TIMER2 LOW PRIORITS MEGSZAKTS KIVLASZTSA

	MOVLW	B'01000000'
	MOVWF	IPR2			;KOMPARTOR HIGH PRIORITS MEGZAKTS KIVLASZTSA

	MOVLW	B'00000011'
	MOVWF	PIE1			;TIMER1,TIMER2 MEGSZAKTS ENGEDLYEZSE

	MOVLW	B'01000000'
	MOVWF	PIE2			;KOMPARTOR MEGSZAKTS ENGEDLYEZSE

	MOVLW	B'00000000'
	MOVWF   PIR1
							;MEGSZAKTSOKAT KEZEL REGISZTEREK ALAPHELYZETBE LLTVA
	MOVLW	B'00000000'
	MOVWF   PIR2			

	MOVLW	B'01111000'
	MOVWF	OSCCON			;BELS OSC 8MHZ,NINCS FREKI HANGOLS   

	MOVLW	B'00001111'		;PORTA DIGIT I/O
	MOVWF	ADCON1

	MOVLW	B'00000001'
	MOVWF	CMCON			;KOMPARTOR BEKAPCSOLSA

    CLRF	PORTA
    CLRF	LATA
    CLRF	PORTB
    CLRF	LATB			;KI S BEMENETI TROLK TRLSE
    CLRF	PORTC
    CLRF	LATC
                               
    MOVLW	B'00001001'         
    MOVWF	TRISA           
    MOVLW	B'00010111'		;I/O PORTOK BELLTSA
    MOVWF	TRISB
    MOVLW	B'00000000'        
    MOVWF	TRISC

;.................................................. RTKADSOK ....................................................

	SETF	XXX				;EZ OKOZZA A HIBT

	CLRF	FLAG0			;JELZBITEK TRLSE
	CLRF	FLAG1
	CLRF	SZAML			;8 BITENKNT LETROLJA A JELET
	CLRF	JELTMP			;IRJEL
	CLRF	LED+1			;9.S 10.LED KIKAPCSOLSA	
	CLRF	CCPR2L			;PWM TRLSE
	CLRF	DEL2			;BETANTSNL VRJA AZ IR JELFELISMERS VGT

	BSF		KIBEET			;KI-,BEK.GOMB ENGEDLYEZSE
	BSF		G1G2ET			;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI ENGEDLYEZS/TILTS
	BSF		KFENY			;KSZENLTI JELZFNY ENGEDLYEZSE

	MOVLW	SEB0
	MOVWF	DEL0TEMP		;LPTETSI SEBESSG

	MOVLW	NYOM
	MOVWF	IRG				;NYOMVATARTSI KSLELTETS
	MOVWF	IRGF

	MOVLW	FOK0
	MOVWF	TIME			;MINIMUM FNYER

	MOVLW	FOK1
	MOVWF	TIMETEMP		;FNYER ELS FOKOZATA

	MOVLW	OSZTO
	MOVWF	OSZT			;LPSEK SZMA EGY GOMBNYOMSNL

	MOVLW	LEDTEMP		
	MOVWF	LED				;ELS BEKAPCSOLSKOR A LEDSOR ELS LEDJE VILGT

	MOVLW	PWMVTEMP
	MOVWF	PWMV			;JELZFNY FELVILLANSOK SZMA

	MOVLW	DTMP
	MOVWF	DELTEMP		
	MOVWF	PWMDEL			;PWM SEBESSGE
	
	MOVLW	DEL1TEMP
	MOVWF	DEL1+2			;KSZENLTI JELZFNY KT BEKAPCSOLS KZTT ELTELT ID

	MOVLW	TMR1KLEF		;TIMER1 EGYMSUTNI LEFUTSA 
	MOVWF	TMR1ET			;TIMER1 ENGEDLYEZSE/TILTSA

	MOVLW	DEL2TMP			;BETANTSNL VRJA AZ IR JELFELISMERS VGT
	MOVWF	DEL2+1	

	MOVLW	DEL3TMP
	MOVWF	DEL3+1			;GOMBOK NYOMVATARTSNAK IDEJE RESETELSHEZ
	
;.......................................... EPROM RTKADSOK.......................................................
	
	MOVLW	D'255'			;IR JELEK KEZD CME
	MOVWF	EEADR

	CALL	EP
	MOVWF	JELKIBE
	CALL	EP
	MOVWF	JELKIBE+1
	CALL	EP				;KI/BEKAPCSOL GOMBHOZ TARTOZ IRJEL BETLTSE AZ EPROMBL
	MOVWF	JELKIBE+2
	CALL	EP
	MOVWF	JELKIBE+3

	CALL	EP
	MOVWF	JELMAX
	CALL	EP
	MOVWF	JELMAX+1
	CALL	EP				;MAX. GOMBHOZ TARTOZ IRJEL BETLTSE AZ EPROMBL
	MOVWF	JELMAX+2
	CALL	EP
	MOVWF	JELMAX+3
	
	CALL	EP
	MOVWF	JELMIN
	CALL	EP
	MOVWF	JELMIN+1
	CALL	EP				;MIN. GOMBHOZ TARTOZ IRJEL BETLTSE AZ EPROMBL
	MOVWF	JELMIN+2
	CALL	EP
	MOVWF	JELMIN+3	

PAUSE

	CALL	GMBK
	BTFSS	GMBSTS			;RESET UTN A GOMBOK FELENGEDSIG A PROGRAMFUTS NEM FOJTATDIK
	BRA		PAUSE
	CALL	DELAY			;PRELLMENTESTS
	
	BCF		INTCON3,INT2IF	
	BSF		INTCON,GIE		;MEGSZAKTSOK ENGEDLYEZVE
	BRA		OFF

;.......................................... HIGH PRIORITS MEGSZAKTS ............................................

HPM

	BTFSC	INTCON,TMR0IF	
	BRA		TIMER0			;TIMER0 MEGSZAKTS AZONOSTSA	
	
	BTFSC	PIR2,CMIF		;KOMPARTOR MEGSZAKTS AZONOSTSA
	BRA		CMP	

	BTFSC	INTCON3,INT1IF
	BRA		INTE1			;INT1 MEGSZAKTS AZONOSTSA	

	BTFSC	INTCON3,INT2IF
	BRA		INTE2			;INT2 MEGSZAKTS AZONOSTSA	

	BTFSS	INTCON,INT0IF	;INT0 MEGSZAKTS AZONOSTSA
	RETFIE	FAST			;MINDEN MS MEGSZAKTS

INTE0

	MOVF	PORTB,W
	BCF		INTCON,INT0IF

	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BTFSC	KIBEET			;KI-,BEK.GOMB ENGEDLYEZSE/TILTSA
	BTG		KIBE			;KI-BEKAPCSOLS
	RETFIE	FAST

INTE1

	MOVF	PORTB,W
  	BCF		INTCON3,INT1IF

	BTFSC	G1G2ET
	BSF		KFENY			;KSZENLTI JELZFNY ENGEDLYEZSE
	RETFIE	FAST

INTE2

	MOVF	PORTB,W
  	BCF		INTCON3,INT2IF

	BTFSC	G1G2ET
	BCF		KFENY			;KSZENLTI JELZFNY TILTSA
	RETFIE	FAST

CMP

	MOVF	CMCON,W	
	BCF		PIR2,CMIF

	MOVF	TIME,W
	MOVWF	TMR0L			;TIMER0 KSLELTETS BELLTSA A KOMPARTOR MEGSZAKTSAKOR
	BSF		TMRSET	
	RETFIE	FAST

TIMER0

	BCF		INTCON,TMR0IF

	BTFSC	IMPCLR
	BRA		GYUJTKI

	BTFSS	TMRSET
	RETFIE	FAST

	BSF		GYUJTAS			;GYJTIMPULZUS INDTSA

	MOVLW	IMP
	MOVWF	TMR0L			;IMPULZUSID

	BSF		IMPCLR
	BCF		TMRSET
	
	RETFIE	FAST

GYUJTKI

	BCF		GYUJTAS			;GYJTIMPULZUS LELLTSA
	BCF		IMPCLR

    RETFIE	FAST

;.......................................... LOW PRIORITS MEGSZAKTS ............................................

LPM

	BTFSC	PIR1,TMR2IF
	BRA		TIMER2			;TIMER2 MEGSZAKTS AZONOSTSA
	
	BTFSC	PIR1,TMR1IF		;TIMER1 MEGSZAKTS AZONOSTSA
	BRA		TIMER1			

	BTFSS	INTCON,RBIF
	RETFIE	FAST			;MINDEN MS MEGSZAKTS

RB

	MOVF	PORTB,W
	BCF		INTCON,RBIF

	SETF	TMR1H			;TIMER1 KSLELTETS BELLTSA BEJV IR JELNL
	CLRF	TMR1L			

	MOVLW	TMR1LEF			;TIMER1 MSODSZORI LEFUTSNAK KSLELTETSE
	MOVWF	TMR1ET

	BTG		IND1
	RETFIE	FAST

TIMER1
	
	BCF		PIR1,TMR1IF
	
	DCFSNZ	TMR1ET
	BRA		KI0

	BSF		IND				;IR JELFELISMERS DIAGNOSZTIKA
	
	BTFSC	IRJEL
	BSF		JELTMP,0		;TROLJA AZ IR JEL LOGIKAI SZINTJT
	BTFSS	IRJEL
	BCF		JELTMP,0

	INCF	SZAML,F			;SZAML NVELSE

	MOVLW	D'8'
	CPFSEQ	SZAML,W			;HA BETELIK A JEL 8 BITJE UGRS A TROLSHOZ						 
	BRA		A0
	MOVFF	JELTMP,JELTMP1

A0
	
	MOVLW	D'16'
	CPFSEQ	SZAML,W			;HA BETELIK A JEL 8 BITJE UGRS A TROLSHOZ
	BRA		A1
	MOVFF	JELTMP,JELTMP1+1

A1

	MOVLW	D'24'
	CPFSEQ	SZAML,W			;HA BETELIK A JEL 8 BITJE UGRS A TROLSHOZ
	BRA		A2
	MOVFF	JELTMP,JELTMP1+2

A2

	MOVLW	D'32'
	CPFSEQ	SZAML,W			;HA BETELIK A JEL 8 BITJE UGRS A TROLSHOZ
	BRA		A3
	MOVFF	JELTMP,JELTMP1+3

	BCF		ELLET			;IRJEL ELLENRZS TILTSA
	MOVFF	JELTMP1,JEL
	MOVFF	JELTMP1+1,JEL+1
	MOVFF	JELTMP1+2,JEL+2	;IR JEL MSOLSA ELLENRZSHEZ
	MOVFF	JELTMP1+3,JEL+3

	BSF		ELLET			;IRJEL ELLENRZS ENGEDLYEZSE
	BCF		IND				;IR JELFELISMERS DIAGNOSZTIKA
	CLRF	TMR1ET
	BRA		KI0

A3

	RLNCF	JELTMP,F		;BALRA FORGATJA A JEL BITJEIT MIELTT BERSRA KERL A KVETKEZ SZINT RTKE

	MOVLW	IRFS
	MOVWF	TMR1H			;KSLELTETS BELLTSA
	CLRF	TMR1L

	BCF		IND				;IR JELFELISMERS DIAGNOSZTIKA

	RETFIE	FAST

KI0

	CLRF	SZAML
	INCF	TMR1ET

	RETFIE	FAST

TIMER2

	BCF		PIR1,TMR2IF

	DECFSZ	DEL3
	BRA		PWM00			;GOMBOK NYOMVATARTSNAK IDEJE RESETELSHEZ
	DECFSZ	DEL3+1
	BRA		PWM00
	
	MOVLW	DEL3TMP
	MOVWF	DEL3+1

	BTFSC	GOMB0
	BRA		PWM00
	BTFSC	GOMB1			
	BRA		PWM00			;RESET HA MINDEN GOMB NYOMVA
	BTFSC	GOMB2
	BRA		PWM00
	RESET

PWM00
	
	BTFSS	FENY			;JELZFNY ENGEDLYEZSNEK LEKRDEZSE
	RETFIE	FAST			

	DECFSZ	PWMDEL,F
	RETFIE	FAST
	MOVF	DELTEMP,W		;PWM SEBESSGE
	MOVWF	PWMDEL

	BTFSC	NVM
	BRA		PWM1

	BTFSC	NCS
	BRA		PWM0		
	INCFSZ	KITOLTES,F		;KITLTS NVELSE
	BRA		PWM2

PWM0

	BSF		NCS
	DECF	KITOLTES,F
	MOVLW	FENYMIN			;FNYER MINIMUMA KT VILLANS KZTT
	CPFSEQ	KITOLTES,W
	BRA		PWM2
	
	BCF		NCS
	DECFSZ	PWMV,F
	BRA		PWM2
	MOVLW	PWMVTEMP		;FELVILLANSOK SZMA
	MOVWF	PWMV

PWM1

	BSF		NVM
	DECFSZ	KITOLTES,F		;KITLTS CSKKENTSE 0 SZZALKRA
	BRA		PWM2
	BCF		FENY			;JELZFNY TILTSA
	BCF		NVM

	MOVLW	DEL1TEMP
	MOVWF	DEL1+2			;KT VILLANS KZTI SZNETID VISSZALLTSA

PWM2

	MOVF	KITOLTES,W		;KITLTS BERSA
	MOVWF	CCPR2L
	RETFIE	FAST

;................................................... FPROGRAM .....................................................
	
ON

	BCF		G1G2ET			;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI TILTS
	BCF		KIBEET			;KI-,BEK.GOMB TILTSA

	MOVLW	SEB1			;FNYER NVELSNEK SEBESSGE BEKAPCSOLSKOR
	MOVWF	DEL0TEMP

	BSF	   	T0CON,TMR0ON	;TIMER0 BEKAPCSOLSA
	MOVFF	LED,LEDSOR		
	MOVFF	LED+1,LEDSOR1	;LEDSOR BEKAPCSOLSA

	INCF	TIME,F			;FNYER FOKOZATOS NVELSE BEKAPCSOLSL
	CALL	DELAY			

	MOVF	TIMETEMP,W		;UTOLJRA HASZNLT FNYER BELLTSA, A FOKOZATOS NVELSHEZ
	CPFSEQ	TIME,W			
	BRA		ON	

	MOVLW	SEB0			;SEBESSG VISSZALLTSA
	MOVWF	DEL0TEMP

	BCF		ELLET

GMB0

	BTFSC	ELLET			;IRJEL ELLENRZSE
	BRA		ELL0

	BSF		KIBEET			;KI-,BEK.GOMB ENGEDLYEZSE

	BTFSS	KIBE			;KIKAPCSOLS FIGYELSE
	BRA		OFFCFG

	BTFSC	GOMB0
	MOVFF	IRGF,IRG		;NYOMVATARS IDEJNEK VISSZALLTSA, HA MINDEN GOMB FEL VAN ENGEDVE

	BTFSC	GOMB0
	BRA		GMB1
	CALL	DELAY
	DECFSZ	IRG,F			;KIBE.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		GMB1

	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE

	BSF		KIBETAN
	BRA		BTN0

GMB1

	BTFSC	GOMB1
	BRA		GMB2
	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BTFSS	LED1			;MAX. GOMB BETANTSRA VLTS CSAK AKKOR, HA A FNYER MAXIMUMON VAN
	BRA		MAX

	CALL	DELAY
	DECFSZ	IRG,F			;MAX.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		GMB1

	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE

	BSF		MAXTAN
	BRA		BTN0			
	
GMB2

	BTFSC	GOMB2	
	BRA		GMB0
	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BTFSC	LED,1			;MIN. GOMB BETANTSRA VLTS CSAK AKKOR, HA A FNYER MINIMUMON VAN
	BRA		MIN
	
	CALL	DELAY
	DECFSZ	IRG,F			;MIN.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		GMB2

	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE
	
	BSF		MINTAN
	BRA		BTN0

MAX

	BSF		FENY			;JELZFNY ENGEDLYEZSE

	BTFSC	LED1			;KILPS HA A FNYER MAXIMUMON VAN
	BRA		GMB1

	BSF		STATUS,C
	RLCF	LED,F			;LEDSOR LPTETSE
	MOVFF	LED,LEDSOR

	MOVLW	LED0BE
	CPFSLT	TIME
	BSF		LED0			;9.LED BEKAPCSOLSA A LEDSORON

	MOVLW	LED1BE
	CPFSLT	TIME
	BSF		LED1			;10.LED BEKAPCSOLSA A LEDSORON
	MOVFF	LED+1,LEDSOR1

JMP0

	INCF	TIME,F			;FNYER NVELSE	
	CALL	DELAY

	DECFSZ	OSZT,F
	BRA		JMP0

	MOVLW	OSZTO			;MEGHATROZZA HOGY EGY GOMBNYOMS HATSRA MENNYIT VLTOZZON A FNYER
	MOVWF	OSZT
	BRA		GMB1
	
MIN

	BSF		FENY			;JELZFNY ENGEDLYEZSE

	BTFSS	LED,1			;KILPS HA A FNYER MINIMUMON VAN
	BRA		GMB2

	BCF		STATUS,C
	BTFSS	LED0
	RRCF	LED,F			;LEDSOR LPTETSE
	MOVFF	LED,LEDSOR

	MOVLW	LED0KI
	CPFSGT	TIME			;9.LED KIKAPCSOLSA A LEDSORON
	BCF		LED0

	MOVLW	LED1KI
	CPFSGT	TIME
	BCF		LED1			;10.LED KIKAPCSOLSA A LEDSORON
	MOVFF	LED+1,LEDSOR1
	
JMP1

	DECF	TIME,F			;FNYER CSKKENTSE	
	CALL	DELAY

	DECFSZ	OSZT,F
	BRA		JMP1

	MOVLW	OSZTO			;MEGHATROZZA HOGY EGY GOMBNYOMS HATSRA MENNYIT VLTOZZON A FNYER
	MOVWF	OSZT			
	BRA		GMB2

OFFCFG

	BSF		G1G2ET			;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI ENGEDLYEZSE
	BCF		KIBEET			;KI-,BEK.GOMB TILTSA

	CLRF	LEDSOR			;LEDSOR KIKAPCSOLSA
	CLRF	LEDSOR1
	MOVFF	TIME,TIMETEMP	;FNYER MENTSE A MVELET IDEJIG

JMP2
	
	BCF		ELLET

	MOVLW	SEB1			;FNYER CSKKENTSNEK SEBESSGE KIKAPCSOLSNL
	MOVWF	DEL0TEMP

	MOVLW	FOK0			;TRIAK GYJTS MAXIMLIS KSLELTETSE
	CPFSGT	TIME
	BRA		OFF

	DECF	TIME,F
	CALL	DELAY			;FNYER CSKKENTSE KIKAPCSOLSKOR
	BRA		JMP2

OFF

	BTFSC	ELLET			;IRJEL ELLENRZSE 
	BRA		ELL0

	BSF		G1G2ET			;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI ENGEDLYEZSE
	BSF		KIBEET			;KI-,BEK.GOMB ENGEDLYEZSE

	MOVLW	SEB0			;SEBESSG VISSZALLTSA
	MOVWF	DEL0TEMP

	BCF	   	T0CON,TMR0ON	;TIMER0 KIKAPCSOLSA
	BCF		GYUJTAS			;GYJTIMPULZUS LELLTSA

	BTFSC	KIBE			;BEKAPCSOLS FIGYELSE
	BRA		ON
	
	DECFSZ	DEL1,F
	BRA		JMP3
	DECFSZ	DEL1+1			;KSZENLTI JELZFNY KT BEKAPCSOLS KZTT ELTELT ID
	BRA		JMP3
	DECFSZ	DEL1+2
	BRA		JMP3

	MOVLW	DEL1TEMP
	MOVWF	DEL1+2

	BTFSC	KFENY
	BSF		FENY			;KSZENLTI JELZFNY ENGEDLYEZSE	

JMP3

	BTFSC	GOMB0
	MOVFF	IRGF,IRG		;NYOMVATARS IDEJNEK VISSZALLTSA, HA MINDEN GOMB FEL VAN ENGEDVE

	BTFSC	GOMB0			;KIBE.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		JMP4

	CALL	DELAY
	DECFSZ	IRG,F			
	BRA		OFF

	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE

	BSF		KIBETAN
	BRA		BTN0

JMP4

	BTFSC	GOMB1			;MAX.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		JMP5

	BSF		FENY			;JELZFNY ENGEDLYEZSE

	CALL	DELAY
	DECFSZ	IRG,F			
	BRA		JMP4
	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE

	BSF		MAXTAN
	BRA		BTN0

JMP5

	BTFSC	GOMB2			;MIN.GOMB NYOMVATARTSNL BETANTSRA VLT		
	BRA		OFF

	BSF		FENY			;JELZFNY ENGEDLYEZSE

	CALL	DELAY
	DECFSZ	IRG,F			
	BRA		JMP5
	MOVFF	IRGF,IRG		;NYOMVATARS IDEJE

	BSF		MINTAN
	BRA		BTN0
	
BTN0

	BCF		KIBEET			;KI-,BEK.GOMB TILTSA
	BCF		G1G2ET			;MIN.GOMB,MAX.GOMB KSZENLTIFNY FUNKCI TILTS

	MOVLW	DTMP1
	MOVWF	DELTEMP			;JELZFNY SEBESSG BELLTSA BETANTSNL

BTN1

	BSF		FENY			;JELZFNY ENGEDLYEZSE
	CALL	GMBK
	BTFSS	GMBSTS			;A GOMBOK FELENGEDSIG MINDEN FUNKCI TILTVA
	BRA		BTN1

	CALL	DELAY			;PRELLMENTESTS

BTKI

	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BTFSS	IRJEL			;INFRAJEL BETANTSA
	BRA		BETAN

	CALL	GMBK
	BTFSS	GMBSTS			;BRMELYIK GOMB MEGNYOMSAKOR KILPS A BETANTSBL
	BRA		BTKI1			
	BRA		BTKI		

BTKI1

	BTFSC	FENY			;JELZFNY KIKAPCSOLSIG A SEBESSG NEM VLTOZIK
	BRA		BTKI1		
	MOVLW	DTMP
	MOVWF	DELTEMP			;JELZFNY SEBESSG VISSZALLTSA
	BSF		FENY			;JELZFNY ENGEDLYEZSE

	CALL	DELAY			;PRELLMENTESTS

BTKI2

	CALL	GMBK
	BTFSS	GMBSTS			;A GOMBOK FELENGEDSIG MINDEN FUNKCI TILTVA
	BRA		BTKI2	
			
	CALL	DELAY			;PRELLMENTESTS

	BTFSC	KIBE
	BRA		GMB0			;KILPS A BETANTSBL
	BRA		OFF

GMBK

	BSF		GMBSTS	
	BTFSS	GOMB0
	BCF		GMBSTS
	BTFSS	GOMB1
	BCF		GMBSTS			;GOMBOK LLAPOT TESZTELSE 
	BTFSS	GOMB2
	BCF		GMBSTS
	RETURN

DELAY

	DECFSZ	DEL0,F
	BRA 	DELAY
	DECFSZ	DEL0+1,F		;A LPTETS SEBESSGT HATROZZA MEG
	BRA 	DELAY
	MOVFF	DEL0TEMP,DEL0+1
	RETURN

;................................................. IR TVIRNYTS .................................................

BETAN		

	BTFSC	ELLET
	BRA		BETAN1
	BSF		FENY
	DECFSZ	DEL2			;VR AZ IR JELFELISMERS VGRE
	BRA		BETAN
	DECFSZ	DEL2+1
	BRA		BETAN

	CLRF	DEL2			
	MOVLW	DEL2TMP
	MOVWF	DEL2+1			;SZNETID VISSZALLTSA
	BCF		ELLET
	BRA		BTKESZ

BETAN1

	CLRF	DEL2			
	MOVLW	DEL2TMP			;SZNETID VISSZALLTSA
	MOVWF	DEL2+1
	BCF		ELLET

	BTFSC	KIBETAN
	BRA		IRTAN0
	BTFSC	MAXTAN			;BETANTST INDT GOMB FELISMERSE
	BRA		IRTAN1
	BTFSC	MINTAN
	BRA		IRTAN2
	BRA		BTKI

IRTAN0

	MOVFF	JEL,JELKIBE
	MOVFF	JEL+1,JELKIBE+1
	MOVFF	JEL+2,JELKIBE+2	;IR JEL MENTSE A KIVLASZTOTT GOMBHOZ
	MOVFF	JEL+3,JELKIBE+3
	BCF		KIBETAN
	
	MOVLW	D'255'
	MOVWF	EEADR
	MOVF	JELKIBE,W
	CALL	EPI
	MOVF	JELKIBE+1,W
	CALL	EPI				;EPROMRS
	MOVF	JELKIBE+2,W
	CALL	EPI
	MOVF	JELKIBE+3,W
	CALL	EPI

	BRA		BTKESZ

IRTAN1	

	MOVFF	JEL,JELMAX
	MOVFF	JEL+1,JELMAX+1
	MOVFF	JEL+2,JELMAX+2	;IR JEL MENTSE A KIVLASZTOTT GOMBHOZ
	MOVFF	JEL+3,JELMAX+3
	BCF		MAXTAN	

	MOVLW	D'3'
	MOVWF	EEADR
	MOVF	JELMAX,W
	CALL	EPI
	MOVF	JELMAX+1,W
	CALL	EPI				;EPROMRS
	MOVF	JELMAX+2,W
	CALL	EPI
	MOVF	JELMAX+3,W
	CALL	EPI

	BRA		BTKESZ

IRTAN2

	MOVFF	JEL,JELMIN
	MOVFF	JEL+1,JELMIN+1
	MOVFF	JEL+2,JELMIN+2	;IR JEL MENTSE A KIVLASZTOTT GOMBHOZ
	MOVFF	JEL+3,JELMIN+3
	BCF		MINTAN

	MOVLW	D'7'
	MOVWF	EEADR
	MOVF	JELMIN,W
	CALL	EPI
	MOVF	JELMIN+1,W
	CALL	EPI				;EPROMRS
	MOVF	JELMIN+2,W
	CALL	EPI
	MOVF	JELMIN+3,W
	CALL	EPI

BTKESZ

	BTFSC	FENY			;JELZFNY KIKAPCSOLSIG A SEBESSG NEM VLTOZIK
	BRA		BTKESZ	
	MOVLW	DTMP
	MOVWF	DELTEMP			;JELZFNY SEBESSG VISSZALLTSA
	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BRA		IRKI

ELL0
	
	BCF		JELCOM
	CLRF	SZAML
	BCF		ELLET			;IRJEL FELISMERS FOLYAMATBAN

	MOVF	JEL,W
	CPFSEQ	JELKIBE
	BRA		U1
	BRA		U0

U1

	BTG		WREG,3			
	BTG		WREG,4			;IRJEL 3.S 4.BITJNEK KOMPLEMENTLSA HOGY A GOMB MINDEN MSODIK MEGNYOMSA IS FELISMERSRE KERLJN
	CPFSEQ	JELKIBE
	BRA		ELL1	
	BSF		JELCOM

U0
	MOVF	JEL+1,W
	CPFSEQ	JELKIBE+1		
	BRA		ELL1				
	MOVF	JEL+2,W
	CPFSEQ	JELKIBE+2		;KI/BEKAPCSOL GOMBHOZ TARTOZ IRJEL ELLENRZSE
	BRA		ELL1
	MOVF	JEL+3,W
	CPFSEQ	JELKIBE+3
	BRA		ELL1

	BTFSS	JELCOM
	BRA		BE

	BTFSS	KIBE
	BRA		OFF
	BCF		KIBE
	BRA		OFFCFG			;BEKAPCSOLT LLAPOTBAN KIKAPCSOLS

BE	

	BTFSC	KIBE
	BRA		GMB0
	BSF		KIBE
	BRA		ON				;KIKAPCSOLT LLAPOTBAN BEKAPCSOLS

ELL1

	MOVF	JEL,W
	CPFSEQ	JELMAX
	BRA		U2
	BRA		U3

U2

	BTG		WREG,3
	BTG		WREG,4			;IRJEL 3.S 4.BITJNEK KOMPLEMENTLSA HOGY A GOMB MINDEN MSODIK MEGNYOMSA IS FELISMERSRE KERLJN
	CPFSEQ	JELMAX
	BRA		ELL2

U3
	MOVF	JEL+1,W
	CPFSEQ	JELMAX+1
	BRA		ELL2			
	MOVF	JEL+2,W
	CPFSEQ	JELMAX+2		;MAX.GOMBHOZ TARTOZ IRJEL ELLENRZSE
	BRA		ELL2
	MOVF	JEL+3,W
	CPFSEQ	JELMAX+3
	BRA		ELL2

	BTFSC	KIBE		
	BRA		MAX
				
	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BSF		KFENY			;KSZENLTI FNY TILTSA
	BRA		IRKI	

ELL2
	
	MOVF	JEL,W
	CPFSEQ	JELMIN
	BRA		U4
	BRA		U5

U4

	BTG		WREG,3
	BTG		WREG,4			;IRJEL 3.S 4.BITJNEK KOMPLEMENTLSA HOGY A GOMB MINDEN MSODIK MEGNYOMSA IS FELISMERSRE KERLJN
	CPFSEQ	JELMIN
	BRA		IRKI

U5

	MOVF	JEL+1,W
	CPFSEQ	JELMIN+1
	BRA		IRKI			
	MOVF	JEL+2,W
	CPFSEQ	JELMIN+2		;MIN.GOMBHOZ TARTOZ IRJEL ELLENRZSE
	BRA		IRKI
	MOVF	JEL+3,W
	CPFSEQ	JELMIN+3
	BRA		IRKI

	BTFSC	KIBE		
	BRA		MIN
	BSF		FENY			;JELZFNY ENGEDLYEZSE
	BCF		KFENY			;KSZENLTI FNY TILTSA

IRKI

	BTFSC	KIBE
	BRA		GMB0			;KILPS AZ ELLENRZSBL/BETANTSBL
	BRA		OFF

;................................................ EPROM RS/OLVASS ...............................................

EP	

	INCF	EEADR,F			;CM MEGADSA
	BCF 	EECON1,CFGS		;EEPROM KIVLASZTSA
	BCF 	EECON1,EEPGD
	BSF		EECON1,RD		;OLVASS ENGEDLYEZSE
	MOVF	EEDATA,W		;W = EEDATA
	RETURN

EPI

	BCF		INTCON,GIE		;MEGSZAKTSOK TILTSA
	MOVWF	EEDATA			;W = EEDATA
	INCF	EEADR,F			;CM MEGADSA
	BCF 	EECON1,EEPGD	;EEPROM KIVLASZTSA
	BCF 	EECON1,CFGS
	BSF 	EECON1,WREN 	;RS ENGEDLYEZSE
	BCF		INTCON,GIE
	MOVLW	55h ;
	MOVWF	EECON2 			;KTELEZ RTKADS
	MOVLW 	0AAh ;
	MOVWF	EECON2
	BSF 	EECON1,WR 		;RS INDTSA
	BTFSS	PIR2,EEIF
	BRA		$-2
	BCF		PIR2,EEIF
	BSF 	INTCON,GIE		;MEGSZAKTSOK ENGEDLYEZSE
	BCF 	EECON1,WREN		;RS TILTSA
	RETURN

	END