/************************************************************************/
/*                                                                      */
/*                      PIC PID library                                 */
/*                                                                      */
/* Overview: PID library for PIC microcontrollers                       */
/*                                                                      */
/* Features: PT0, PT1, PT2, IT0, DT0                                    */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                                                                      */
/* Author: A. Huszti kyrk@villamvadasz.hu                               */
/* Version : 1.0                                                        */
/*                                                                      */
/************************************************************************/

/** Includes ************************************************************/

#include "global.h"
#include "pid.h"
#include "signalprocessor.h"

/** Defines *************************************************************/

/** Constants************************************************************/

/** Variables ***********************************************************/

double output = 0;

T1_var T1_i = {0, 1, 0};
T1_var T1_d = {0, 1, 0};
IT0_var	IT0_a = {0, 1, 0, -1024, 1024};
DT0_var	DT0_a = {0, 1, 0};
PT0_var	PT0_a = {0 , 1}; 

/** Functions ***********************************************************/

/************************************************************************/

double doPID(double in) {
	PT0_a.in = in;
	DT0_a.in = in;
	IT0_a.in = in;
	T1_i.in = in;
	T1_d.in = in;

	output = PIT1DT1(&PT0_a,&IT0_a, &T1_i, &DT0_a, &T1_d );
	return output;
}

void setParameters(double Ap, double Ad, double Td, double Ai, double Ti) {
	PT0_a.ap = Ap;
	DT0_a.ad = Ad;
	IT0_a.ai = Ai;
	T1_d.time1 = Td;
	T1_i.time1 = Ti;
}

void setLimits(double min, double max) {
	IT0_a.max = max;
	IT0_a.min = min;
}

void setTimeSlice(double timeSlice) {
	timeSlice_param = timeSlice;
	kcsillag = 432.9 / timeSlice_param;
}
