/************************************************************************/
/*                                                                      */
/*                      PIC PID library                                 */
/*                                                                      */
/* Overview: PID library for PIC microcontrollers                       */
/*                                                                      */
/* Features: PT0, PT1, PT2, IT0, DT0                                    */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                                                                      */
/* Author: A. Huszti kyrk@villamvadasz.hu                               */
/* Version : 1.0                                                        */
/*                                                                      */
/************************************************************************/

/** Includes ************************************************************/

#include "global.h"
#include "scaler.h"

/** Defines *************************************************************/

/** Constants************************************************************/

/** Variables ***********************************************************/

/** Functions ***********************************************************/

/************************************************************************/

double doScaling( Scaler *scaler) {
	double result = 0;
	double scale_a = 0;
	double scale_b = 0;
	if (scaler->input <= scaler->from_min) {
		result = scaler->to_min;
	} else if (scaler->input >= scaler->from_max) {
		result = scaler->to_max;
	} else {
		scale_a = (scaler->from_max - scaler->from_min);
		scale_b = (scaler->to_max - scaler->to_min);
		result = ((((scaler->input - scaler->from_min) / scale_a) * scale_b) + scaler->to_min);
	}
	return result;
}
