/************************************************************************/
/*                                                                      */
/*                      PIC PID library                                 */
/*                                                                      */
/* Overview: PID library for PIC microcontrollers                       */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                                                                      */
/* Author: A. Huszti kyrk@villamvadasz.hu                               */
/* Version : 1.0                                                        */
/*                                                                      */
/************************************************************************/

#ifndef _SIGNALPROCESSOR_H_
#define _SIGNALPROCESSOR_H_

/** Includes ************************************************************/

/** Defines *************************************************************/

#define TIMESLICE 1	//ms
#define OFF	0

/** Typedef *************************************************************/
typedef struct  {
	double in;
	double time1;
	double temp1;
} T1_var;

typedef struct  {
	double in;
	double time1;
	double time2;
	double temp1;
	double temp2;
} T2_var;

typedef struct {
	double in;
	double ap;
}PT0_var;

typedef struct {
	double in;
	double ad;
	double temp1;
}DT0_var;

typedef struct {
	double in;
	double ai;
	double temp1;
	double min;
	double max;
}IT0_var;

/** Constants************************************************************/

/** Variables ***********************************************************/
	extern double timeSlice_param;
	extern double kcsillag;
/** Functions ***********************************************************/
extern double T1 (T1_var *T1_num);
extern double T2 (T2_var *T2_num);
extern double PT0 (PT0_var *PT0_num);
extern double DT0 (DT0_var *DT0_num);
extern double IT0 (IT0_var *IT0_num);

extern double IT1 (IT0_var *IT0_num,  T1_var *T1_num);
extern double DT1 (DT0_var *DT0_num,  T1_var *T1_num);
extern double IT2 (IT0_var *IT0_num,  T2_var *T2_num);
extern double DT2 (DT0_var *DT0_num,  T2_var *T2_num);
extern double PT1 (PT0_var *PT0_num,  T1_var *T1_num);
extern double PT2 (PT0_var *PT0_num,  T2_var *T2_num);

extern double PIT0 (PT0_var *PT0_num,IT0_var *IT0_num);
extern double PIT1 (PT0_var *PT0_num,IT0_var *IT0_num, T1_var *T1_num);
extern double PIT2 (PT0_var *PT0_num,IT0_var *IT0_num, T2_var *T2_num);
extern double PDT0 (PT0_var *PT0_num,DT0_var *DT0_num);
extern double PDT1 (PT0_var *PT0_num,DT0_var *DT0_num, T1_var *T1_num);
extern double PDT2 (PT0_var *PT0_num,DT0_var *DT0_num, T2_var *T2_num);

extern double PIT0D0 (PT0_var *PT0_num,IT0_var *IT0_num, DT0_var *DT0_num);
extern double PIT1DT1 (PT0_var *PT0_num,IT0_var *IT0_num, T1_var *IT1_num,  DT0_var *DT0_num, T1_var *DT1_num);

/************************************************************************/


#endif
