/*****************************************************************************/
/**                                                                         **/
/**                         c o n t r o l l e r . c                         **/
/**                                                                         **/
/*****************************************************************************/
/**                                                                         **/
/**                  Copyrights(c) 2008 by Andras Huszti,                   **/
/**                              Budapest                                   **/
/**                                                                         **/
/** Project   :    PID library                                              **/
/** Date      :    22.08.2008                                               **/
/** Author    :    A. Huszti                                                **/
/**                                                                         **/
/*****************************************************************************/
/** Content: Short description / summary                                    **/
/**                                                                         **/
/*****************************************************************************/
/** Date       Author        Rev  Changes:                                  **/
/** 22.08.2008 A. Huszti     1.0  Start:                                    **/
/**                                                                         **/
/*****************************************************************************/

/*********************** Compiler options ( #pragma ) ************************/

/******************* Header / include files ( #include ) *********************/

#include <stdio.h>
#include "global.h"
#include "controller.h"

/***************** Constant / macro definitions ( #define ) ******************/

/*********************** Type definitions ( typedef ) ************************/

/************************* Global data definitions ***************************/
/*											Input MIN,    Input MAX, Output MIN,   Output MAX, input (always 0 here) */
Scaler	input_alap_scaler =				{           0,         1023,          0, INTERNAL_MAX, 0};
Scaler	input_ellenorzo_scaler = 		{           0,         1023,          0, INTERNAL_MAX, 0};
Scaler	output_vegrehajto_heat_scaler =	{           0, INTERNAL_MAX,          0,         1023, 0};
Scaler	output_vegrehajto_cold_scaler =	{INTERNAL_MIN,            0,       1023,            0, 0};

/****************** Global constant definitions ( const ) ********************/

/******************* Modul global data segment ( static ) ********************/

/***************** Modul global constants ( static const ) *******************/

/****************** Local func/proc prototypes ( static ) ********************/

/** EndOfHeader **************************************************************/

/*****************************************************************************/
/**                                                                         **/
/** Function  :                                                             **/
/** Param In  :                                                             **/
/** Param Out :                                                             **/
/** Return    :                                                             **/
/** Data In   :                                                             **/
/** Data Out  :                                                             **/
/** Remarks   :                                                             **/
/*****************************************************************************/
void doControling(double alap, double ellenorzo, double *heat, double *cold) {

/************************** Local data declaration ***************************/
	double rendelkezo = 0;

/************************* Static data declaration ***************************/

/****************************** Function Code ********************************/

	//input alapjel scaler
	input_alap_scaler.input = alap;
	
	//input ellenorzojel scaler
	input_ellenorzo_scaler.input = ellenorzo;	

	//rendelkezo = alapjel - ellenorzo;
	rendelkezo = doScaling(&input_alap_scaler) - doScaling(&input_ellenorzo_scaler);

	//PID	
	rendelkezo = doPID(rendelkezo);

	//output scaler 1 heat
	output_vegrehajto_heat_scaler.input = rendelkezo;	
	//output scaler 2 cold
	output_vegrehajto_cold_scaler.input = rendelkezo;

	//vegrehajto jel
	if (heat != NULL) {
		*heat = doScaling(&output_vegrehajto_heat_scaler);
	}
	if (cold != NULL) {
		*cold = doScaling(&output_vegrehajto_cold_scaler);
	}
}
/** EndOfFunction ************************************************************/

/** EndOfFile main.c *********************************************************/
