/************************************************************************/
/*                                                                      */
/*                      PIC PID library                                 */
/*                                                                      */
/* Overview: PID library for PIC microcontrollers                       */
/*                                                                      */
/* Features: PT0, PT1, PT2, IT0, DT0                                    */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                                                                      */
/* Author: A. Huszti kyrk@villamvadasz.hu                               */
/* Version : 1.0                                                        */
/*                                                                      */
/************************************************************************/

/** Includes ************************************************************/

#include "global.h"
#include "hyst.h"

/** Defines *************************************************************/

/** Constants************************************************************/

/** Variables ***********************************************************/

/** Functions ***********************************************************/

/************************************************************************/

double doHyst(Hyst *hyst) {
	double result = 0;
	if (hyst->input >= hyst->hyst_max) {
		hyst->temp = hyst->to_max;
	} else if (hyst->input <= hyst->hyst_min) {
		hyst->temp = hyst->to_min;
	}
	result = hyst->temp;
	return result;
}
