/************************************************************************/
/*                                                                      */
/*                      PIC PID library                                 */
/*                                                                      */
/* Overview: PID library for PIC microcontrollers                       */
/*                                                                      */
/* Features: PT0, PT1, PT2, IT0, DT0                                    */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/*                                                                      */
/************************************************************************/
/*                                                                      */
/*                                                                      */
/* Author: A. Huszti kyrk@villamvadasz.hu                               */
/* Version : 1.0                                                        */
/*                                                                      */
/************************************************************************/

/** Includes ************************************************************/

#include "global.h"
#include "signalprocessor.h"

/** Defines *************************************************************/

/** Constants************************************************************/

/** Variables ***********************************************************/
double timeSlice_param = 1;
double kcsillag = 432.9 / 1;

/** Functions ***********************************************************/

/************************************************************************/

double T1 (T1_var *T1_num) {//OK
	double temp = 0;
	double modTime1 = 0;
	modTime1 = T1_num->time1 * kcsillag;
	if ((T1_num->time1 == OFF) || (modTime1 < 1)) {
		temp = T1_num->in;
		T1_num->temp1 = temp;
	} else {
		temp = (T1_num->in - T1_num->temp1) / (T1_num->time1 * kcsillag);
		T1_num->temp1 += temp;
	}
	return  T1_num->temp1;
}

double T2 (T2_var *T2_num) {//OK
	double temp = 0;
	double modTime1 = 0;
	double modTime2 = 0;
	modTime1 = (T2_num->time1 * kcsillag);
	modTime2 = (T2_num->time2 * kcsillag);
	if ((T2_num->time1 == OFF) || (modTime1 < 1)) {
		temp = T2_num->in;
	} else {
		temp = (T2_num->in - T2_num->temp1) / (T2_num->time1 * kcsillag);
	}
	T2_num->temp1 += temp;
	if ((T2_num->time2 == OFF) || (modTime2 < 1)) {
		T2_num->temp2 = temp;
	} else 	{
		temp = (temp - T2_num->temp2) / (T2_num->time2 * kcsillag);
		T2_num->temp2 += temp;
	}
	return T2_num->temp2;
}

double PT0 (PT0_var *PT0_num) {//OK
	double temp = 0;
	temp = PT0_num->in * PT0_num->ap;
	return temp;
}

double DT0 (DT0_var *DT0_num) {//OK
	double temp = 0;
	if (DT0_num->ad == OFF) {
		temp = 0;
	} else {
		temp = (DT0_num->in - DT0_num->temp1) * DT0_num->ad;
	}
	DT0_num->temp1 = DT0_num->in;
	return temp;
}

double IT0 (IT0_var *IT0_num) {//OK
	double temp = 0;
	if (IT0_num->in > IT0_num->max) {
		IT0_num->in = IT0_num->max;
	} else if (IT0_num->in < IT0_num->min) {
		IT0_num->in = IT0_num->min;
	}
	IT0_num->temp1 += IT0_num->in;
	if (IT0_num->temp1 > IT0_num->max) {
		IT0_num->max = IT0_num->max;
	} else if (IT0_num->temp1 < IT0_num->min) {
		IT0_num->min = IT0_num->min;
 	}
	if (IT0_num->ai == OFF) {
		temp = 0;
	} else {
		temp = IT0_num->temp1 * IT0_num->ai;
	}
	return temp;
}


double IT1 (IT0_var *IT0_num,  T1_var *T1_num) {//OK
	T1_num->in = IT0(IT0_num);
	return T1(T1_num);
}

double DT1 (DT0_var *DT0_num,  T1_var *T1_num) {
	T1_num->in = DT0(DT0_num);
	return T1(T1_num);
}

double IT2 (IT0_var *IT0_num, T2_var *T2_num) {
	T2_num->in = IT0(IT0_num);
	return T2(T2_num);
}

double DT2 (DT0_var *DT0_num,  T2_var *T2_num) {
	T2_num->in = DT0(DT0_num);
	return T2(T2_num);
}

double PT1 (PT0_var *PT0_num,  T1_var *T1_num) {
	T1_num->in = PT0(PT0_num);
	return T1(T1_num);
}

double PT2 (PT0_var *PT0_num,  T2_var *T2_num) {
	T2_num->in = PT0(PT0_num);
	return T2(T2_num);
}

double PIT0 (PT0_var *PT0_num,IT0_var *IT0_num) {
	double temp_p = PT0(PT0_num);
	double temp_i = IT0(IT0_num);
	return temp_p + temp_i;
}

double PIT1 (PT0_var *PT0_num,IT0_var *IT0_num, T1_var *T1_num) {
	double temp_p = PT0(PT0_num);
	double temp_i = IT0(IT0_num);
	T1_num->in = temp_i;
	return T1(T1_num) + temp_p;
}

double PIT2 (PT0_var *PT0_num,IT0_var *IT0_num, T2_var *T2_num) {
	double temp_p = PT0(PT0_num);
	double temp_i = IT0(IT0_num);
	T2_num->in = temp_i;
	return T2(T2_num) + temp_p;
}

double PDT0 (PT0_var *PT0_num,DT0_var *DT0_num) {
	double temp_p = PT0(PT0_num);
	double temp_d = DT0(DT0_num);
	return temp_p + temp_d;
}

double PDT1 (PT0_var *PT0_num,DT0_var *DT0_num, T1_var *T1_num) {
	double temp_p = PT0(PT0_num);
	double temp_d = DT0(DT0_num);
	T1_num->in = temp_d;
	return T1(T1_num) + temp_p;
}

double PDT2 (PT0_var *PT0_num,DT0_var *DT0_num, T2_var *T2_num) {
	double temp_p = PT0(PT0_num);
	double temp_d = DT0(DT0_num);
	T2_num->in =  temp_d;
	return T2(T2_num) + temp_p;
}


double PIT0D0 (PT0_var *PT0_num,IT0_var *IT0_num, DT0_var *DT0_num) {
	double temp_p = PT0(PT0_num);
	double temp_i = IT0(IT0_num);
	double temp_d = DT0(DT0_num);
	return temp_p+temp_i + temp_d;
}

double PIT1DT1 (PT0_var *PT0_num,IT0_var *IT0_num, T1_var *IT1_num, DT0_var *DT0_num, T1_var *DT1_num) {
	double temp_p = PT0(PT0_num);
	double temp_i = IT0(IT0_num);
	double temp_d = DT0(DT0_num);
	IT1_num->in = temp_i;
	DT1_num->in = temp_d;
	return temp_p + T1(DT1_num) + T1(IT1_num);
}
