//#include  <math.h>
#include  <stdlib.h>
#include  "defs.h"
#include  "types.h"
#include  "font.h"
#include  "vga.h"
#include  "vgaasm.h"

extern  VMODE_ST      Mode;

extern BYTE  __flash *FontPtr;

#define ABS(a)   ((a < 0) ? -a : a)
#define SGN(a)   ((a < 0) ? -1 : 1)


//*********************************************************************
void Pixel13H(WORD x, WORD y, BYTE color)
{
//   data  DBLWORD  address;

//   data  BYTE     width = Mode.width;
//   asm {
//   MOV AX,0A000H   //    video memory segment number
//   MOV ES,AX       //    place it in es

//   MOV DX,03C4H
//   MOV AL,2
//   OUT DX,AL
//   INC DX
//     IoPortOutB(0x3C4,0x02);

//   MOV AL,1
//   MOV CX,x
//   AND CX,3
//   SHL AL,CL
//   OUT DX,AL
//     IoPortOutB(0x3C5,1<<((x%256)&3));
     VgaIoWriteIx(0x3C4,((1<<((x%256)&3))<<8)+0x02);
//   XOR DI,DI

// Calculate the Offset
//   mov ax,width  // width
//   mul y         // (Y * width))
//   mov bx,x      // (X + (Y * width))
//   add ax,bx
// Done!

//   ADD DI,AX
//   mov ah,color   //    move the Color into ah
//   mov es:[di],ah //    move the value to the screen
//   }
    VgaMemoryWriteB(0xA00000+(x+(y*Mode.width)),color);
}
//*********************************************************************
void pixel(WORD x, WORD y, BYTE color)
{
   int width = Mode.width;

   if (Mode.mode == MODE13H)
      Pixel13H(x,y,color);
   else if (Mode.attrib & TVU_UNCHAINED) {
//   asm {
//   MOV AX,0A000H   //    video memory segment number
//   MOV ES,AX       //    place it in es

//   MOV DX,03C4H
//   MOV AL,2
//   OUT DX,AL
//   INC DX
//     IoPortOutB(0x3C4,0x02);
//   MOV AL,1
//   MOV CX,x
//   AND CX,3
//   SHL AL,CL
//   OUT DX,AL
//     IoPortOutB(0x3C5,1<<((x%256)&3));
     VgaIoWriteIx(0x3C4,((1<<((x%256)&3))<<8)+0x02);
//   XOR DI,DI

// Calculate the Offset
//   mov ax,width  // width / 4
//   SHR AX,2
//   mul y         // (Y * (width / 4))
//   mov bx,x      // (X / 4) + (Y * (width / 4))
//   shr bx,2
//   add ax,bx
// Done!

//   ADD DI,AX
//   mov ah,color   //    move the Color into ah
//   mov es:[di],ah //    move the value to the screen
//   }
   VgaMemoryWriteB(0xA00000+(x/4)+(y*(width/4)),color);
   }
   else if (Mode.attrib & TVU_PLANAR)
   {
//   asm {
//   MOV AX,0A000H   //    video memory segment number
//   MOV ES,AX       //    place it in es

//   MOV BX,x        //    X Value
//   MOV CX,BX
//   MOV AX,y        //    Y Value
//   MOV SI,80
//   MUL SI
//   SHR BX,3        //    /8
//   ADD AX,BX
//   MOV DI,AX


//   AND CL,7
//   XOR CL,7
//   MOV AH,1



//   SHL AH,CL

//   MOV DX,03CEH
//   MOV AL,8
//   OUT DX,AX
//     IoPortOutB(0x3CE,0x08);
//     IoPortOutB(0x3CF,1<<(((x%256)&7)^7));
//     IoPortOutB(0x3CF,rv);
     VgaIoWriteIx(0x3CE,((1<<(((x%256)&7)^7))<<8)+0x08);
//     IoPortOutB(0x3CF,0x0F);
//   MOV DX,03C4H
//   MOV AH,color
//   MOV AL,2
//   OUT DX,AX
//     IoPortOutB(0x3C4,0x02);
//     IoPortOutB(0x3C5,color);
     VgaIoWriteIx(0x3C4,(color<<8)+0x02);
//   MOV AL,0
//   XCHG ES:[DI],AL
     VgaMemoryReadB(0xA00000+(y*80)+(x>>3));

//   MOV BYTE PTR ES:[DI],0FFh
     VgaMemoryWriteB(0xA00000+(y*80)+(x>>3),0xFF);
//   MOV AX,0F02H
//   OUT DX,AX
//     IoPortOutB(0x3C4,0x02);
//     IoPortOutB(0x3C5,0x0F);
//     VgaIoWriteIx(0x3C4,(0x0F<<8)+0x02);

//   MOV DX,03CEH
//   MOV AX,0FF08h
//   OUT DX,AX
//     IoPortOutB(0x3CE,0x08);
//     IoPortOutB(0x3CF,0xFF);
//     VgaIoWriteIx(0x3CE,(0xFF<<8)+0x08);
   //}
   }
}
//*********************************************************************
void pixel12H(WORD x, WORD y, BYTE color)
{
     VgaIoWriteIx(0x3CE,((1<<(((x%256)&7)^7))<<8)+0x08);
     VgaIoWriteIx(0x3C4,(color<<8)+0x02);
     VgaMemoryReadB(0xA00000+(y*80)+(x>>3));
     VgaMemoryWriteB(0xA00000+(y*80)+(x>>3),0xFF);
}
//*********************************************************************


// This is Bresenham's Line Drawing Algorithm
void drawline(int x1, int y1, int x2, int y2, BYTE col)
{
   int d, x, y, ax, ay,dx, dy;
   signed char sx,sy;

   dx = x2-x1;
   ax = ABS(dx) << 1;
   sx = SGN(dx);
   dy = y2-y1;
   ay = ABS(dy) << 1;
   sy = SGN(dy);

   x = x1;
   y = y1;
   if( ax > ay )
   {
      d = ay - (ax >> 1);
      while( x != x2 )
      {
        pixel( x, y, col );
	      //pixel12H( x, y, col );
  	      if( d >= 0 )
	      {
	         y += sy;
	         d -= ax;
	      }
	      x += sx;
	      d += ay;
      }
   }
   else
   {
      d = ax - (ay >> 1);
      while( y != y2 )
      {
        pixel( x, y, col );
	      //pixel12H( x, y, col );
	      if( d >= 0 )
	      {
	         x += sx;
	         d -= ay;
	      }
	      y += sy;
	      d += ax;
      }
   }
   return;
}
//*********************************************************************
void drawrect(int x1, int y1, int x2, int y2, BYTE color)
{
   drawline(x1,y1,x2,y1,color);
   drawline(x1,y2,x2,y2,color);
   drawline(x1,y1,x1,y2,color);
   drawline(x2,y1,x2,y2+1,color);
}
//*********************************************************************
void hline(int x1, int x2, int y, BYTE color)
{
   do
   {
     pixel(x1++,y,color);
     //pixel12H(x1++,y,color);
   }while(x1<=x2);
   //drawline(x1,y,x2,y,color);
}
//*********************************************************************
void vline(int y1, int y2, int x, BYTE color)
{
   drawline(x,y1,x,y2,color);
}
//*********************************************************************
void fillrect(int x1, int y1, int x2, int y2, BYTE color)
{
   WORD i;

   for (i = y1; i < y2; i++)
      hline(x1,x2,i,color);
}
//*****************************************************************************
void drawellipse(int cx, int cy, int rx, int ry, BYTE color )
{
	/* intermediate terms to speed up loop */

	long t1 = rx*rx, t2 = t1 << 1, t3 = t2 << 1;
	long t4 = ry*ry, t5 = t4 << 1, t6 = t5 << 1;
	long t7 = rx*t5, t8 = t7 << 1, t9 = 0L;

	long d1 = t2 - t7 + (t4 >> 1);	/* error terms */
	long d2 = (t1>>1) - t8 + t5;

	register int x = rx, y = 0;	/* ellipse points */

	while (d2 < 0){			/* til slope = -1 */
		pixel(cx + x, cy + y,color);
		pixel(cx + x, cy - y,color);
		pixel(cx - x, cy + y,color);
		pixel(cx - x, cy - y,color);

		//pixel12H(cx + x, cy + y,color);
		//pixel12H(cx + x, cy - y,color);
		//pixel12H(cx - x, cy + y,color);
		//pixel12H(cx - x, cy - y,color);

		y++;		/* always move up here */
		t9 += t3;
		if (d1 < 0){	/* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		}else{		/* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}
	do{			/* rest of top right quadrant */

		pixel(cx + x, cy + y,color);
		pixel(cx + x, cy - y,color);
		pixel(cx - x, cy + y,color);
		pixel(cx - x, cy - y,color);

		//pixel12H(cx + x, cy + y,color);
		//pixel12H(cx + x, cy - y,color);
		//pixel12H(cx - x, cy + y,color);
		//pixel12H(cx - x, cy - y,color);

		x--;		/* always move left here */
		t8 -= t6;
		if (d2 < 0){	/* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		}else		/* move straight left */
			d2 += t5 - t8;
	}while (x >= 0);
}

//*****************************************************************************
void drawellipsefilled(int cx, int cy, int rx, int ry, BYTE color )
{
	/* intermediate terms to speed up loop */

	long t1 = rx*rx, t2 = t1 << 1, t3 = t2 << 1;
	long t4 = ry*ry, t5 = t4 << 1, t6 = t5 << 1;
	long t7 = rx*t5, t8 = t7 << 1, t9 = 0L;

	long d1 = t2 - t7 + (t4 >> 1);	/* error terms */
	long d2 = (t1>>1) - t8 + t5;

	register int x = rx, y = 0;	/* ellipse points */

	while (d2 < 0){			/* til slope = -1 */
//		pixel(cx + x, cy + y,color);
    hline(cx - x, cx + x, cy + y,color);
//		pixel(cx + x, cy - y,color);
    hline(cx - x, cx + x, cy - y,color);
//		pixel(cx - x, cy + y,color);
//		pixel(cx - x, cy - y,color);

		y++;		/* always move up here */
		t9 += t3;
		if (d1 < 0){	/* move straight up */
			d1 += t9 + t2;
			d2 += t9;
		}else{		/* move up and left */
			x--;
			t8 -= t6;
			d1 += t9 + t2 - t8;
			d2 += t9 + t5 - t8;
		}
	}

	do{			/* rest of top right quadrant */
//		pixel(cx + x, cy + y,color);
    hline(cx - x, cx + x, cy + y,color);
//		pixel(cx + x, cy - y,color);
    hline(cx - x, cx + x, cy - y,color);
//		pixel(cx - x, cy + y,color);
//		pixel(cx - x, cy - y,color);

		x--;		/* always move left here */
		t8 -= t6;
		if (d2 < 0){	/* move up and left */
			y++;
			t9 += t3;
			d2 += t9 + t5 - t8;
		}else		/* move straight left */
			d2 += t5 - t8;
	}while (x >= 0);
}
//*****************************************************************************
void  DrawCircle(WORD x, WORD y, WORD rad,BYTE color)
{
  long  Hiba;   //hiba valtozo
  long  X;
  long  Y;
  long  DU;     // hiba modosito, ha csak X lepett
  long  DD;      //hiba modosito, ha X es Y is lepett

  Hiba = 1L - rad;
  X = 0;
  Y = (long)rad;
  DU = 3L;
  DD = 5L - (2L * rad);

  // kezdopont kirajzol
  pixel(X+x,Y+y,color);
  //pixel12H(X+x,Y+y,color);

//  KorCikkInterpolal:

//  DoEvents

//  'Vege a 90 foktol 45 fokigtarto resznek?
  while(!(X > Y))
  {
    //'x mindig lep
    X = X + 1;
    if(Hiba < 0)
    {
      //az x-heztartozo felso y a jobb
      //azaz az aktualison marad
      Hiba = Hiba + DU;
      DU = DU + 2;
      DD = DD + 2;
    }
    else
    {
      //az x-heztartozo also y a jobb
      //azzaz y mar lephet egyet lefele
      Y = Y - 1;
      Hiba = Hiba + DD;
      DU = DU + 2;
      DD = DD + 4;
    }
    //aktualis kirajzol
    pixel(X+x, Y+y,color);
    //pixel12H(X+x, Y+y,color);
  }
}
//*****************************************************************************
void  PutChar12h(BYTE x, WORD y, char cha, BYTE FColor,BYTE BColor)
{
  DBLWORD SegA000;
  BYTE    i,lim=*FontPtr,ah;
  WORD    o=(cha*lim)+1;  // Fontsize skip (+1)

//  mov     dx,03ceh    {Graphics Controller}
//  mov     ax,0205h    {Mode Register, Write Mode 2}
  VgaIoWriteIx(0x3CE,0x0205);
//  mov   ax,0ff08h
//  mov   dx,3ceh
  VgaIoWriteIx(0x3C4,0x0F02);
//asm
//  push  ds
//  mov   ax,_FontSeg
//  mov   ds,ax
//  mov   si,_FontOfs

//  xor   ax,ax
//  mov   al,[cha]
//  mul   _FontH
//  add   si,ax

//  mov   ax,SegA000      {Calculate Offset}
//  mov   es,ax
//  mov   di,[y]
//  mov   ax,di
//  shl   ax,6
//  shl   di,4
//  add   di,ax
//  add   di,[x]

  SegA000 = 0xA00000+(y<<4)+(y<<6)+x;

//  xor   cx,cx
//  mov   cl,_FontH

//  mov   dx,03ceh
//  mov   al,8
//  mov   bh,[FColor]
//  mov   bl,[BColor]
//@D_L:
//  mov   ah,[ds:si] font load
//  out   dx,ax
//  mov   ch,[es:di]
//  mov   [es:di],bh  SegA000 pointer

//  xor   ah,0FFh
//  out   dx,ax
//  mov   ch,[es:di]
//  mov   [es:di],bl  SegA000 pointer

//  inc   si
//  add   di,80
//  dec   cl
//  jnz   @D_L
//  pop   ds
  IoPortOutB(0x3CE,0x08);
  for(i=0;i<lim;i++)
  {
    ah = FontPtr[o+i];
//    VgaIoWriteIx(0x3CE,(ah<<8)+0x08);
    IoPortOutB(0x3CF,ah);
    VgaMemoryReadB(SegA000);
    VgaMemoryWriteB(SegA000,FColor);
    ah ^= 0xFF;
    IoPortOutB(0x3CF,ah);
//    VgaIoWriteIx(0x3CE,(ah<<8)+0x08);
    VgaMemoryReadB(SegA000);
    VgaMemoryWriteB(SegA000,BColor);
    SegA000 += 80;
  }
}
//*****************************************************************************
void  PutString12h(BYTE x, WORD y,char __farflash *str, BYTE FColor, BYTE BColor)
{
  do
  {
    PutChar12h(x++, y,*str++,FColor,BColor);
  }while(*str);
}
//*****************************************************************************
