#include <stdio.h>
#include <pgmspace.h>
#include <ina90.h>
#include <string.h>
#include "defs.h"
#include "config.h"
#include "types.h"
#include "timer.h"
#include "vga.h"
#include "modes.h"
#include "clear.h"
#include "txtrtne.h"
#include "debug.h"
#include "vgaasm.h"
#include "tests.h"
#include "palette.h"
#include "kb.h"
#include "uart2.h"
#include "menu.h"
#include "ata.h"
#include "graphics.h"
#include "recept.h"


//*********************************************************************
//  RTG
//    MISC_ADDR register Bit 2-3 Clock select result:
//
//    Mode is 01H  40x25  Text Clock divder(0x3CE.0x0B) is 1:2
//
//    VgaPortOut(0x03C2,(0x67&0xF3));         Bits value: 0 (00)
//      Horizontal freq.   27.83 kHz
//      Vertikal   freq.   61.98  Hz
//
//    VgaPortOut(0x03C2,(0x67&0xF3)|(1<<2));  Bits value: 1 (01) Default
//      Horizontal freq.   31.56 kHz
//      Vertikal   freq.   70.29  Hz
//
//    VgaPortOut(0x03C2,(0x67&0xF3)|(2<<2));  Bits value: 2 (10)
//      Horizontal freq.   24.85 kHz
//      Vertikal   freq.   55.34  Hz
//
//    VgaPortOut(0x03C2,(0x67&0xF3)|(3<<2));  Bits value: 3 (11)
//      Horizontal freq.   40.26 kHz
//      Vertikal   freq.   89.66  Hz
//
//
//*********************************************************************
// rtvga
// If write 0x00 to 0x03C4.0x10 can't writeable the 0x03C4.0x0E
//
//                  0x03C4.0x11 not give locked state
//                  other not tested currently
//
// If 0x3C4.0x0E bit5 set then 0x03C4.0x0C enter locked state
// If 0x3C4.0x0E Oldmode bit7 set then 0x3C4.0x07 reg changeable
//*********************************************************************
extern DYEING_PROG_ST  DyeingProg;
unsigned char _FF_buff[512];
extern   VMODE_ST Mode;

extern void   ModeSet(BYTE __flash *dataptr);
extern        __flash  BYTE mode00h[];
extern        __farflash MENU_PROP_ST MainMenu;
extern void   getch(void);
extern void   Fdemo(void);

__farflash const char __farflash* ChpMsg[]=
{
  "Unknown","RTG3103","RTG3105","RTG3105iEH",
  "RTG3106","TR8800BR","TR8800CS","TR8900",
  "TR8900C","TR9000","TR8900CLD","TR9000i",
  "TR8900CXr","LCD9100B","LX8200","TVGA9400CXi",
  "LCD9320","GUI9420","TVGA8800BR","OAK_037C",
  "OAK_057","OAK_067","OAK_077","OAK_083",
  "OAK_087","CL_GD5402","CL_GD5402R1","CL_GD5420",
  "CL_GD5420R1","CL_GD5422","CL_GD5426","CL_GD5424",
  "CL_GD5428","CL_GD5430","CL_GD5434","CL_GD6205",
  "CL_GD6235","CL_GD6215","CL_GD6225","AVGA2_5402"
};



CHIP_TYPE_EN    ChipType;
PREDIR_EN       PutRedirection = VGA_TEXT;
GREDIR_EN       GetRedirection = PS2_KEYB;

         BYTE   CursorRow = 0;
         BYTE   CursorCol = 0;
static   BYTE   HTab      = 8;
         DBLWORD VidMemBase = 0xB08000;
//*********************************************************************

void  ComputeTextCoord(WORD pos)
{
  CursorRow = (pos/Mode.width)+1;
  CursorCol = (pos%Mode.width)+1;
}
//*********************************************************************
int PutcharVga(int c)
{
static  BYTE  ColorFlag;

  if (!ColorFlag)
  {
    if (c == 0x05)
    {
      ColorFlag = 1;
    }
    else  if (c == '\n')
    {
      CursorScreen += Mode.width;
      CursorScreen -= CursorScreen%Mode.width;
      ComputeTextCoord(CursorScreen);
    }
    else  if (c == '\r')
    {
      CursorScreen -= CursorScreen%Mode.width;
      ComputeTextCoord(CursorScreen);
    }
    else if (c == '\f')
    {
      TextClear(CurrentAttrib);
      CursorScreen = 0;
      SetHwCursor(CursorScreen);
      ComputeTextCoord(CursorScreen);
    }
    else if (c == '\t')
    {
      CursorScreen += HTab-(CursorCol%HTab);
      ComputeTextCoord(CursorScreen);
    }
    else
    {
      if(c == '\b')
      {
        CursorScreen--;
        c=0x20;
        VgaMemoryWriteW(VidMemBase+CursorScreen*2,(CurrentAttrib<<8)+c);
      }
      else
      {
//      VgaMemoryWriteB(VidMemBase+CursorScreen*2,c);
//      VgaMemoryWriteB(VidMemBase+1+CursorScreen*2,CurrentAttrib);
        VgaMemoryWriteW(VidMemBase+CursorScreen*2,(CurrentAttrib<<8)+c);
        CursorScreen++;
      }
      ComputeTextCoord(CursorScreen);
    }
    if (CursorScreen >= Mode.width*Mode.height)
    {
      CursorScreen--;
      TextLineScrllUp();
      CursorScreen -= CursorScreen%Mode.width;
      ComputeTextCoord(CursorScreen);
    }
    SetHwCursor(CursorScreen);
  }
  else
  {
    SetColor(c);
    ColorFlag = 0;
  }
  return(c);
}

//*********************************************************************

int putchar(c)
{
  if(!PutRedirection)
  {
    uart1SendByte((BYTE)c);
  }
  else PutcharVga(c);
  return(c);
}

//*********************************************************************

int getchar(void)
{
  if(GetRedirection)              // If redirection = 1
  {
    return(GetCharKb());          // then get the keyboard
  }
  else return(uart1GetByte());    // else get from uart1
}
//*********************************************************************
void  AtaView(void)
{
  ataDriveSelect(0);
  ataDriveInit(_FF_buff);
  ataShowRegisters(0);
  getch();
  Fdemo();
  getch();
}
//*********************************************************************
void  IdePortTest(void)
{
  WORD  readval;

  do
  {
    readval = ~IoPortInW(0x1F0);
    Gotoxy(2,2);
    printf_P("0x1F0 = %0x   ",readval);

    readval = ~IoPortInW(0x1F1);
    Gotoxy(2,3);
    printf_P("0x1F1 = %0x   ",readval);

    readval = ~IoPortInW(0x1F2);
    Gotoxy(2,4);
    printf_P("0x1F2 = %0x   ",readval);

    readval = ~IoPortInW(0x1F3);
    Gotoxy(2,5);
    printf_P("0x1F3 = %0x   ",readval);

    readval = ~IoPortInW(0x1F4);
    Gotoxy(2,6);
    printf_P("0x1F4 = %0x   ",readval);

    readval = ~IoPortInW(0x1F5);
    Gotoxy(2,7);
    printf_P("0x1F5 = %0x   ",readval);

    readval = ~IoPortInW(0x1F6);
    Gotoxy(2,8);
    printf_P("0x1F6 = %0x   ",readval);

    readval = ~IoPortInW(0x1F7);
    Gotoxy(2,9);
    printf_P("0x1F7 = %0x   ",readval);


    readval = ~IoPortInW(0x3F6);
    Gotoxy(2,11);
    printf_P("0x3F6 = %0x   ",readval);

    readval = ~IoPortInW(0x3F7);
    Gotoxy(2,12);
    printf_P("0x3F7 = %0x   ",readval);

  }while((getchar())!=ESCAPE);
}
//*********************************************************************
void  main(void)
{
  BYTE  rv;
    				
	// initialize ports
  PORTA = 0xFF;                     // ISA BUS data port and address latch A0..A7
  DDRA  = 0x00;                     // Default is input (Bidirectional)

  // PORTB.0  = PS2 DATA                          Input                                     High
  // PORTB.1  = ISA BALE                          Output (alternate func. RS232 CTS input)  Low
  // PORTB.2  = ADDRESS decoder RAM/FLASH select  Output                                    Low (Ram)
  // PORTB.3  = ISA SBHE                          Output                                    High
  // PORTB.4  = ISA IORD                          Output                                    High
  // PORTB.5  = ISA IOWR                          Output                                    High
  // PORTB.6  = ISA MEMRD                         Output                                    High
  // PORTB.7  = ISA MEMWR                         Output                                    High

  PORTB = 0xF9;
  DDRB  = 0xFE;

  PORTC = 0x00;                     //  ISA bus Address middle  A8..A15
  DDRC  = 0xFF;                     //  Allways output (except 16 bit mode DATA high)

  PORTD = 0x00;                     // ISA bus address high 4 bit  A16..A19
  DDRD =  0xF0;				              // ISA bus address <7:4>, <3:0> TWI & USART1

  // PORTE.0  = RS485 RX pin (SPI MOSI)           Input                                     Low
  // PORTE.1  = RS485 TX pin (SPI MISO)           Output                                    High
  // PORTE.2  = ISA IOCHRDY                       Input                                     Low
  // PORTE.3  = ISA IRQ9                          Input                                     Low
  // PORTE.4  = PS2 CLOCK                         Input                                     Low
  // PORTE.5  = ISA IRQ4                          Input                                     Low
  // PORTE.6  = ISA MEMCS16                       Input                                     Low
  // PORTE.7  = ISA IOCS16                        Input                                     Low

  PORTE = 0x02;
  DDRE  = 0x02;

  PORTF = 0xFF;
  DDRF  = 0x00;                     // Bit <4:7> JTAG used, bit <3:0> switch & LCD used then Input

  // PORTG.0  = ExtMem control line WR            Output                                    High
  // PORTG.1  = ExtMem control line RD            Output                                    High
  // PORTG.2  = ExtMem control line ALE           Output                                    Low
  // PORTG.3  = ISA RESET                         Output                                    Low
  // PORTG.4  = RS485 direction                   Output                                    Low (RX)

  PORTG = 0x03;
  DDRG  = 0x1F;

  init_kb();
  uart1Init();
  _SEI();
//    TRSubsEnable();
//    DumpIoRegs();
  ChipType = VgaInit();
//    while(1)
//    {
//      key = Remote();
//      if(key == '1') ModeSet(mode00h);
//    }
  SetVideoMode(MODE03H);
  TextClear(0x0F);
  ComputeTextCoord(68);
  ComputeTextCoord(80);
  ComputeTextCoord(79);
  ComputeTextCoord(81);
  do
  {
    rv = ExeMenu(0);
    if (rv == 1)
    {
      TauronTests();
    }
    else if (rv == 2)
    {
      TextClear(0x0F);
      ShowProg();
      getch();
      TextClear(0x0F);
    }
    else if (rv == 3)
    {
      TextClear(0x0F);
      AtaView();
      TextClear(0x0F);
    }
    else if (rv == 4)
    {
      TextClear(0x0F);
      IdePortTest();
      TextClear(0x0F);
    }
  }while(1);
}
