#ifndef DEFS_H
#define DEFS_H


#define mysprintf_P(vardest, formatstr,...) \
                   {__farflash static const char __formatstr[]=formatstr; \
                   sprintf_P(vardest, __formatstr, __VA_ARGS__);}
#define myprintf_P(formatstr,...) \
                   {__farflash static const char __formatstr[]=formatstr; \
                   printf_P(__formatstr, __VA_ARGS__);}
#define myprintf_PSTR(formatstr) \
                   {__farflash static const char __formatstr[]=formatstr; \
                   printf_P(__formatstr);}
#define BOOL  bit
#define TRUE   1
#define FALSE  0

#define ENABLE_INTERRUPTS()   (EA = 1)
#define DISABLE_INTERRUPTS()  (EA = 0)

#define  WDT_INTERVAL         (7)     // must be 0-7

#define  WDTSetInterval(a)    (WDTCN = (WDTCN & 0x07)|(a & 0x07))
#define  WDTReset()           (WDTCN = 0xA5)
#define  WDTLockout()         (WDTCN = 0xFF))
#define  WDTDisable()         (EA=0);(WDTCN = 0xDE);(WDTCN = 0xAD);(EA = 1)
#define  WDTStatus()          (if(WDT)&0x10)

// VGA register port addresses
#define ATTRCON_ADDR			0x03C0
#define MISC_ADDR         0x03C2
#define VGAENABLE_ADDR    0x03C3
#define SEQ_ADDR          0x03C4
#define GRACON_ADDR       0x03CE
#define CRTC_ADDR         0x03D4
#define STATUS_ADDR       0x03DA

// Video mode numbers
#define MODE00H						0x00
#define MODE01H						0x00
#define MODE02H						0x03
#define MODE03H						0x03
#define MODE04H						0x04
#define MODE05H						0x05
#define MODE06H						0x06
#define MODE07H						0x07
#define MODE0DH						0x0D
#define MODE0EH						0x0E
#define MODE0FH						0x0F
#define MODE10H						0x10
#define MODE11H						0x11
#define MODE12H						0x12
#define MODE13H						0x13
#define CHAIN4						0x14
#define MODE_X						0x15
#define MODE_A						0x16
#define MODE_B						0x17
#define MODE_C						0x18
#define MODE_D						0x19
#define MODE_E						0x1A
#define MODE_F						0x1B
#define MODE_G						0x1C
#define MODE_H						0x1D
#define MODE_I						0x1E
#define MODE_J						0x1F
#define MODE_K						0x20
#define MODE_L						0x21
#define MODE_M						0x22
#define MODE10AH          0x23

// Keypresses
#define ESCAPE						0x001B
#define ENTERKEY          0x000D

// Videomode attributes
#define TVU_TEXT					0x0001
#define TVU_GRAPHICS			0x0002
#define TVU_MONOCHROME		0x0004
#define TVU_PLANAR				0x0008
#define TVU_UNCHAINED			0x0010

// Text color codes
// For backround then use Color*16, Color<<4
#define BLACK             0x00
#define BLUE              0x01
#define GREEN             0x02
#define CYAN              0x03
#define RED               0x04
#define MAGNETA           0x05
#define BROWN             0x06
#define WHITE             0x07
#define GRAY              0x08
#define LBLUE             0x09
#define LGREEN            0x0A
#define LCYAN             0x0B
#define LRED              0x0C
#define LMAGNETA          0x0D
#define YELLOW            0x0E
#define BRWHITE           0x0F

#endif
