#include <stdio.h>
#include <stdlib.h>
#include <pgmspace.h>
#include <ina90.h>
#include <string.h>
#include <ctype.h>
#include "defs.h"
#include "config.h"
#include "types.h"
//#include "timer.h"
#include "vga.h"
//#include "modes.h"
//#include "clear.h"
#include "debug.h"
#include "vgaasm.h"
//#include "tests.h"
//#include "palette.h"
#include "kb.h"
#include "uart2.h"

extern   VMODE_ST Mode;
extern   DBLWORD  VidMemBase;

extern void SetColor(BYTE att);
extern void CursorOff(void);
extern void Gotoxy(BYTE x, BYTE y);

__flash BOX_CHARS BxChArr[4]=
{
  218,196,191,179,192,217,195,196,
  180,194,179,193,

  201, // TopLeftChar;
  205, // HorizontalChar;
  187, // TopRightChar;
  186, // VerticalChar;
  200, // BotLeftChar;
  188, // BotRightChar;
  204, // HseparLeftChar;
  205, // HseparatorChar;
  185, // HseparRightChar;
  203, // VseparTopChar;
  186, // VseparatorChar;
  202, // VseparBotChar;

  213, // TopLeftChar;
  205, // HorizontalChar;
  184, // TopRightChar;
  179, // VerticalChar;
  212, // BotLeftChar;
  190, // BotRightChar;
  198, // HseparLeftChar;
  205, // HseparatorChar;
  181, // HseparRightChar;
  209, // VseparTopChar;
  179, // VseparatorChar;
  207, // VseparBotChar;

  214, // TopLeftChar;
  196, // HorizontalChar;
  183, // TopRightChar;
  186, // VerticalChar;
  211, // BotLeftChar;
  189, // BotRightChar;
  199, // HseparLeftChar;
  196, // HseparatorChar;
  182, // HseparRightChar;
  194, // VseparTopChar;
  179, // VseparatorChar;
  193, // VseparBotChar;

};

__farflash MENU_ITEMS_ST Items0[]=
{
  "Tauron tests",'t',
  "Receptek",'v',
  "ATA view",'a',
  "IDE port tests",'i',
  "Exit",'e',
};
#define ITMNBR0   sizeof(Items0)/sizeof(MENU_ITEMS_ST)
//#define ITMWDTH0  sizeof(*(Items0[0].Text))

__farflash MENU_PROP_ST  MainMenu =
{
  3,                          // TopLeftX;
  3,                          // TopLeftY;
  26,                         // Width;
  ITMNBR0+1,                  // Height;
  "FOMENU",                   // const char __farflash *Name;
  0x0F,                       // NameColor;
  0,                          // BoxSetIx;
  (GRAY*16)+YELLOW,           // BoxColor;
  (GRAY*16)+BRWHITE,          // AreaColor;
  (WHITE*16)+BLACK,           // SelectorColor;  // Combined color (back<<8)+fore
  ITMNBR0,
  Items0        // MENU_ITEMS_ST __farflash* Items ;
};
__farflash MENU_ITEMS_ST Items1[]=
{
  "Festsi programok Festsi programok Festsi programok",'f',
  "Bellts Bellts Bellts Bellts Bellts Bellts",'b',
  "Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats",'n',
  "Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz",'s',
  "Festsi programok Festsi programok Festsi programok",'f',
  "Bellts Bellts Bellts Bellts Bellts Bellts",'b',
  "Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats",'n',
  "Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz",'s',
  "Festsi programok Festsi programok Festsi programok",'f',
  "Bellts Bellts Bellts Bellts Bellts Bellts",'b',
  "Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats Nyomtats",'n',
  "Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz Szerviz",'s'
};
#define ITMNBR1   sizeof(Items1)/sizeof(MENU_ITEMS_ST)

__farflash MENU_PROP_ST  SecMenu =
{
  5,                          // TopLeftX;
  6,                          // TopLeftY;
  65,                         // Width;
  ITMNBR1+1,                  // Height;
  "Second Menu",              // const char __farflash *Name;
  0x0F,                       // NameColor;
  2,                          // BoxSetIx;
  (BLUE*16)+YELLOW,           // BoxColor;
  (BLUE*16)+BRWHITE,          // AreaColor;
  (BRWHITE*16)+BLACK,         // SelectorColor;  // Combined color (back<<8)+fore
  ITMNBR1,
  Items1        // MENU_ITEMS_ST __farflash* Items ;
};
BYTE  LastHighL = 0;

__farflash MENU_PROP_ST __farflash *MenuIndex[] =
{
  &MainMenu,
  &SecMenu
};


//*********************************************************************
BYTE  IncLowNible(BYTE col)
{
  BYTE  tmp;

  tmp  = col&0xF0;
  col++;
  col &= 0x0F;
  return(col|tmp);
}
//*********************************************************************
BYTE  IncHighNible(BYTE col)
{
  BYTE  tmp;

  tmp =  col&0x0F;
  col += 16;
  col &= 0xF0;
  return(col|tmp);
}
//*********************************************************************
BYTE SelectMenu(MENU_PROP_ST __generic *menupr,BYTE HighLight)
{
  BYTE        i,hd=0;
  WORD        address;

  if(menupr->Name != NULL) hd=2;
  if (((signed char)HighLight) < 0) HighLight = 0;
  if (HighLight >= menupr->ItemNbr) HighLight = menupr->ItemNbr-1;
  if(LastHighL != HighLight)
  {
    address = ((menupr->TopLeftY+hd+LastHighL)*Mode.width*2)+((menupr->TopLeftX)*2)+1;
    for(i=0;i<menupr->Width;i++)
    {
      VgaMemoryWriteB(VidMemBase+address+(i<<1),menupr->AreaColor);
    }
  }
  address = ((menupr->TopLeftY+hd+HighLight)*Mode.width*2)+((menupr->TopLeftX)*2)+1;
  for(i=0;i<menupr->Width;i++)
  {
    VgaMemoryWriteB(VidMemBase+address+(i<<1),menupr->SelectorColor);
  }
  return(LastHighL = HighLight);
}
//*********************************************************************
BYTE StrLen(const char __farflash *ptr)
{
  BYTE  len = 0;
  while(ptr[len++]);
  return(len-1);
}
//*********************************************************************
void  ClearBoxIn(MENU_PROP_ST __generic *menupr)

{
  register BYTE w,h,x,y,wlim,hlim;

  hlim = menupr->Height-1;
  wlim = menupr->Width;
  x = menupr->TopLeftX;
  y = menupr->TopLeftY;

  if(menupr->Name != NULL)hlim += 2;
  SetColor(menupr->AreaColor);
  for(h=0;h<hlim;h++)
  {
    Gotoxy(x+1,y+1+h);
    for(w=0;w<wlim;w++) putchar(' ');
  }
}
//*********************************************************************
void TextBox(MENU_PROP_ST __generic *menupr)
{
  register BYTE  i,x,y,wlim,hlim,hd=0;

  x = menupr->TopLeftX;
  y = menupr->TopLeftY;
  wlim = menupr->Width;
  hlim = menupr->Height-1;

  SetColor(menupr->BoxColor);
  Gotoxy(x,y);
  putchar(BxChArr[menupr->BoxSetIx].TopLeftChar);
  for(i=0;i<wlim;i++) putchar(BxChArr[menupr->BoxSetIx].HorizontalChar);
  putchar(BxChArr[menupr->BoxSetIx].TopRightChar);
  if(menupr->Name != NULL)
  {
    hd = 2;
    Gotoxy(x,y+1);
    putchar(BxChArr[menupr->BoxSetIx].VerticalChar);
    Gotoxy(x+wlim+1,y+1);
    putchar(BxChArr[menupr->BoxSetIx].VerticalChar);
    Gotoxy(x,y+2);
    putchar(BxChArr[menupr->BoxSetIx].HseparLeftChar);
    for(i=0;i<wlim;i++) putchar(BxChArr[menupr->BoxSetIx].HseparatorChar);
    putchar(BxChArr[menupr->BoxSetIx].HseparRightChar);
  }
  for(i=0;i<hlim;i++)
  {
    Gotoxy(x,y+i+hd+1);
    putchar(BxChArr[menupr->BoxSetIx].VerticalChar);
    Gotoxy(x+wlim+1,y+i+hd+1);
    putchar(BxChArr[menupr->BoxSetIx].VerticalChar);
  }
  Gotoxy(x,y+hlim+hd+1);
  putchar(BxChArr[menupr->BoxSetIx].BotLeftChar);
  for(i=0;i<wlim;i++) putchar(BxChArr[menupr->BoxSetIx].HorizontalChar);
  putchar(BxChArr[menupr->BoxSetIx].BotRightChar);
}
//*********************************************************************
void  DrawMenu(MENU_PROP_ST __generic *menupr)
{
  register BYTE i,itnbr,x,y,hd=0;

//  do
//  {
//    if((tmp=StrLen(ptr[i])) > len) len = tmp;
//    i++;
//  }while(ptr[i]!= NULL);
  itnbr = menupr->ItemNbr;
  x = menupr->TopLeftX+2;
  y = menupr->TopLeftY+1;
  CursorOff();
  ClearBoxIn(menupr);
  if(menupr->Name != NULL)  // If menu name exist
  {
    hd = 2;                 // Header offset set
    Gotoxy(x-1+(menupr->Width-StrLen(menupr->Name))/2,y);
    printf_P(menupr->Name);
    SetColor(menupr->AreaColor);
  }
  for(i=0;i<itnbr;i++)
  {
    Gotoxy(x,y+i+hd);
  printf_P(menupr->Items[i].Text);
  }
  TextBox(menupr);
  SelectMenu(menupr,0);
}
//*********************************************************************
BYTE  ExeMenu(BYTE ix)
{
  int                   c;
  BYTE                   x,y,j=0;
  MENU_PROP_ST __generic *ptr;	


  ptr = (MENU_PROP_ST __generic*)malloc(sizeof(MENU_PROP_ST));
  // *(MENU_PROP_ST __generic*)ptr = *((MENU_PROP_ST __generic*)(&MainMenu));
  *ptr = *(MenuIndex[ix]);
  DrawMenu(ptr);
  do
  {
    c= getchar();
    switch(c)
    {
    case '1': case 0xE072:
      j++;
      j = SelectMenu(ptr,j);
      break;
    case '2':  case 0xE075:
      j--;
      j = SelectMenu(ptr,j);
      break;
    case 'a':
      ptr->AreaColor = IncLowNible(ptr->AreaColor);
      DrawMenu(ptr);
      break;
    case 'A':
      ptr->AreaColor = IncHighNible(ptr->AreaColor);
      x = ptr->AreaColor&0xF0;
      y = ptr->BoxColor&0x0F;
      ptr->BoxColor = x|y;
      DrawMenu(ptr);
      break;
    case 'b':
      ptr->BoxSetIx++;
      ptr->BoxSetIx &= 0x03;
      DrawMenu(ptr);
      break;
    case ENTERKEY:
      free((void *)ptr);
      return(j+1);
    }
  }while(c!=ESCAPE);
  free((void *)ptr);
  return(0);
}
