;*********************************************************************
; Vga low-level ISA bus function
;*********************************************************************
#include "iom128.h"

        NAME    VGAASM

;*********************************************************************
;  BYTE  VgaMemoryWiteB(register DBLWORD addr, BYTE val)
;
;  Parameter addr is R16,R17,R18,R19 (R19-MSB...R16-LSB)
;  Parameter Val  is R20
;
;
;*********************************************************************
        PUBLIC  VgaMemoryWriteB

        RSEG  CODE:CODE

VgaMemoryWriteB:
;  void  VgaMemoryWriteB(register DBLWORD addr,register BYTE val)

;       ADDRESS_HIGH = (addr>>16)&0xF0 ;    // AddressHigh
        ANDI      R18,$F0
        OUT       PORTD,R18                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R19,$FF
        OUT       DDRA,R19
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       ADDRESS_LOW = val;                  // Place the data to BUS low
        OUT       PORTA,R20                 ;  second parametre place to the port
;       MEMORY_WRITE = 0;                   // Write to addressed memory
        CBI       PORTB,7
        NOP
        NOP
;       NOP
;       while(!IO_CH_READY);
LOOP1:
        SBIS      PINE,2
        RJMP      LOOP1
;       MEMORY_WRITE = 1;
        SBI       PORTB,7
;       DDRA = 0x00;                        // ADDRESS_LOW is input
        LDI      R19,$00
        OUT      DDRA,R19
        RET

;*********************************************************************
;  BYTE  VgaMemoryWiteW(register DBLWORD addr, WORD val)
;
;  Parameter addr is R16,R17,R18,R19 (R19-MSB...R16-LSB)
;  Parameter Val  is R20 L,R21 H
;
;
;*********************************************************************

        PUBLIC  VgaMemoryWriteW

        RSEG  CODE:CODE

VgaMemoryWriteW:
;  void  VgaMemoryWriteW(register DBLWORD addr,register WORD val)

;       ADDRESS_HIGH = (addr>>16)&0xF0 ;    // AddressHigh
        ANDI      R18,$F0
        OUT       PORTD,R18                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R19,$FF
        OUT       DDRA,R19
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       ADDRESS_LOW = val%256;              // Place the data to BUS low
        OUT       PORTA,R20                 ;  second parametre place to the port
;       MEMORY_WRITE = 0;                   // Write to addressed memory
        CBI       PORTB,7
        NOP
        NOP
;       while(!IO_CH_READY);
LOOP2:
        SBIS      PINE,2
        RJMP      LOOP2
;       MEMORY_WRITE = 1;
        SBI       PORTB,7

;       Next the High Byte

        LDI       R19,$01                   //
        ADD       R16,R19                   // Increment the LSB
        DEC       R19                       //
        ADC       R17,R19                   // Add carry
        ADC       R18,R19                   // Add carry
        OUT       PORTD,R18                 ;  Move to port
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       ADDRESS_LOW = val/256;              // Place the data to BUS low
        OUT       PORTA,R21                 ;  second parameter place to the port
;       MEMORY_WRITE = 0;                   // Write to addressed memory
        CBI       PORTB,7
        NOP
        NOP
;       while(!IO_CH_READY);
LOOP3:
        SBIS      PINE,2
        RJMP      LOOP3
;       MEMORY_WRITE = 1;
        SBI       PORTB,7
;       DDRA = 0x00;                        // ADDRESS_LOW is input
        LDI      R19,$00
        OUT      DDRA,R19
        RET

;*********************************************************************
;  BYTE  VgaMemoryReadB(register DBLWORD addr)
;
;  Parameter addr is R16,R17,R18,R19 (R19-MSB...R16-LSB)
;  Return value is R16
;
;
;*********************************************************************

        PUBLIC  VgaMemoryReadB

        RSEG  CODE:CODE

VgaMemoryReadB:

;       ADDRESS_HIGH = (addr>>16)&0xF0 ;    // AddressHigh
        ANDI      R18,$F0
        OUT       PORTD,R18                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R19,$FF
        OUT       DDRA,R19
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;           // End the latching
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R19,$00
        OUT       DDRA,R19
;       MEMORY_READ = 0;                    // Read from addressed memory
        CBI       PORTB,6
        NOP
        NOP
;       while(!IO_CH_READY);                // Wait while IoChanel not ready
LOOP4:
        SBIS      PINE,2
        RJMP      LOOP4
;       val = ADDRESS_LOW ;                 // Place the data from bus to returnvalue
        IN        R16,PINA
;       MEMORY_READ = 1;                    // End the memory reading
        SBI       PORTB,6
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R17,$FF
        OUT       DDRA,R17
;       return(val);
        RET

;*********************************************************************
;  WORD  VgaMemoryReadW(register DBLWORD addr)
;
;  Parameter addr is R16,R17,R18,R19 (R19-MSB...R16-LSB)
;  Return value is R16 L R17 H
;
;
;*********************************************************************

        PUBLIC  VgaMemoryReadW

        RSEG  CODE:CODE

VgaMemoryReadW:

;       ADDRESS_HIGH = (addr>>16)&0xF0 ;    // AddressHigh
        ANDI      R18,$F0
        OUT       PORTD,R18                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R19,$FF
        OUT       DDRA,R19
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;           // End the latching
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R19,$00
        OUT       DDRA,R19
;       MEMORY_READ = 0;                    // Read from addressed memory
        CBI       PORTB,6
        NOP
        NOP
;       while(!IO_CH_READY);                // Wait while IoChanel not ready
LOOP5:
        SBIS      PINE,2
        RJMP      LOOP5
;       val = ADDRESS_LOW ;                 // Place the data from bus to returnvalue
        IN        R20,PINA
;       MEMORY_READ = 1;                    // End the memory reading
        SBI       PORTB,6

;       Next the high byte

        LDI       R19,$01                   //
        ADD       R16,R19                   // Increment the LSB
        DEC       R19                       //
        ADC       R17,R19                   // Add carry
        ADC       R18,R19                   // Add carry
;       ADDRESS_HIGH = (addr>>16;           // AddressHigh
        OUT       PORTD,R18                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R19,$FF
        OUT       DDRA,R19
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R19,PORTG
        ORI       R19,$04
        STS       PORTG,R19
;       ADDRESS_LATCH_ENABLE = 0;           // End the latching
        ANDI      R19,$FF-$04
        STS       PORTG,R19
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R19,$00
        OUT       DDRA,R19
;       MEMORY_READ = 0;                    // Read from addressed memory
        CBI       PORTB,6
        NOP
        NOP
;       while(!IO_CH_READY);                // Wait while IoChanel not ready
LOOP6:
        SBIS      PINE,2
        RJMP      LOOP6
;       val = (ADDRESS_LOW<<8) ;            // Place the data from bus to returnvalue
        IN        R17,PINA
;       MEMORY_READ = 1;                    // End the memory reading
        SBI       PORTB,6
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R19,$00
        OUT       DDRA,R17
        MOV       R16,R20
;       return(val);
        RET
;*********************************************************************
;  void  VgaIoWriteIx(register WORD addr,register WORD ValIx)
;
;  Parameter addr  is R16,R17 (R17-MSB,R16-LSB)
;  Parameter ValIx is R18,R19 (R19-MSB,R18-LSB)
;  Return value    none
;
;
;*********************************************************************
        PUBLIC   VgaIoWriteIx

        RSEG  CODE:CODE
VgaIoWriteIx:
;       // first byte (High)
;       ADDRESS_HIGH = 0x00;                // Only WORD addressing the IO port
        LDI       R20,$00
        OUT       PORTD,R20                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R20,$FF
        OUT       DDRA,R20
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R20,PORTG
        ORI       R20,$04
        STS       PORTG,R20
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R20,$FF-$04
        STS       PORTG,R20
;       ADDRESS_LOW = Ix;                   // Place the index value to BUS low
        OUT       PORTA,R18                 ;  Index value to the addr. register
;       IO_WRITE = 0;                       // Write to addressed memory
        CBI       PORTB,5
        NOP
        NOP
;       NOP
;       while(!IO_CH_READY);
LOOP7:
        SBIS      PINE,2
        RJMP      LOOP7
;       IO_WRITE = 1;
        SBI       PORTB,5

;       // second byte (low)
        INC       R16
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R20,PORTG
        ORI       R20,$04
        STS       PORTG,R20
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R20,$FF-$04
        STS       PORTG,R20
;       ADDRESS_LOW = Val;                  // Place the data to BUS low
        OUT       PORTA,R19                 ;  Value to the index register
;       IO_WRITE = 0;                       // Write to addressed memory
        CBI       PORTB,5
        NOP
        NOP
;       while(!IO_CH_READY);
LOOP8:
        SBIS      PINE,2
        RJMP      LOOP8
;       IO_WRITE = 1;
        SBI       PORTB,5
;       PRT0CF = 0x00;                      // ADDRESS_LOW is input
        LDI      R20,$FF
        OUT      DDRA,R20
        RET
;*********************************************************************
;  BYTE  VgaIoReadIx(register WORD addr,register BYTE Ix)
;
;  Parameter addr is R16,R17 (R17-MSB,R16-LSB)
;  Parameter Ix   is R18
;  Return value   is R16
;
;
;*********************************************************************
        PUBLIC  VgaIoReadIx

        RSEG  CODE:CODE
VgaIoReadIx:
;       // first byte (High)
;       ADDRESS_HIGH = 0x00;                // Only WORD addressing the IO port
        LDI       R20,$00
        OUT       PORTD,R20                 ;  Move to port
;       DDRA = 0xFF;                        // ADDRESS_LOW is output
        LDI       R20,$FF
        OUT       DDRA,R20
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R20,PORTG
        ORI       R20,$04
        STS       PORTG,R20
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R20,$FF-$04
        STS       PORTG,R20
;       ADDRESS_LOW = Ix;                   // Place the index value to BUS low
        OUT       PORTA,R18                 ;  Index value to the addr. register
;       IO_WRITE = 0;                       // Write to addressed memory
        CBI       PORTB,5
        NOP
        NOP
;       while(!IO_CH_READY);
LOOP9:
        SBIS      PINE,2
        RJMP      LOOP9
;       IO_WRITE = 1;
        SBI       PORTB,5

;       // second byte (low)
        INC       R16
;       ADDRESS_LOW  = addr&0xFF;           // Place the A0..A7 bit to BUS low
        OUT       PORTA,R16
;       ADDRESS_MID = (addr>>8)&0xFF;       // Place the A8..A15 bit to BUS mid
        OUT       PORTC,R17
;       ADDRESS_LATCH_ENABLE = 1;           // Latch the value
        LDS       R20,PORTG
        ORI       R20,$04
        STS       PORTG,R20
;       ADDRESS_LATCH_ENABLE = 0;
        ANDI      R20,$FF-$04
        STS       PORTG,R20
;       DDRA = 0x00;                        // ADDRESS_LOW is input mode
        LDI       R20,$00
        OUT       DDRA,R20
;       IO_READ = 0;                       // Write to addressed memory
        CBI       PORTB,4
        NOP
        NOP
;       while(!IO_CH_READY);
LOOP10:
        SBIS      PINE,2
        RJMP      LOOP10
;       val = ADDRESS_LOW ;                 // Place the data from bus to returnvalue
        IN       R16,PINA
;       IO_READ = 1;
        SBI      PORTB,4
;       DDRA = 0x00;                        // ADDRESS_LOW is input
        LDI      R20,$00
        OUT      DDRA,R20
        RET

        END
