//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=-                                                                         -=
//=-                   Tauron VGA Utilities Version 3.0                      -=
//=-                      Released September 20, 1998                        -=
//=-                                                                         -=
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=- Copyright (c) 1997, 1998 by Jeff Morgan  =-= This code is FREE provided -=
//=- All Rights Reserved.                     =-= that you put my name some- -=
//=-                                          =-= where in your credits.     -=
//=- DISCLAIMER:                              =-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
//=- I assume no responsibility whatsoever for any effect that this package, -=
//=- the information contained therein or the use thereof has on you, your   -=
//=- sanity, computer, spouse, children, pets or anything else related to    -=
//=- you or your existance. No warranty is provided nor implied with this    -=
//=- source code.                                                            -=
//=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=
#include <stdlib.h>
#include <stdio.h>
#include <pgmspace.h>

#include "defs.h"
#include "config.h"
#include "types.h"
#include "clear.h"
#include "txtrtne.h"
#include "modes.h"
#include "vga.h"
#include "vgaasm.h"
#include "font.h"
#include "debug.h"
#include "graphics.h"
//#define  REMOTE_DEBUG     // Uncoment if required

extern  VMODE_ST      Mode;
extern  CHIP_TYPE_EN  ChipType;
extern __farflash const char __farflash* ChpMsg[];

//void GL_DrawArc (int xCenter, int yCenter, int rx, int ry, int a0, int a1);
// xCenter  Horizontal position of the center in pixels of the client window.
// yCenter  Vertical position of the center in pixels of the client window.
// rx  X-radius (pixels).
// ry  Y-radius (pixels).
// a0  Starting angle (degrees).
// a1  Ending angle (degrees).

void GUI_DrawArc (int x0, int y0, int rx, int ry, int a0, int a1) ;
void drawellipse(int cx, int cy, int rx, int ry, BYTE color );


//*********************************************************************
void  SetMode03h(void)
{
    SetVideoMode(MODE03H);
}
//*********************************************************************
void  getch(void)
{
#ifndef REMOTE_DEBUG
  while(getchar() == 0xFFFF );
#endif
}
//*********************************************************************

void ModeTest(void)
{
  WORD  i,j;

  if(Mode.mode == MODE13H)
  {
    Clear13H(0);
  }
  else if(Mode.attrib & TVU_PLANAR)
  {
    PlanarClear(0);
  }
  else if(Mode.attrib & TVU_UNCHAINED)
  {
    UnchainedClear(0);
  }
   /* Print mode stats
    *
    */

  drawrect(0,0,Mode.width-1,Mode.height-1,15);
  for(i = 50; i < Mode.height; i += 100)
  {
    hline(0,10,i,15);
    hline(0,25,i+50,15);
  }
  for(i = 40; i < Mode.width; i += 80)
  {
    vline(0,15,i,15);
    vline(0,30,i+40,15);
  }
  if(Mode.colors == 2)
  {
    int x,y;
    x = Mode.width - 420;
    y = Mode.height - 220;
    fillrect(x,y,x+200,y+200,0);
    x+=200;
    fillrect(x,y,x+200,y+200,15);
    drawrect(x-200,y,x+200,y+200,15);
  }
  else if(Mode.colors == 16)
  {
    int x,y;
    x = Mode.width - 522;
    y = Mode.height - 135;
    for(i = 0; i < 8; i++)
    {
      fillrect(x,y,x+64,y+64,i);
      x+=64;
    }
    x = Mode.width - 522;
    y += 64;
    for(i = 8; i < 16; i++)
    {
      fillrect(x,y,x+64,y+64,i);
      x+=64;
    }
    drawrect(x-512,y-64,x,y+64,15);
  }
  else if(Mode.colors == 256)
  {
    BYTE  k;
    int   x,y;

    x = Mode.width - 165;
    y = Mode.height - 165;
    k = 0;
    for(i = 0; i < 16; i++)
    {
      for(j = 0; j < 16; j++)
      {
        fillrect(x,y,x+10,y+10,k);
        x+=10;
        k++;
      }
      x = Mode.width - 165;
      y += 10;
    }
    drawrect(Mode.width - 165,Mode.height - 165,Mode.width -5,Mode.height - 5,15);
  }
  // Only MODE12H, but work also 0EH,10H,11H MODE_I
  if(Mode.mode == MODE12H)
  {
    drawellipse(100, 100, 35, 35, 0x0E);
    drawellipse(100, 100, 37, 37, 0x0F);
    drawellipsefilled(150, 150, 40, 40, 0x0A);
    DrawCircle(300,100,50,0x0A);
    PutChar12h(4,12,'*',0x0D,0x00);
    PutString12h(2,45,"Testing Testing Testing",0x0E,0x00);
    SetFont8x8();
    PutString12h(2,65,"Testing Testing Testing",0x0E,0x00);
  }
}
//*********************************************************************

void TextTest(void)
{
   WORD  v;
   TextClear(0x1F);
//   Gotoxy(1,1);
   if (Mode.mode == MODE00H)
   {
      // ** NOTE ** the gotoxy's here are a hack so that i could use the
      // standard C functions to program this mode.  Normally you would just
      // calculate the proper address and display the text but since DOS still
      // thinks we are in mode 03h (it checks the BIOS), this is necessary.
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode: 00H        \n");
      myprintf_PSTR("Width: 40   Height: 25\n");
      myprintf_PSTR("Bytes per screen: 2000\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE03H)
   {
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode: 03H        \n");
      myprintf_PSTR("Width: 80   Height: 25\n");
      myprintf_PSTR("Bytes per screen: 4000\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE_J)
   {
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode K           \n");
      myprintf_PSTR("Width: 80   Height: 43\n");
      myprintf_PSTR("Bytes per screen: 3440\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE_K)
   {
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode K           \n");
      myprintf_PSTR("Width: 80   Height: 50\n");
      myprintf_PSTR("Bytes per screen: 4000\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE_L)
   {
      // ** NOTE ** the gotoxy's here are a hack so that i could use the
      // standard C functions to program this mode.  Normally you would just
      // calculate the proper address and display the text but since DOS still
      // thinks we are in mode 03h (it checks the BIOS), this is necessary.
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode L           \n");
      myprintf_PSTR("Width: 40   Height: 43\n");
      myprintf_PSTR("Bytes per screen: 3440\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE_M)
   {
      // ** NOTE ** the gotoxy's here are a hack so that i could use the
      // standard C functions to program this mode.  Normally you would just
      // calculate the proper address and display the text but since DOS still
      // thinks we are in mode 03h (it checks the BIOS), this is necessary.
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode K           \n");
      myprintf_PSTR("Width: 40   Height: 50\n");
      myprintf_PSTR("Bytes per screen: 4000\n");
      myprintf_PSTR("Number of pages: 8    \n");
      myprintf_PSTR("\n");
   }
   else if (Mode.mode == MODE10AH)
   {
      myprintf_PSTR("Ŀ\n");
      myprintf_PSTR("Text Mode: 10AH       \n");
      myprintf_PSTR("Width: 132  Height: 43\n");
      myprintf_PSTR("Bytes per screen:11352\n");
      myprintf_PSTR("Number of pages: 2    \n");
      myprintf_PSTR("\n");
   }
   v = 0;
   do
   {
      SetColor(v);
      putchar('*');
      v++;
   }while(v<256);

   v = 0;
   do
   {
      SetColor(v);
      putchar('8');
      v++;
   }while(v<256);
}
//*********************************************************************
void  CharPrnOut(void)
{
  char  c=0;
  int   i=-1;

  TextClear(0x0F);
  CursorOn();
  while(i!=ESCAPE)
  {
    if((int)((i=getchar()))!=-1)
    {
      Gotoxy(1,1);
      if(i == 0xE074) c--;
      if(i == 0xE06B) c++;
//        if(i == '\r') putchar('\n');
      putchar(c);
      printf_P("  chr:%3d",(WORD)c);
    }
  }
}
//*********************************************************************
void MainScreen(void)
{
    CursorOff();
    TextClear(0x0F);
//    myprintf_P("\x05\x0D%S chip detected !\x05\x0F\n",ChpMsg[ChipType]);

    printf_P(ChpMsg[ChipType]);myprintf_PSTR(" chip detected !\n");
    myprintf_PSTR("Tauron VGA Utilities v3.0 \x05\x0E Running on ATMEGA128 !\n"
                   "\x05\x09Thanks to Jeffrey Morgan.  All Rights Reserved.\n");
    SetForeColor(12);
    myprintf_PSTR("Modes with a ! are not implemented      Modes with a x are unchained\r\n");
    SetForeColor(7);
    myprintf_PSTR("Select a video mode to test:\n"
          "Key              Videomode          Key              Videomode\n"
          "================================================================================"
          " 0) 00H, 01H -- 40 x 25 x 16         xF) Mode D   -- 360 x 200 x 256\n"
          " 1) Mode L   -- 40 x 43 x 16         xG) Mode E   -- 360 x 240 x 256\n"
          " 2) Mode M   -- 40 x 50 x 16         xH) Mode F   -- 360 x 350 x 256\n"
          "!3) 07H      -- 80 x 25 x 2          xI) Mode G   -- 360 x 400 x 256\n"
          " 4) 02H, 03H -- 80 x 25 x 16         xJ) Mode H   -- 360 x 480 x 256\n"
          " 5) Mode J   -- 80 x 43 x 16          K) 06H      -- 640 x 200 x 2\n"
          " 6) Mode K   -- 80 x 50 x 16         !L) 0FH      -- 640 x 350 x 2\n"
          " 7) 04H, 05H -- 320 x 200 x 4         M) 11H      -- 640 x 480 x 2\n"
          " 8) 0DH      -- 320 x 200 x 16        N) 0EH      -- 640 x 200 x 16\n"
          " 9) 13H      -- 320 x 200 x 256       O) 10H      -- 640 x 350 x 16\n"
          "xA) Chain 4  -- 320 x 200 x 256       P) Mode I   -- 640 x 400 x 16\n"
          "xB) Mode X   -- 320 x 240 x 256       Q) 12H      -- 640 x 480 x 16\n"
          "xC) Mode A   -- 320 x 350 x 256\n"
          "xD) Mode B   -- 320 x 400 x 256       R) View char code\n"
          "xE) Mode C   -- 320 x 480 x 256\n"
          "===============================================================================\n"
          "Hit 'ESC' to exit.  Press a key [0-9 or A-O]>");
}

//*********************************************************************
void  TauronTests(void)
{

  WORD  key=1,ok=1;

  TextClear(0x0F);
  MainScreen();
  while(ok)
  {
#ifdef REMOTE_DEBUG
    key = Remote();
#else
    if( (key = getchar()) == 0 )
      key = 256 * getchar();
#endif
    switch( key )
    {
    case ESCAPE :
      ok = 0; TextClear(0x0F); break;
    case '0':
      SetVideoMode(MODE00H); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '1':
      SetVideoMode(MODE_L); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '2':
      CursorOn();
      SetVideoMode(MODE_M); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '4'          :
      SetVideoMode(MODE03H); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '5':
      SetVideoMode(MODE_J); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '6':
      SetVideoMode(MODE_K); TextTest(); getch();
      SetMode03h(); MainScreen(); break;
    case '7':
      SetVideoMode(MODE04H); Clear04H(); getch();
      SetMode03h(); MainScreen(); break;
    case '8'          :
      SetVideoMode(MODE0DH); Clear0DH(12); /*ModeTest();*/ getch();
      SetMode03h(); MainScreen(); break;
    case '9':
      SetVideoMode(MODE13H); ModeTest(); getch();
      SetMode03h(); MainScreen(); break;
    case 'a': case 'A':
       SetVideoMode(CHAIN4); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'b': case 'B':
       SetVideoMode(MODE_X); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'c': case 'C':
       SetVideoMode(MODE_A); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'd': case 'D':
       SetVideoMode(MODE_B); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'e': case 'E':
       SetVideoMode(MODE_C); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'f': case 'F':
       SetVideoMode(MODE_D); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'g': case 'G':
       SetVideoMode(MODE_E); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'h': case 'H':
       SetVideoMode(MODE_F); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'i': case 'I':
       SetVideoMode(MODE_G); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'j': case 'J':
       SetVideoMode(MODE_H); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'k': case 'K':
       SetVideoMode(MODE06H); Clear06H(); getch();
       SetMode03h(); MainScreen(); break;
    case 'm': case 'M':
       SetVideoMode(MODE11H); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'n': case 'N':
       SetVideoMode(MODE0EH); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'o': case 'O':
       SetVideoMode(MODE10H); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'p': case 'P':
       SetVideoMode(MODE_I); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'q': case 'Q':
       SetVideoMode(MODE12H); ModeTest(); getch();
       SetMode03h(); MainScreen(); break;
    case 'r': case 'R':
       CharPrnOut(); break;
    default:  break;
    }
  }
}
